//**********************************************************************
//  aipGood.cpp  -  function bodies and global functions for aipGood.h
//
//  aipGood.h implements goodness.
//
//  Copyright (c)  1999, 2005  Brian Marshall
//
//  See the license at end of this file.
//
//  Developers/Contributers:
//    [BRM] Brian Marshall - Calgary - bmarshal@agt.net
//
//  05/09/07  [BRM] remove importance and likelihood
//  05/07/31  [BRM] rework began
//  99/05/01  [BRM] naming convention changed
//  99/03/07  [BRM] development began
//
//----------------------------------------------------------------------

#include "aipGood.h"

// #include <iostream>
// using namespace std;

//======================================================================
//  aipGBase.

//    All function bodies are in the header file.


//======================================================================
//  aipGoodness   -   How good or bad something is.
//
//----------------------------------------------------------------------
//  Calculate the value of this goodness multiplied by a fraction.

aipGoodness aipGoodness::calc_fraction (long numerator, 
                                        long denominator) {

  if (is_forbidden()) return aipForbidden;

  if (denominator == 0) return aipNeutral;

  return aipGoodness ( (val() * numerator) / denominator );

}

//----------------------------------------------------------------------
//  Return a description of this aipGoodness.

const char * aipGoodness::description () const {

//  log(" "); log(val()); log(" ");

  if (*this <= aipQuiteBad) {

    if (*this <= aipForbidden) {
      return "Forbidden";
    } else if (*this <= aipVeryVeryBad) {
      return "Very Very Bad";
    } else if (*this <= aipVeryBad) {
      return "Very Bad";
    } else if (*this <= aipBad) {
      return "Bad";
    } else {
      return "Quite Bad";
    }

  } else if (*this <= aipVerySlightlyBad) {

    if (*this <= aipPrettyBad) {
      return "Pretty Bad";
    } else if (*this <= aipFairlyBad) {
      return "Fairly Bad";
    } else if (*this <= aipSomewhatBad) {
      return "Somewhat Bad";
    } else if (*this <= aipSlightlyBad) {
      return "Slightly Bad";
    } else {
      return "Very Slightly Bad";
    }

  } else if (*this >= aipQuiteGood) {

    if (*this >= aipManditory) {
      return "Manditory";
    } else if (*this >= aipVeryVeryGood) {
      return "Very Very Good";
    } else if (*this >= aipVeryGood) {
      return "Very Good";
    } else if (*this >= aipGood) {
      return "Good";
    } else {
      return "Quite Good";
    }

  } else if (*this >= aipVerySlightlyGood) {

    if (*this >= aipPrettyGood) {
      return "Pretty Good";
    } else if (*this >= aipFairlyGood) {
      return "Fairly Good";
    } else if (*this >= aipSomewhatGood) {
      return "Somewhat Good";
    } else if (*this >= aipSlightlyGood) {
      return "Slightly Good";
    } else {
      return "Very Slightly Good";
    }

  }

  return "Neutral";

}

//======================================================================
//  Global functions
//
//----------------------------------------------------------------------
//      Goodness plus a Goodness yields a Goodness

aipGoodness operator + (const aipGoodness& x, 
                        const aipGoodness& y) {
  aipGoodness z = x;
  return (z += y);
}

aipGoodness operator - (const aipGoodness& x, 
                        const aipGoodness& y) {
  aipGoodness z = x;
  return (z -= y);
}


//----------------------------------------------------------------------
//======================================================================
//                           License
//
//   Permission is hereby granted, free of charge, to any 
//   person obtaining a copy of this software and associated 
//   documentation files (the "Software"), to deal in the Software 
//   without restriction, including without limitation the rights 
//   to use, copy, modify, merge, publish, distribute, sublicense, 
//   and/or sell copies of the Software, and to permit persons to 
//   whom the Software is furnished to do so, subject to the 
//   following conditions:
//
//   The copyright notice and this license shall be included in all 
//   copies or substantial portions of the Software.
//
//   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, 
//   EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES 
//   OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND 
//   NON-INFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT 
//   HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, 
//   WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
//   FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR 
//   OTHER DEALINGS IN THE SOFTWARE.
//
//
//**********************************************************************

