//**********************************************************************
//  aipDecision.cpp  -  function bodies for aipDecision.h
//
//  Copyright (c)  1999, 2005, 2008  Brian Marshall
//
//  See the license at end of this file.
//
//  Developers/Contributers:
//    [BRM] Brian Marshall - Calgary - bmarshal@agt.net
//
//  08/01/01  [BRM] added logic for trivial decisions
//  05/11/19  [BRM] decision take_msg() calls pandemonium take_msg()
//  05/11/07  [BRM] changed following comment
//                  support for decisions sharing a set of options
//  05/10/28  [BRM] can choose randomly from multiple best options
//  05/09/17  [BRM] development began
//
//----------------------------------------------------------------------

#include "aipDecision.h"

#include <string.h>
#include <iostream>
using namespace std;

//======================================================================
//  aipDecision
//
//----------------------------------------------------------------------
//  Constructor

aipDecision::aipDecision () {

  m_owner = 0;

  m_options = new aipPandemonium;

  m_is_trivial = 0;

}

//----------------------------------------------------------------------
//  Destructor

aipDecision::~aipDecision () {

  if (m_options) delete m_options;

}

//----------------------------------------------------------------------
//  add_option

void aipDecision::add_option (aipOption *x) { 

  if (!x) return;

  if ( x->owner() ) {
    x->set_is_shared();
  } else {
    x->set_owner(this);
  }

  m_options->add(x);

}

//----------------------------------------------------------------------
//  take_msg  - take a message and distribute to options
//
//  Overriding functions gemerally must call this function.

void aipDecision::take_msg (aipMsg *m) {

  m_options->take_msg(m);

}

//----------------------------------------------------------------------
//  option_iterator - return an iterator to the options of this decision.

aipOptionItr aipDecision::option_iterator() const {

  aipOptionItr i(option_pandemonium());

  return i;

}

//----------------------------------------------------------------------
//  decide  -  choose an option

aipOption * aipDecision::decide() {

  aipOption *best_opt = 0;
  aipG       best_g = aipForbidden;
  long       num_best = 0;

  aipOptionItr itr = option_iterator();
  for ( aipOption *a = itr.first(); a; a = itr.next() ) {
    if ( a->is_shared() && a->chooser() ) continue;
    aipG g = a->g_opt();
    if ( g.is_forbidden() ) continue;
    if ( !best_opt || g > best_g ||
         ( g == best_g && is_one_chance_in_x(++num_best) ) ) {
      if ( !best_opt || g > best_g ) num_best = 1;
      best_opt = a;
      best_g = g;
      if (m_is_trivial) break;
    }
  }

  if (best_opt) {
    best_opt->set_chooser(this);
  }

  return best_opt;

}


//======================================================================
//  aipOption
//
//    all function bodies are declared in the header file
//
//======================================================================
//  aipOptionItr  -  Option iterator
//
//    All function bodies are in the header file
//
//======================================================================
//  aipDecisionItr  -  Decision iterator
//
//    All function bodies are in the header file
//
//======================================================================
//                           License
//
//   Permission is hereby granted, free of charge, to any 
//   person obtaining a copy of this software and associated 
//   documentation files (the "Software"), to deal in the Software 
//   without restriction, including without limitation the rights 
//   to use, copy, modify, merge, publish, distribute, sublicense, 
//   and/or sell copies of the Software, and to permit persons to 
//   whom the Software is furnished to do so, subject to the 
//   following conditions:
//
//   The copyright notice and this license shall be included in all 
//   copies or substantial portions of the Software.
//
//   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, 
//   EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES 
//   OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND 
//   NON-INFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT 
//   HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, 
//   WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
//   FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR 
//   OTHER DEALINGS IN THE SOFTWARE.
//
//
//**********************************************************************
