;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;                                                                 ;;;
;;;                     S c o o p s                                 ;;;
;;;                                                                 ;;;
;;;                                                                 ;;;
;;;		Rewritten 5/20/87 for cscheme			    ;;;
;;;		by Steve Sherin--U of P				    ;;;
;;;                   File : utl.scm                                ;;;
;;;                                                                 ;;;
;;;                 Amitabh Srivastava                              ;;;
;;;                                                                 ;;;
;;;    This file contains misc. routines                            ;;;
;;;                                                                 ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


;;;   Error handler. Looks up the error message in the table and
;;;   prints it.

    (define error-handler
      (let ((error-table
        (let ((table (make-vector 8)))
          (vector-set! table 0 " Invalid class definition ")
	  (vector-set! table 1 " Invalid option ")
	  (vector-set! table 2 " Class not defined ")
	  (vector-set! table 3 " Method has been deleted ")
	  (vector-set! table 4 " Method is not present ")
	  (vector-set! table 5 " Variable is not present")
          (vector-set! table 6 " Not a Scoops Class")
          (vector-set! table 7 " Class not compiled ")
	  table)))
	(lambda (msg number flag)
	  (if flag
	      (error (vector-ref error-table number) msg)
	      (breakpoint (vector-ref error-table number) msg)))))


;;;   some functions defined globally which will be moved locally later

        (define %sc-class-description
           (lambda (class)
              (writeln " ")
              (writeln "    CLASS DESCRIPTION    ")
              (writeln "    ==================    ")
              (writeln " ")
              (writeln " NAME            : " (%sc-name class))
              (writeln " CLASS VARS      : "
                       (mapcar car (%sc-allcvs class)))
              (writeln " INSTANCE VARS   : "
                       (mapcar car (%sc-allivs class)))
              (writeln " METHODS         : "
                       (mapcar car (%sc-method-structure class)))
              (writeln " MIXINS          : " (%sc-mixins class))
              (writeln " CLASS COMPILED  : " (%sc-class-compiled class))
              (writeln " CLASS INHERITED : " (%sc-class-inherited class))
           ))
;;;

    (define %sc-inst-desc
       (lambda (inst)
         (letrec ((class (access %sc-class inst))
                  (printvars
                    (lambda (f1 f2)
		      (if f1			; another var
			  (begin
			   (writeln "   " (caar f1) " : "
				(cadr (assq (caar f1) f2)))
;; environment bindings in list form vs. pair form.  Steve Sherin
			   (printvars (cdr f1) f2))
			    *the-non-printing-object*))))
            (writeln " ")
	    (writeln "  INSTANCE DESCRIPTION      ")
	    (writeln "  ====================      ")
	    (writeln " ")
 	    (writeln "  Instance of Class :  " (%sc-name class))
	    (writeln " ")
	    (writeln "  Class Variables : ")
            (printvars (%sc-allcvs class)
		       (environment-bindings (%sc-class-env class)))
            (writeln " ")
	    (writeln "  Instance Variables :")
            (printvars (%sc-allivs class) (environment-bindings inst))
           )))
;;;

(define describe
  (lambda (class-inst)
    (if (vector? class-inst)
        (begin
          (%scoops-chk-class class-inst)
          (%sc-class-description class-inst))
        (%sc-inst-desc class-inst))))
;;;

(define %scoops-chk-class-compiled
  (lambda (name class)
    (or (%sc-class-compiled class)
        (error-handler name 7 #!true))))

;;; (rename-class (class new-name))
(syntax-table-define system-global-syntax-table 'rename-class (macro e
	(let ((class (caar e))
       	      (new-name (cadar e)))
	`(begin
		(%sc-name->class ',class)
		(%sc-set-name ,class ',new-name)
		(eval (define ,new-name ,class) user-initial-environment)
		',new-name))))

;;; (getcv class var)
(syntax-table-define system-global-syntax-table 'getcv (macro e
    (let ((class (car e))
	  (var (cadr e)))
	`(begin
         (and (%sc-name->class ',class)
              (%scoops-chk-class-compiled ',class ,class))
	 ((access ,(%sc-concat "GET-" var) (%sc-method-env ,class)))))))

;;; (setcv class var val)
(syntax-table-define system-global-syntax-table 'setcv (macro e
    (let ((class (car e))
	  (var (cadr e))
	  (val (caddr e)))
	`(begin
         (and (%sc-name->class ',class)
              (%scoops-chk-class-compiled ',class ,class))
	 ((access ,(%sc-concat "SET-" var) (%sc-method-env ,class)) ,val)))))

;;; (class-compiled? class)
(define class-compiled?
  (lambda (class)
    (%scoops-chk-class class)
    (%sc-class-compiled class)))

;;;  (class-of-object object)
(syntax-table-define system-global-syntax-table 'class-of-object
  (macro e
    `(%sc-name (access %sc-class ,(car e)))))

;;; (name->class name)
(syntax-table-define system-global-syntax-table 'name->class
  (macro e
    `(%sc-name->class ,(car e))))

;;;

(define %sc-class-info
  (lambda (fn)
    (lambda (class)
      (%scoops-chk-class class)
      (mapcar car (fn class)))))
;;;

(define methods (%sc-class-info %sc-method-values))
;;;

(define all-methods (%sc-class-info %sc-method-structure))
;;;

(define classvars (%sc-class-info %sc-cv))
;;;

(define all-classvars (%sc-class-info %sc-allcvs))
;;;

(define instvars (%sc-class-info %sc-iv))
;;;

(define all-instvars (%sc-class-info %sc-allivs))
;;;

(define mixins
  (lambda (class)
    (%scoops-chk-class class)
    (%sc-mixins class)))
;;;


;;; writeln (not defined in cscheme)
(define (writeln . args)

	(define (writeln1 args)
		(if (not (null? args))
		(begin
			(display (car args))
			(writeln1 (cdr args)))))
 
	(begin
		(writeln1 args)
		(newline)))
