;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;                                                                 ;;;
;;;                     S c o o p s                                 ;;;
;;;                                                                 ;;;
;;;                                                                 ;;;
;;;		Rewritten 5/20/87 for cscheme			    ;;;
;;;		by Steve Sherin--U of P				    ;;;
;;;                   File : methods.scm                            ;;;
;;;                                                                 ;;;
;;;                 Amitabh Srivastava                              ;;;
;;;                                                                 ;;;
;;;    This file handles the addition/redefinition of methods.      ;;;
;;;                                                                 ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


;;; is class1 before class2 in class ?
;;; class1  is not equal to class2

(define %before
  (lambda (class1 class2 class)
    (or (eq? class1 class)
        (memq class2 (memq class1 (%sc-mixins (%sc-name->class class)))))))
;;;

(syntax-table-define system-global-syntax-table 'define-method (macro e
	(let ((class-name (caar e))
	      (method-name (cadar e))
	      (formal-list (cadr e))
	      (body (cddr e)))
	`(%sc-class-add-method
	',class-name
	',method-name
	',class-name
	',class-name
	(append (list 'lambda ',formal-list) ',body) 
	(lambda (env quoted-val)
	  (let* ((method-name ',method-name)
		 (temp `(in-package ,env (define ,method-name
		 	 ,quoted-val))))
		(eval temp (the-environment)))
)))))
;;;

(define %sc-class-add-method
  (lambda (class-name method-name method-class mixin-class method assigner)
    (let ((class (%sc-name->class class-name)))
	(begin
         (let ((temp (assq method-name (%sc-method-values class))))
	  (if temp
		(set-cdr! temp method)
            (%sc-set-method-values class
               (cons (cons method-name method) (%sc-method-values class))))))
	   (%compiled-add-method class-name method-name method-class mixin-class
                         method assigner))))
;;;

(define %inform-subclasses
  (lambda (class-name method-name method-class mixin-class method assigner)
    ((rec loop
       (lambda (class-name method-name method-class mixin-class
                                       method assigner subclass)
         (if subclass
             (begin
                (%compiled-add-method
                  (car subclass) method-name method-class class-name
                  method assigner)
                (loop class-name method-name method-class mixin-class
                      method assigner
                      (cdr subclass))))))
     class-name method-name method-class mixin-class method assigner
     (%sc-subclasses (%sc-name->class class-name)))))
;;;

(define %compiled-add-method
  (lambda (class-name method-name method-class mixin-class method assigner)
    (letrec
      ((class (%sc-name->class class-name))

       (insert-entry
         (lambda (previous current)
           (cond ((null? current)
                  (set-cdr! previous
                     (cons (cons method-class mixin-class) '())))
                 ((eq? mixin-class (cdar current))
                  (set-car! (car current) method-class))
                 ((%before mixin-class (cdar current)
                           class-name)
                  (set-cdr! previous
                     (cons (cons method-class mixin-class) current)))
                 (else '()))))


       (loop-insert
         (lambda (previous current)
           (if (not (insert-entry previous current))
               (loop-insert (current) (cdr current)))))

       (insert
         (lambda (entry)
           (if (insert-entry entry (cdr entry))  ;;; insert at head
               (add-to-environment)
               (loop-insert (cdr entry) (cddr entry)))))

       (add-to-environment
         (lambda ()
	 (begin
           (if (%sc-class-compiled class)
                (assigner (%sc-method-env class) method))
           (if (%sc-subclasses class)
               (%inform-subclasses class-name method-name method-class
                                  mixin-class method assigner)))))

       (add-entry
         (lambda ()
	 (begin
           (%sc-set-method-structure class
             (cons (list method-name (cons method-class mixin-class))
                   (%sc-method-structure class)))
           (add-to-environment))))
      )

      (let ((method-entry (assq method-name (%sc-method-structure class))))
        (if method-entry
            (insert method-entry)
            (add-entry))
        method-name))))
