;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;                                                                 ;;;
;;;                     S c o o p s                                 ;;;
;;;                                                                 ;;;
;;;                                                                 ;;;
;;;		Rewritten 5/20/87 for cscheme			    ;;;
;;;		by Steve Sherin--U of P				    ;;;
;;;                   File : meth2.scm                              ;;;
;;;                                                                 ;;;
;;;                 Amitabh Srivastava                              ;;;
;;;                                                                 ;;;
;;;    This file handles the deletion of a method from a class.     ;;;
;;;                                                                 ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(syntax-table-define system-global-syntax-table 'delete-method (macro e
	(let ((class-name (caar e))
	      (method-name (cadar e)))
	`(%sc-class-del-method
	',class-name
	',method-name
	',class-name
	',class-name
	(LAMBDA (ENV VAL)
	  (SET! (ACCESS ,method-name ENV) VAL))
	#!false))))
;;;

(define %deleted-method
  (lambda (name)
    (lambda args
      (error-handler name 3 #!TRUE))))
;;;

(define %sc-class-del-method
  (lambda (class-name method-name method-class mixin-class assigner del-value)
    (let ((class (%sc-name->class class-name)))
      (let ((temp (assq method-name (%sc-method-values class))))
	(if temp
	 (begin
          (%sc-set-method-values class
               (delq! temp (%sc-method-values class)))
          (%compiled-del-method class-name method-name method-class mixin-class
                               assigner del-value))

	(error-handler method-name 4 #!true))))))
;;;

(define %inform-del-subclasses
  (lambda (class-name method-name method-class mixin-class assigner del-value)
    ((rec loop
       (lambda (class-name method-name method-class mixin-class assigner
                del-value subclass)
         (if subclass
             (begin
                (%compiled-del-method (car subclass) method-name
                          method-class class-name assigner del-value)
                (loop class-name method-name method-class mixin-class assigner
                      del-value (cdr subclass))))))
     class-name method-name method-class mixin-class assigner del-value
     (%sc-subclasses (%sc-name->class class-name)))))
;;;

(define %compiled-del-method
  (lambda (class-name method-name method-class mixin-class assigner del-value)
    (let ((class (%sc-name->class class-name)))
      (letrec
        ((delete-entry
           (lambda (previous current)
             (cond ((eq? mixin-class (cdar current))
                    (set-cdr! previous (cdr current)) #!TRUE)
                   (else #!FALSE))))

         (loop-delete
           (lambda (previous current)
             (cond ((or (null? current)
                        (%before mixin-class (cdar previous)
                                 class-name))
                    (error-handler method-name 4 #!TRUE))
                   ((delete-entry previous current) #!TRUE)
                   (else (loop-delete current (cdr current))))))

         (delete
           (lambda (entry)
             (if (delete-entry entry (cdr entry))  ;;; delete at head
                 (modify-environment entry)
                 (loop-delete (cdr entry) (cddr entry)))))

       (modify-environment
         (lambda (entry)
	   (cond ((null? (cdr entry))
		  (%sc-set-method-structure class
		    (delq! (assq method-name (%sc-method-structure class))
			   (%sc-method-structure class)))
                  (if (%sc-class-compiled class)
                      (assigner (%sc-method-env class)
                                (or del-value
                                    (set! del-value
                                          (%deleted-method method-name)))))
		  (if (%sc-subclasses class)
		      (%inform-del-subclasses class-name method-name
			       method-class mixin-class assigner del-value)))
		 (else
		  (let ((meth-value
			 (%sc-get-meth-value method-name
					     (%sc-name->class (caadr entry)))))
		    (if (%sc-class-compiled class)
			(assigner (%sc-method-env class) meth-value))
		    (if (%sc-subclasses class)
			(%inform-subclasses class-name
					    method-name
					    method-class
					    mixin-class
					    meth-value assigner)))))))
      )

      (let ((method-entry (assq method-name (%sc-method-structure class))))
        (if method-entry
            (delete method-entry)
            (error-handler method-name 4 #!TRUE))
        method-name)))))
