;;-*-mode:lisp-*-
;; For use with the ORACLE CALL INTERFACE (OCI) interface to SIOD.
;;
;; siod -g0 -h150000 -isql_oracle.scm
;;
;; Procedures: (oracle-sql-init "username" "password")
;;             (oracle-sql "string") => result of operation.
;;             (oracle-show-tables) => list user tables.

(define *oracle-sql-username* "system")
(define *oracle-sql-password* "manager")
(define *oracle-sql-association* nil)

(define (oracle-sql-init . args)
  (if (null? *oracle-sql-association*)
      (begin (oracle-login
	      (or (car args) *oracle-sql-username*)
	      (if (cdr args) (car (cdr args)) *oracle-sql-password*))
	     (set! *oracle-sql-association* t))))

(define (oracle-sql str)
  (oracle-sql-init)
  (let ((s nil)
	(n nil)
	(j 0)
	(result nil)
	(tmp nil))
    (set! s (oracle-sql-prepare str))
    (set! n (oracle-nselects s))
    (oracle-execute s)
    (if (> n 0)
	(begin (while (< j n)
		 (set! tmp (cons (oracle-select-column-name s j) tmp))
		 (set! j (+ 1 j)))
	       (set! result (cons (nreverse tmp) nil))
	       (while (oracle-fetch s)
		 (set! j 0)
		 (set! tmp nil)
		 (while (< j n)
		   (set! tmp (cons (oracle-select-column-value s j) tmp))
		   (set! j (+ 1 j)))
		 (set! result (cons (nreverse tmp) result)))
	       (set! result (nreverse result))))
    (oracle-sql-release s)
    result))

(define (oracle-show-tables)
  (oracle-sql "select * from user_catalog"))
