(defun make-cdir-file (filename)
  (switch-to-buffer "*foo*")
  (erase-buffer)
  (call-process "/bin/sh" nil t nil "-c" "find * -type d -print")
  (make-cdir-buffer)
  (write-file filename))

(defun make-cdir-buffer ()
  (goto-char (point-min))
  (replace-string "." "$")
  (goto-char (point-min))
  (replace-string "/" ".")
  (mark-whole-buffer)
  (upcase-region (region-beginning) (region-end))
  (while (not (eobp))
    (make-cdir-line)))

(defun make-cdir-line ()
  (insert "CREATE/DIRECTORY [-.")
  (end-of-line)
  (insert "]")
  (forward-line 1))

(make-cdir-file "make_dirs.com")