#| -*-Scheme-*-

$Header: eqset.scm,v 1.1 87/10/16 17:21:26 GMT cph Exp $

Copyright (c) 1987 Massachusetts Institute of Technology

This material was developed by the Scheme project at the Massachusetts
Institute of Technology, Department of Electrical Engineering and
Computer Science.  Permission to copy this software, to redistribute
it, and to use it for any purpose is granted, subject to the following
restrictions and understandings.

1. Any copy made of this software must include this copyright notice
in full.

2. Users of this software agree to make their best efforts (a) to
return to the MIT Scheme project any improvements or extensions that
they make, so that these may be included in future releases; and (b)
to inform MIT of noteworthy uses of this software.

3. All materials developed as a consequence of the use of this
software shall duly acknowledge such use, in accordance with the usual
standards of acknowledging credit in academic research.

4. MIT has made no warrantee or representation that the operation of
this software will be error-free, and MIT is under no obligation to
provide any services, by way of maintenance, update, or otherwise.

5. In conjunction with products arising from the use of this material,
there shall be no use of the name of the Massachusetts Institute of
Technology nor of any adaptation thereof in any advertising,
promotional, or sales literature without prior written consent from
MIT in each case. |#

;;;; EQ? Membership Sets

(declare (usual-integrations))

(define (eq?-adjoin x set)
  (if (memq x set)
      set
      (cons x set)))

(define (eq?-remove x set)
  (cond ((null? set) '())
	((eq? x (car set)) (cdr set))
	(else (cons (car set) (eq?-remove x (cdr set))))))

(define (eq?-difference set1 set2)
  (cond ((null? set1) '())
	((memq (car set1) set2) (eq?-difference (cdr set1) set2))
	(else (cons (car set1) (eq?-difference (cdr set1) set2)))))

(define (eq?-union set1 set2)
  (cond ((null? set1) set2)
	((memq (car set1) set2) (eq?-union (cdr set1) set2))
	(else (cons (car set1) (eq?-union (cdr set1) set2)))))

(define (eq?-intersection set1 set2)
  (cond ((null? set1) '())
	((memq (car set1) set2)
	 (cons (car set1) (eq?-intersection (cdr set1) set2)))
	(else (eq?-intersection (cdr set1) set2))))

(define (eq?-disjoint? set1 set2)
  (cond ((null? set1) #!TRUE)
	((memq (car set1) set2) #!FALSE)
	(else (eq?-disjoint? (cdr set1) set2))))

(define (eq?-subset? set1 set2)
  (cond ((null? set1) #!TRUE)
	((memq (car set1) set2) (eq?-subset? (cdr set1) set2))
	(else #!FALSE)))

(define (eq?-same-set? set1 set2)
  (and (eq?-subset? set1 set2)
       (eq?-subset? set2 set1)))