;;; -*-Scheme-*-
;;;
;;;	$Header$
;;;
;;;	Copyright (c) 1987 Massachusetts Institute of Technology
;;;
;;;	This material was developed by the Scheme project at the
;;;	Massachusetts Institute of Technology, Department of
;;;	Electrical Engineering and Computer Science.  Permission to
;;;	copy this software, to redistribute it, and to use it for any
;;;	purpose is granted, subject to the following restrictions and
;;;	understandings.
;;;
;;;	1. Any copy made of this software must include this copyright
;;;	notice in full.
;;;
;;;	2. Users of this software agree to make their best efforts (a)
;;;	to return to the MIT Scheme project any improvements or
;;;	extensions that they make, so that these may be included in
;;;	future releases; and (b) to inform MIT of noteworthy uses of
;;;	this software.
;;;
;;;	3. All materials developed as a consequence of the use of this
;;;	software shall duly acknowledge such use, in accordance with
;;;	the usual standards of acknowledging credit in academic
;;;	research.
;;;
;;;	4. MIT has made no warrantee or representation that the
;;;	operation of this software will be error-free, and MIT is
;;;	under no obligation to provide any services, by way of
;;;	maintenance, update, or otherwise.
;;;
;;;	5. In conjunction with products arising from the use of this
;;;	material, there shall be no use of the name of the
;;;	Massachusetts Institute of Technology nor of any adaptation
;;;	thereof in any advertising, promotional, or sales literature
;;;	without prior written consent from MIT in each case.
;;;

;;;; Apropos

(declare (usual-integrations))

(define apropos)
(define apropos-list)
(define apropos-sort)
(let ()

(set! apropos
(named-lambda (apropos string #!optional environment unbound-also?)
  "Prints the symbols whose names contain `string' as a substring.
Also prints information about what they are bound to in `environment',
which defaults to `system-global-environment'.  Third optional argument,
if given and not false, means print unbound symbols also."
  (if (unassigned? environment) (set! environment system-global-environment))
  (if (unassigned? unbound-also?) (set! unbound-also? false))
  (let ((table (symbol-table)))
    (let per-bucket ((index (-1+ (vector-length table))))
      (if (>= index 0)
	  (begin
	    (let per-symbol ((bucket (vector-ref table index)))
	      (if (not (null? bucket))
		  (begin
		    (if (and (or unbound-also?
				 (not (lexical-unbound? environment
							(car bucket))))
			     (substring-ci? string
					    (symbol->string (car bucket))))
			(write-symbol (car bucket) environment))
		    (per-symbol (cdr bucket)))))
	    (per-bucket (-1+ index))))))
  *the-non-printing-object*))

(set! apropos-list
(named-lambda (apropos-list string #!optional environment unbound-also?)
  "Like `apropos', but returns a list of the symbols instead of printing them."
  (if (unassigned? environment) (set! environment system-global-environment))
  (if (unassigned? unbound-also?) (set! unbound-also? false))
  (let ((table (symbol-table)))
    (let per-bucket ((index (-1+ (vector-length table))) (accumulator '()))
      (if (< index 0)
	  accumulator
	  (let per-symbol
	      ((bucket (vector-ref table index))
	       (accumulator accumulator))
	    (if (null? bucket)
		(per-bucket (-1+ index) accumulator)
		(per-symbol
		 (cdr bucket)
		 (if (and (or unbound-also?
			      (not (lexical-unbound? environment
						     (car bucket))))
			  (substring-ci? string
					 (symbol->string (car bucket))))
		     (cons (car bucket) accumulator)
		     accumulator)))))))))

(set! apropos-sort
(named-lambda (apropos-sort string #!optional environment unbound-also?)
  "Like `apropos', except sorts the symbols before printing them."
  (if (unassigned? environment) (set! environment system-global-environment))
  (if (unassigned? unbound-also?) (set! unbound-also? false))
  (for-each (lambda (symbol)
	      (write-symbol symbol environment))
	    (sort (apropos-list string environment unbound-also?) symbol<?))))

(define (symbol-table)
  (vector-ref (get-fixed-objects-vector)
	      (fixed-objects-vector-slot 'OBARRAY)))

(define (substring-ci? string1 string2)
  (let ((length1 (string-length string1))
	(length2 (string-length string2)))
    (let loop ((start 0) (end length1))
      (and (<= end length2)
	   (or (substring-ci=? string1 0 length1 string2 start end)
	       (loop (1+ start) (1+ end)))))))

(define (write-symbol symbol environment)
  (newline)
  (write symbol)
  (cond ((lexical-unbound? environment symbol) 'DONE)
	((lexical-unassigned? environment symbol)
	 (write-string " is unassigned"))
	(else
	 (write-string " is bound to: ")
	 (write-string
	  (cdr
	   (with-output-to-truncated-string 40
	     (lambda ()
	       (write (lexical-reference environment symbol)))))))))

(define (symbol<? x y)
  (string<? (symbol->string x)
	    (symbol->string y)))

;;; end APROPOS package
)