;;; Copyright (c) 1992 Gustavus Adolphus College.  All rights reserved.
;;; 
;;; This software was developed by Gustavus Adolphus College (GAC).
;;; mission to copy this software, to redistribute it, and to use it
;;; for any purpose is granted, subject to the following restrictions and
;;; understandings.
;;; 
;;; 1. Any copy made of this software must include this copyright
;;; notice in full.
;;; 
;;; 2. Users of this software agree to make their best efforts (a) to
;;; return to the GAC Mathematics and Computer Science Department any
;;; improvements or extensions that they make, so that these may be
;;; included in future releases; and (b) to inform GAC of noteworthy uses
;;; of this software.
;;; 
;;; 3. All materials developed as a consequence of the use of this
;;; software shall duly acknowledge such use, in accordance with the usual
;;; standards of acknowledging credit in academic research.
;;; 
;;; 4. GAC makes no express or implied warranty or representation of any
;;; kind with respect to this software, including any warranty that the
;;; operation of this software will be error-free.  ANY IMPLIED WARRANTY
;;; OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE IS HEREBY
;;; DISCLAIMED.  GAC is under no obligation to provide any services, by
;;; way of maintenance, update, or otherwise.
;;; 
;;; 5. In conjunction with products arising from the use of this material,
;;; there shall be no use of the name of Gustavus Adolphus College nor of
;;; any adaptation thereof in any advertising, promotional, or sales
;;; literature without prior written consent from GAC in each case.

;; Graphing package for card sorting lab.
;; Add your times to this expression as they are reported and show the reporting
;; group the result.  At the end of the lab period, save this file back out.
;; That way even the first group done each period gets to see their result
;; immediately combined with others.
#|
(graph '(8.93 12.44 21.19 8.02 8.1 11.02 9.08 9.68 7.94 10.64 10.61
              15.21 7.95 11 10 10.84 19.71 11.59 10.44) ;merge 4
       '(32.95 44.97 58.48 43.67 30.5 37.16 37.40 31.52 27.21 31.89
               37.45 51.58 28.09 42 37 41.09 45.60 46.51 43.69) ;merge 8
       '(83.83 152.17 123.50 94.67 91 101.03 94.88 89.52 87.58 144.61
               99.34 111.41 69.98 98 86 121.30 127.36 104.82 98.72) ;merge 16
       '(29.92 20.84 21.68 17.02 12.5 14 18.08 15.11 18.58 14.53 14.87
               21.05 11.85 15 15 26.69 18.84 14.21 17.29) ;selection 4
       '(53.89 77.14 62.44 58.02 48.7 61.96 52.92 75.97 52.07 59.64 67.07
               59.25 51.8 60 53 139.34 108.5 112.32 53.42) ;selection 8
       '(201.83 266.40 224.85 229.21 168 210.38 208.05 288.78 
                193.1 308.12 227.59 230.00 205.39 199 182
                245.25 256.7 285.86 259.50)) ;selection 16
|#

;; (Note: the #| and |# above comment out the above expression when this
;;   file is initially evaluate-all-ed, since at that point the graph
;;   procedure isn't defined.  However, the expression can be evaluated on
;;   its own, since Schematik doesn't look far enough to see that it is
;;   commented out.)

;; Usage (graph list-of-mergesort-times-4-cards
;;              list-of-mergesort-times-8-cards
;;              list-of-mergesort-times-16-cards
;;              list-of-selection-sort-times-4-cards
;;              list-of-selection-sort-times-8-cards
;;              list-of-selection-sort-times-16-cards)

(enable-language-features)

(define (graph m4s m8s m16s s4s s8s s16s)
  (draw-graph
   (list (list 4 (apply min m4s) (apply average m4s) (apply max m4s))
         (list 8 (apply min m8s) (apply average m8s) (apply max m8s))
         (list 16 (apply min m16s) (apply average m16s) (apply max m16s)))
   (list (list 4 (apply min s4s) (apply average s4s) (apply max s4s))
         (list 8 (apply min s8s) (apply average s8s) (apply max s8s))
         (list 16 (apply min s16s) (apply average s16s) (apply max s16s)))))

(define (number->short-string x)
  (define (small x scale)
    (let ((r (round->exact x)))
      (if (>= r 1)
          (string-append (number->string r) "e" (number->string scale))
          (small (* x 10.0) (- scale 1)))))
  (define (large x scale)
    (let ((r (round->exact x)))
      (if (<= r 9)
          (string-append (number->string r) "e" (number->string scale))
          (large (/ x 10.0) (+ scale 1)))))
  (cond ((< (round (* 1000.0 x)) 1) (small x 0))
        ((>= (round (/ x 1000.0)) 1) (large x 0))
        ((< x 1) (number->string (/ (round (* x 1000.0)) 1000.0)))
        ((< x 10) (number->string (/ (round (* x 10.0)) 10.0)))
        (else (number->string (round->exact x)))))


(define (compute-scale max) ;returns pair: car is interval size, cdr is number
  (define (iter x scale)
    (cond ((<= x 2) (iter (* x 10.0) (/ scale 10.0)))
          ((> x 20) (iter (/ x 10.0) (* scale 10.0)))
          ((<= x 4.5) (iter (* x 2.0) (/ scale 2.0)))
          ((> x 10) (iter (/ x 2.0) (* scale 2.0)))
          (else (cons scale (ceiling->exact x)))))
  (iter max 1.0))

(define (draw-graph l1 l2)
  (let ((max-x (max (apply max (map first l1))
                    (apply max (map first l2))))
        (max-y (max (apply max (map fourth l1))
                    (apply max (map fourth l2)))))
    (let ((scale-x (compute-scale max-x))
          (scale-y (compute-scale max-y)))
      (let ((x-interval (car scale-x))
            (x-ticks (cdr scale-x))
            (y-interval (car scale-y))
            (y-ticks (cdr scale-y)))
        (let ((x-size (* x-interval x-ticks))
              (y-size (* y-interval y-ticks)))
          (let ((tickl (/ x-size -80.0))
                (tickr (/ x-size 80.0))
                (tickt (/ y-size 80.0))
                (tickb (/ y-size -80.0))
                (window (make-graphics-device
                         schematik-style-graphics-device-type
                         'points (* 6 72) (* 5 72))))
            (define ((draw-bar offset) bar)
              (graphics-draw-line window (+ offset (first bar)) (second bar)
                                  (+ offset (first bar)) (fourth bar))
              (graphics-draw-line window
                                  (+ offset tickl (first bar)) (third bar)
                                  (+ offset tickr (first bar)) (third bar)))
            (graphics-set-coordinate-limits window
                                            (/ x-size -30.0)
                                            (/ y-size -30.0)
                                            (+ x-size (/ x-size 30.0))
                                            (+ y-size (/ y-size 30.0)))
            (graphics-draw-line window 0 0 0 y-size)
            (graphics-draw-line window 0 0 x-size 0)
            (let loop
                ((n y-ticks))
              (if (= n 0)
                  'done
                  (let ((y (* n y-interval)))
                    (graphics-draw-line window
                                        tickl y
                                        tickr y)
                    (graphics-draw-text window 
                                        tickr y
                                        (number->short-string y))
                    (loop (- n 1)))))
            (let loop
                ((n x-ticks))
              (if (= n 0)
                  'done
                  (let ((x (* n x-interval)))
                    (graphics-draw-line window
                                        x tickb
                                        x tickt)
                    (graphics-draw-text window 
                                        x tickt
                                        (number->short-string x))
                    (loop (- n 1)))))
            (graphics-operation window 'set-foreground-rgb 0 1 0)
            (for-each (draw-bar tickl) l1)
            (graphics-operation window 'set-foreground-rgb 1 0 0)
            (for-each (draw-bar tickr) l2)
            (graphics-close window)))))))

(define (average . l)
  (/ (apply + l) (length l)))