Chris Cross
MC27 Lab 1
February 31, 1993

Introduction
------------

The primary purpose of this lab is simply to demonstrate how one might write an MC27 lab report.  However, in order to provide a suitable pretense, a bit of high-school algebra is dredged up.  [This lab report was done in Schematik rather than a word processing program, and hence isn't very fancy, but it illustrates what the instructors would be satisfied with.]

Part 1: Number of real roots of a quadratic
-------------------------------------------

In this part of the lab, I designed a procedure to compute how many real roots a quadratic equation has.  Remembering that this could be determined by computing the discriminant of the equation and then testing that discriminant, I broke the problem into those two parts:

(define (num-real-roots a b c) ;how many real roots does ax^2+bx+c=0 have?
  (num-real-roots-from-discriminant (discriminant a b c)))

The two auxiliary routines used by the above both straightforwardly reflect my memories from high school:

(define (discriminant a b c)
  (- (square b) (* 4 a c)))

(define (num-real-roots-from-discriminant d)
  (cond ((< d 0) 0)
        ((= d 0) 1)
        (else 2)))

(The procedure square used above is from the book.)

I tested the real-roots procedure using one simple example falling into each of the three cases.  Note that I took care to use examples in which the three arguments were different from one another, to improve the chances of catching certain bugs.

My procedure worked in all three cases, as shown below:

(real-roots 1 2 3)
;Value: 0

(real-roots 1 10 2)
;Value: 2

(real-roots 2 16 32)
;Value: 1

Conclusion
----------

The programming required for this lab was simple, not only because there was (atypically) only one part, but also because that part didn't require any recursion or iteration.  Determining the number of real roots of a quadratic equation is an example of an unusual category of computations: those that are complex enough to be worth automating, yet involve only a fixed amount of computation.