;;; Copyright (c) 1993 Gustavus Adolphus College.  All rights reserved.
;;; 
;;; This software was developed by Gustavus Adolphus College (GAC).
;;; mission to copy this software, to redistribute it, and to use it
;;; for any purpose is granted, subject to the following restrictions and
;;; understandings.
;;; 
;;; 1. Any copy made of this software must include this copyright
;;; notice in full.
;;; 
;;; 2. Users of this software agree to make their best efforts (a) to
;;; return to the GAC Mathematics and Computer Science Department any
;;; improvements or extensions that they make, so that these may be
;;; included in future releases; and (b) to inform GAC of noteworthy uses
;;; of this software.
;;; 
;;; 3. All materials developed as a consequence of the use of this
;;; software shall duly acknowledge such use, in accordance with the usual
;;; standards of acknowledging credit in academic research.
;;; 
;;; 4. GAC makes no express or implied warranty or representation of any
;;; kind with respect to this software, including any warranty that the
;;; operation of this software will be error-free.  ANY IMPLIED WARRANTY
;;; OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE IS HEREBY
;;; DISCLAIMED.  GAC is under no obligation to provide any services, by
;;; way of maintenance, update, or otherwise.
;;; 
;;; 5. In conjunction with products arising from the use of this material,
;;; there shall be no use of the name of Gustavus Adolphus College nor of
;;; any adaptation thereof in any advertising, promotional, or sales
;;; literature without prior written consent from GAC in each case.

;;; Turtle graphics procedures & code for Lab #1
;;; 
;;;   Written by Max Hailperin, modified by Karl Knight
;;; 


;;;=========================================================
;;; This first section implements Turtle graphics
;;; 
(define hb (make-hyperbot 'a))

(define gofd (hyperbot/make-action hb 1 1))
(define stop (hyperbot/make-action hb 0 0))
(define gobk (hyperbot/make-action hb -1 -1))
(define gort (hyperbot/make-action hb 1 -1))
(define golt (hyperbot/make-action hb -1 1))

(define (make-timed-action action)
  (lambda (time)
    (if (> time 2146)
        (error "Unreasonably long time" time)
        (let ((us (round (* time 1e6))))
          (maybe-gc)
          (action)
          (wait-microseconds us)
          (stop)))))

(define fd (make-timed-action gofd))
(define bk (make-timed-action gobk))
(define rt (make-timed-action gort))
(define lt (make-timed-action golt))

(define (make-scaler scale)
  (lambda (number)
    (* number scale)))

(define (compose f g)
  (lambda (x) (f (g x))))

(define rtd (compose rt (make-scaler (/ 1 43))))
(define ltd (compose lt (make-scaler (/ 1 43))))

(define pi (atan 0 -1))
(define pi/2 (atan 1 0))

(define rtr (compose rtd (make-scaler (/ 180 pi))))
(define ltr (compose ltd (make-scaler (/ 180 pi))))

;;;=========================================================
;;; This section redefines the SICP graphics procedures
;;; pen-up, position-pen, pen-down, and draw-line-to in
;;; terms of the yet-to-be-defined move-to, thereby allowing
;;; them to implement "SICP Robot Graphics."  Note that our
;;; robots have no mechanism to raise or lower the pen.
;;; 
(define (pen-up)
  'sorry)

(define (pen-down)
  'sorry)

(define (position-pen x y)
  (pen-up)
  (move-to x y))

(define (draw-line-to x y)
  (pen-down)
  (move-to x y))

(define (draw-line x1 y1 x2 y2)
  (position-pen x1 y1)
  (draw-line-to x2 y2))

(define (c-curve x1 y1 x2 y2 level)
  (define (break-line xm ym)
    (c-curve x1 y1 xm ym (- level 1))
    (c-curve xm ym x2 y2 (- level 1)))
  (if (= level 0)
      (draw-line x1 y1 x2 y2)
      (break-line (/ (- (+ x2 x1 y1) y2) 2)
                  (/ (- (+ x2 y1 y2) x1) 2))))

