;;; This code is from Structure and Interpretation of Computer Programs,
;;; by Harold Abelson and Gerald Jay Sussman with Julie Sussman, MIT Press,
;;; 1985.  Copyright 1985 by The Massachusetts Institute of Technology.
;;; Timed-prime-test has been rewritten at Gustavus Adolphus College, 1992.

(define (square x) (* x x))

(define (smallest-divisor n)
  (find-divisor n 2))

(define (find-divisor n test-divisor)
  (cond ((> (square test-divisor) n) n)
        ((divides? test-divisor n) test-divisor)
        (else (find-divisor n (+ test-divisor 1)))))

(define (divides? a b)
  (= (remainder b a) 0))

(define (prime? n)
  (= n (smallest-divisor n)))

(define (expmod b e m)
  (cond ((= e 0) 1)
        ((even? e)
         (remainder (square (expmod b (/ e 2) m))
                    m))
        (else
         (remainder (* b (expmod b (- e 1) m))
                    m))))        

(define (fermat-test n)
  (define a (+ 2 (random (- n 2))))
  (= (expmod a n n) a))

(define (fast-prime? n times)
  (cond ((= times 0) t)
        ((fermat-test n)
         (fast-prime? n (- times 1)))
        (else nil)))

;; WARNING: MAGIC BELOW!  The stuff below is magic that you aren't expected
;; to understand at this point in the course.  The only line you should look
;; at is the one you will have to change.  Currently it uses prime? to test
;; n for primeness; you will change that to use a different test.  This line
;; is clearly marked; ignore all the rest.

(define (timed-prime-test n)
  (define (iter start count)
    (cond ((not (prime? n))     ;; <=== CHANGE THIS LINE ONLY
           #f)
          ((> (runtime) (1+ start)) 
           (princ " *** ")
           (princ (/ (- (runtime) start) count))
           #t)
          (else (iter start (1+ count)))))
  (print n)
  (iter (runtime) 1))
