(define (cost-of-subjects)
  (add-up (map cost-of-subject
	       (table-entries (lookup 'subjects mit-operations)))))

(define (cost-of-subject subject)
  (+ (cost-of-staff subject)
     (cost-of-space subject)))

(define (cost-of-staff subject)
  (add-up (map cost-of-person
	       (table-entries (lookup 'staff subject)))))

(define (cost-of-space subject)
  (add-up (map cost-of-room
	       (table-entries (lookup 'rooms subject)))))


;;; Health care, retirement fund, etc.
(define employee-benefits-loading-factor 1.44)

(define (cost-of-person person)
  (let ((name (car person))
	(hours-per-week (caddr person)))
    (* (/ hours-per-week 40)		;40 hours/week is full time.
       employee-benefits-loading-factor
       (yearly-cost (person-rank name)))))

(define (person-rank name)
  (cadr (lookup name
		(lookup 'personnel
			(lookup 'resources
				mit-operations)))))

(define (yearly-cost type-item)
  (cadr (lookup type-item
		(lookup 'yearly-cost
			mit-operations))))

(define (cost-of-room room)
  (let ((name (car room))
	(hours-per-week (cadr room)))
    (* (/ hours-per-week 100)		;100 hours/week is full time.
       (yearly-cost (room-type name)))))

(define (room-type name)
  (cadr (lookup name
		(lookup 'physical-plant
			(lookup 'resources
				mit-operations)))))

;;; Utilities

(define (add-up list-of-numbers)
  (if (null? list-of-numbers)
      0
      (+ (car list-of-numbers)
	 (add-up (cdr list-of-numbers)))))



;;;  Table abstraction for cost-accounting database

;;; Tables are implemented as headed association lists,
;;;  where the  headers are the keys used to find the table
;;;  as a record in another table.

(define (make-table header list-of-records)
  (cons header list-of-records))  

(define (table-header table)
  (car table))

(define (table-entries table)
  (cdr table))

(define (lookup key table)
  (let ((record (assq key (table-entries table))))
    (if record
	record
	(error "Key not in table:"
	       key
	       (table-header table)))))


;;; A record in a table may be a simple entry or another table.

(define (make-entry key data)
  (cons key data))


;;;--------------------------------------------------------------
;;;  A simple report generator for examining subjects carefully
;;;--------------------------------------------------------------

(define (cost-of-subject subject-entry)
  (write-line (car subject-entry))
  (let ((staff-cost (cost-of-staff subject-entry))
	(space-cost (cost-of-space subject-entry)))
    (display "  Staff: ")
    (write staff-cost)
    (display "  Space: ")
    (write space-cost)
    (let ((total (+ staff-cost space-cost)))
      (display "  Total: ")
      (write total)
      total)))
