(if (lexical-unreferenceable? user-initial-environment 'stop-bank)
    (define stop-bank false))

(define (start-bank)

  ;; Most depositors are honest ... They work like this:

  (define (make-honest-depositor name authorization laziness accounts) 
    (let ((num-accounts (length accounts)))
      (define (buzz)
	(let ((from (random num-accounts))
	      (to (random num-accounts))
	      (amount (random authorization)))
	  (let ((pocket (((list-ref accounts from) 'withdraw) name amount)))
	    (((list-ref accounts to) 'deposit) name pocket)))
	(sleep-current-thread (random laziness))
	(buzz))
      buzz))


  ;; Some depositors like to kite funds ... They work like this:

  (define (make-kiting-depositor name authorization laziness kite-time accounts) 
    (let ((num-accounts (length accounts)))
      (define (buzz)
	(let ((from (random num-accounts))
	      (to (random num-accounts))
	      (amount (random authorization)))
	  (let ((pocket (((list-ref accounts from) 'withdraw) name amount)))
	    (sleep-current-thread (random kite-time))
	    (((list-ref accounts to) 'deposit) name pocket)))
	(sleep-current-thread (random laziness))
	(buzz))
      buzz))


  ;; Some depositors skim the "cream" off of their accounts:

  (define (make-skimming-depositor name authorization cream laziness accounts) 
    (let ((num-accounts (length accounts)))
      (define (buzz)
	(let ((from (random num-accounts))
	      (to (random num-accounts))
	      (amount (random authorization)))
	  (let ((pocket (((list-ref accounts from) 'withdraw) name amount)))
	    (((list-ref accounts to) 'deposit)
	     name
	     (if (< cream pocket)
		 (- pocket cream)
		 pocket))))
	(sleep-current-thread (random laziness))
	(buzz))
      buzz))

  (define (make-auditor accounts laziness)
    (define (loop)
      (do-audit accounts)
      (sleep-current-thread laziness)
      (loop))
    loop)

  (if stop-bank (stop-bank))

  (let ((mb (make-account 'publish '(robert-maxwell neil-bush) 10000000))
	(m  (make-account 'swiss013 '(robert-maxwell) 110000000))
	(b  (make-account 'for-dad '(neil-bush) 1000000))
	(mh (make-account 'junk-bonds '(michael-milken leona-helmsley) 20000000))
	(mt (make-account 'big-money '(michael-milken donald-trump) 200000000))
	(mm (make-account 'bcci '(michael-milken robert-maxwell) 1000000))
	(ht  (make-account 'hotels '(donald-trump leona-helmsley) 20000000)))
    (let ((nb
	   (make-honest-depositor 'neil-bush 200 1000 (list mb b)))
	  (rmx
	   (make-kiting-depositor 'robert-maxwell 1000 1000 2000 (list mb m mm)))
	  (rml
	   (make-skimming-depositor 'michael-milken 1000 500 2000 (list mh mt mm)))
	  (dt
	   (make-honest-depositor 'donald-trump 10000 1000 (list mt ht)))
	  (lh
	   (make-honest-depositor 'leona-helmsley 1000 1000 (list mh ht)))

	  (cl (make-auditor (list mb m b mh mt mm ht) 20000)))
      (set! stop-bank (parallel-execute nb rmx rml dt lh cl)))))
