(define cons-count 0)
(define set-count 0)
(define assq-count 0)

(define (reset-counters)
  (set! cons-count 0)
  (set! set-count 0)
  (set! assq-count 0))

(define (report-counters)
  (newline)
  (princ "Cons: ") (princ cons-count)
  (newline)
  (princ "Set:  ") (princ set-count)
  (newline)
  (princ "Assq: ") (princ assq-count)
  '())

(define (ins-set-car! cell new)
  (set! set-count (+ 1 set-count))
  (set-car! cell new))

(define (ins-set-cdr! cell new)
  (set! set-count (+ 1 set-count))
  (set-cdr! cell new))

(define (ins-cons x y)
  (let ((new-cell (cons '() '())))
    (ins-set-car! new-cell x)
    (ins-set-cdr! new-cell y)
    (set! count (+ 1 count))
    new-cell))

(define (ins-append x y)
  (if (null? x)
      y
      (ins-cons (car x)
		(ins-append (cdr x) y))))

(define (ins-append! x y)
  (ins-set-cdr! (last x) y))

(define (ins-reverse x)
  (if (null x)
      nil
      (ins-append (ins-reverse (cdr x)) (ins-cons (car x) nil))))

(define (ins-reverse! x)
  (if (null x)
      nil
      (ins-append! (ins-reverse! (cdr x)) (ins-cons (car x) nil))))

(define (ins-assq x y)
  (cond ((null? y) nil)
	(else
	 (set! assq-count (+ 1 assq-count))
	 (if (eq (caar y) x)
	     (car y)
	     (ins-assq x (cdr y))))))

(define (make-table)
  (let ((local-table (list '*table*)))
    (define (lookup key-1 key-2)
      (let ((subtable (assq key-1 (cdr local-table))))
	(if (null? subtable)
	    nil
	    (let ((record (assq key-2 (cdr subtable))))
	      (if (null? record)
		  nil
		  (cdr record))))))
    (define (insert! key-1 key-2 value)
      (let ((subtable (assq key-1 (cdr local-table))))
	(if (null? subtable)
	    (set-cdr! local-table
		      (cons (list key-1
				  (cons key-2 value))
			    (cdr local-table)))
	    (let ((record (assq key-2 (cdr subtable))))
	      (if (null? record)
		  (set-cdr! subtable
			    (cons (cons key-2 value)
				  (cdr subtable)))
		  (set-cdr! record value)))))
      'ok)
    (define (dispatch m)
      (cond ((eq? m 'lookup-proc) lookup)
	    ((eq? m 'insert-proc!) insert!)
	    (else (error "Unknown operation -- TABLE" m))))

    dispatch))

(define operation-table (make-table))
(define get (operataion-table 'lookup-proc))
(define put (operation-table 'insert-proc!))

(define (ins-make-table)
  (let ((local-table (ins-cons '*table* nil)))
    (define (lookup key-1 key-2)
      (let ((subtable (ins-assq key-1 (cdr local-table))))
	(if (null? subtable)
	    nil
	    (let ((record (ins-assq key-2 (cdr subtable))))
	      (if (null? record)
		  nil
		  (cdr record))))))
    (define (insert! key-1 key-2 value)
      (let ((subtable (ins-assq key-1 (cdr local-table))))
	(if (null? subtable)
	    (ins-set-cdr! local-table
			  (ins-cons (ins-cons key-1
					      (ins-cons (ins-cons key-2 value)
							nil))
				    (cdr local-table)))
	    (let ((record (ins-assq key-2 (cdr subtable))))
	      (if (null? record)
		  (ins-set-cdr! subtable
				(ins-cons (ins-cons key-2 value)
					  (cdr subtable)))
		  (ins-set-cdr! record value)))))
      'ok)
    (define (dispatch m)
      (cond ((eq? m 'lookup-proc) lookup)
	    ((eq? m 'insert-proc!) insert!)
	    (else (error "Unknown operation -- TABLE" m))))

    dispatch))

(define ins-operation-table (ins-make-table))
(define ins-get (ins-operataion-table 'lookup-proc))
(define ins-put (ins-operation-table 'insert-proc!))


(define (ins-nomutate-make-table)
  (let ((local-table nil))
    (define (lookup key-1 key-2)
      (let ((subtable (ins-assq key-1 local-table)))
	(if (null? subtable)
	    nil
	    (let ((record (ins-assq key-2 (cdr subtable))))
	      (if (null? record)
		  nil
		  (cdr record))))))
    (define (insert! key-1 key-2 value)
      (let ((subtable (ins-assq key-1 local-table)))
	(set! local-table
	      (ins-cons (ins-cons key-1
				  (ins-cons (ins-cons key-2 value)
					    (cdr subtable)))
			local-table)))
      'ok)
    (define (restore-table old-table)
      (set! local-table old-table)
      'ok)
    (define (dispatch m)
      (cond ((eq? m 'lookup-proc) lookup)
	    ((eq? m 'insert-proc!) insert!)
	    ((eq? m 'table) local-table)
	    ((eq? m 'restore-table-proc) restore-table)
	    (else (error "Unknown operation -- TABLE" m))))

    dispatch))

(define ins-nomutate-operation-table (ins-nomutate-make-table))
(define ins-nomutate-get (ins-nomutate-operataion-table 'lookup-proc))
(define ins-nomutate-put (ins-nomutate-operation-table 'insert-proc!))

