;;; Table procedures for Problem set 8

(define (make-table) (list '*table*))

(define (assq key records)
  (cond ((null? records) nil)
        ((eq? key (caar records)) (car records))
        (else (assq key (cdr records)))))
        

(define (lookup key-1 key-2 table)
  (let ((subtable (assq key-1 (cdr table))))
    (if (null? subtable)
        nil
        (let ((record (assq key-2 (cdr subtable))))
          (if (null? record) nil (cdr record))))))
              
(define (insert! key-1 key-2 value table)
  (let ((subtable (assq key-1 (cdr table))))
    (if (null? subtable)
        (set-cdr! table
                  (cons (list key-1 (cons key-2 value))
                        (cdr table)))
        (let ((record (assq key-2 (cdr subtable))))
          (if (null? record)
              (set-cdr! subtable
                        (cons (cons key-2 value)
                              (cdr subtable)))
              (set-cdr! record value)))))
   'ok)
