                   6.001 - STRUCTURE AND INTERPRETATION
                          OF COMPUTER PROGRAMS                        

                         Problem Set 5 Solutions       
                              Spring 1987
                     
; Exercise 1
(define r1 (make-resistor 10))
(define r2 (make-resistor 20))
(define r3 (make-resistor 30))
(define r4 (make-resistor 40))
(define N
  (make-series r4 (make-parallel r3
				 (make-series r1 r2))))

;a. Box and Pointer Diagram
 






  

;b. 6 times:
; 1. r4+(r3//(r1+r2))
; 2. r4
; 3. (r3//(r1+r2))
; 4. (r1+r2)
; 5. r1
; 6. r2

; Exercise 2

(define (p-extend base series-part parallel-part)
  (make-parallel parallel-part (make-series series-part base)))

; Exercise 3

(define ex3 (p-extend n (make-resistor 10) (make-resistor 10)))

(resistance ex3)

; Exercise 4

(define (ladder-extension stages base series-part parallel-part)
  ((repeated (lambda (base) (l-extend base series-part parallel-part)) stages) 
   base))

; Exercise 5

; When you use resistance-parallel which works in terms of
; conductances, it ends up computing the conductances (and
; therefore the resistances) of the component parts only once.
; We could get the same effect here by using a LET.

;a. 2N+1 resistors in an N-stage ladder.

;b. Originally, will call it only once for each resisitor - i.e. 
;   2N+ 1 times

;c. For each series case, will evaluate RESISTANCE-RESISTOR once
;   (on the left branch) and  will evaluate the parallel network once.
;   For each parallel case, will evaluate RESISTANCE-RESITOR twice (for
;   the left branch, and will evaluate the series network twice.
;   For the base case will evaluate the resistance once.  Thus we have
;   1 + 2( 1 + 1 + 2( 1 + 1 + 2 ( ...

; Or, perhaps better, 
; T(0) = 1
; T(N) = 1 + 2(1 + T(N-1)) = 1 + 2 + 2T(N-1) = 3 + 2T(N-1)
; Thus T(N) = 1 + 2 + 2 + 4 + 4 + 8 + 8 + ... + 2^(N+1) + 2^N+1
; = [2^(N+1) - 1] {for series 1, 2, 4, 8 , ...} + [2^(N+2) - 2] {for series 4, 8, 16 ...}
; So in general get 2^(N+2) - 3

;d. he's slowed it down exponentially!

;;; PART 2

; Exercise 6.

(define (mp-make-resistance resistance)
  (define (self message)
    (cond ((eq? message 'resistance) resistance)
	  ((eq? message 'conductance) (/ 1 resistance))
	  (else (error "Make-resistance does not understand " message))))
  self)

(define (mp-make-conductance conductance)
  (define (self message)
    (cond ((eq? message 'resistance) (/ 1 conductance))
	  ((eq? message 'conductance) conductance)
	  (else (error "Make-conductance does not understand " message))))
  self)

(define (mp-make-parallel ckt1 ckt2)
  (define (self message)
    (cond ((eq? message 'resistance) (/ 1 (self 'conductance)))
	  ((eq? message 'conductance) (+ (ckt1 'conductance)
					 (ckt2 'conductance)))
	  (else (error "Make-parallel does not understand " message))))
  self)

(define (mp-make-series ckt1 ckt2)
  (define (self message)
    (cond ((eq? message 'resistance) (+ (ckt1 'resistance)
					(ckt2 'resistance)))
	  ((eq? message 'conductance) (/ 1 (self 'resistance)))
	  (else (error "Make-series does not understand " message))))
  self)

(define (mp-resistance ckt1) (ckt1 'resistance))

(define (mp-conductance ckt1) (ckt1 'conductance))

(define r1 (mp-make-resistance 10))
(define r2 (mp-make-resistance 20))
(define g3 (mp-make-conductance (/ 1 30)))
(define r4 (mp-make-resistance 40))

(define mp-n (mp-make-series r4
			  (mp-make-parallel g3
					    (mp-make-series r1 r2))))

(mp-resistance mp-n)

