

;                        Fill in all your answers here!
 
; Problem 1:

; Zap in the following useful procedure:

(define (try-count-atoms lst)
  (remote-assign int-sum 'lst lst)
  (start count-atoms-machine)
  (remote-fetch int-sum 'value))


; Write your machine below, using these templates:

; (define-machine count-atoms-machine
;   (registers value continue lst)
;   (controller
;          .
;          .
;          .
;   (perform (initialize-stack))
;   (perform (initialize-ops-counter))
; ))




; Problem 2:

; count-atoms-machine
; 
;  ------------------------------------------------------------------------
;  ! n !             lst                 !  opers   !  pushes  !max depth !
;  ------------------------------------------------------------------------
;  ! 1 !           (a . b)               !          !          !          !
;  ------------------------------------------------------------------------
;  ! 2 !        ((a . b) c . d)          !          !          !          !
;  ------------------------------------------------------------------------
;  ! 3 ! (((a . b) c . d) (a . b) c . d) !          !          !          !
;  ------------------------------------------------------------------------


;  Formulas:
; 
;          Operations = 
; 
;          Pushes = 
; 
;          Depth =  


; Problem 3:

; count-atoms-r
; 
;  ------------------------------------------------------------------------
;  ! n !             lst                 !  opers   !  pushes  !max depth !
;  ------------------------------------------------------------------------
;  ! 1 !           (a . b)               !          !          !          !
;  ------------------------------------------------------------------------
;  ! 2 !        ((a . b) c . d)          !          !          !          !
;  ------------------------------------------------------------------------
;  ! 3 ! (((a . b) c . d) (a . b) c . d) !          !          !          !
;  ------------------------------------------------------------------------


;  Formulas:
; 
;          Operations = 
; 
;          Pushes = 
; 
;          Depth =  

 

; count-atoms-i
; 
;  ------------------------------------------------------------------------
;  ! n !             lst                 !  opers   !  pushes  !max depth !
;  ------------------------------------------------------------------------
;  ! 1 !           (a . b)               !          !          !          !
;  ------------------------------------------------------------------------
;  ! 2 !        ((a . b) c . d)          !          !          !          !
;  ------------------------------------------------------------------------
;  ! 3 ! (((a . b) c . d) (a . b) c . d) !          !          !          !
;  ------------------------------------------------------------------------


;  Formulas:
; 
; 
;          Operations = 
; 
;          Pushes = 
; 
;          Depth =  

 
; Explanation of performance differences between the two procedures:


; Problem 4: The programs for this problem should be included here.
 
; Step 1: Insert definitions of tracing? and traced-proc.


; Step 2: Insert definitions of: 
;                        change-to-traced-procedure,
;                        traced-procedure?,
;                        procedure-part-traced,
;                        name-part-traced.



; Step 3: Zap this new version of user-print into scheme along with
; the print-call procedure, which you should find useful in steps 4 and 5.

(define (user-print object)
  (cond ((compound-procedure? object)
         (print (list 'compound-procedure
                      (parameters object)
		      (procedure-body object)
                      '[procedure-env])))
        ((compiled-procedure? object)
         (print '[compiled-procedure]))
; the following three lines will be used when tracing is added
        ((traced-procedure? object)			
         (print 'traced-procedure)
         (user-print (procedure-part-traced object)))
        (else (print object))))

(define (print-call fun-name arglist)
	(print (list 'calling 
		     'procedure
		     fun-name
		     'with 
		     (reverse arglist))))       ; arguments stored in reverse

; Steps 4 and 5: The definition of the explicit-control-evaluator machine
;         is given below.  Modify the controller instructions as described
;         and mark your modifications.  Zap in the definition and try tracing 
;         some primitive and compound procedures. 

(define-machine explicit-control-evaluator
  (registers exp env val continue fun argl unev)
  (controller
read-eval-print-loop
  (perform (initialize-stack))
  (perform (initialize-ops-counter))                   ;;; added for statistics
  (perform (newline))
  (perform (princ 'EC-EVAL==>))
  (assign exp (read))
  (assign env the-global-environment)
  (assign continue print-result)
  (goto eval-dispatch)
print-result
  (perform (user-print (fetch val)))
  (goto read-eval-print-loop)
unknown-procedure-type-error
  (assign val 'unknown-procedure-type-error)
  (goto signal-error)

unknown-expression-type-error
  (assign val 'unknown-expression-type-error)
  (goto signal-error)

signal-error
  (perform (user-print (fetch val)))
  (goto read-eval-print-loop)

external-entry
   (perform (initialize-stack))
   (assign env the-global-environment)
   (assign continue print-result)
   (save continue)
   (goto (fetch val))

eval-dispatch
  (branch (self-evaluating? (fetch exp)) ev-self-eval)
  (branch (quoted? (fetch exp)) ev-quote)
  (branch (variable? (fetch exp)) ev-variable)
  (branch (definition? (fetch exp)) ev-definition)
  (branch (assignment? (fetch exp)) ev-assignment)
  (branch (lambda? (fetch exp)) ev-lambda)
  (branch (conditional? (fetch exp)) ev-cond)
  (branch (no-args? (fetch exp)) ev-no-args)
  (branch (application? (fetch exp)) ev-application)
  (goto unknown-expression-type-error)
ev-self-eval
  (assign val (fetch exp))
  (goto (fetch continue))
ev-quote
  (assign val (text-of-quotation (fetch exp)))
  (goto (fetch continue))
ev-variable
  (assign val
          (lookup-variable-value (fetch exp) (fetch env)))
  (goto (fetch continue))
ev-lambda
  (assign val (make-procedure (fetch exp) (fetch env)))
  (goto (fetch continue))
ev-no-args
  (assign exp (operator (fetch exp)))
  (save continue)
  (assign continue setup-no-arg-apply)
  (goto eval-dispatch)
setup-no-arg-apply
  (assign fun (fetch val))
  (assign argl '())
  (goto apply-dispatch)
ev-application
  (assign unev (operands (fetch exp)))
  (assign exp (operator (fetch exp)))
  (save continue)
  (save env)
  (save unev)
  (assign continue eval-args)
  (goto eval-dispatch)
eval-args
  (restore unev)
  (restore env)
  (assign fun (fetch val))
  (save fun)
  (assign argl '())
  (goto eval-arg-loop)

eval-arg-loop
  (save argl)
  (assign exp (first-operand (fetch unev)))
  (branch (last-operand? (fetch unev)) eval-last-arg)
  (save env)
  (save unev)
  (assign continue accumulate-arg)
  (goto eval-dispatch)
accumulate-arg
  (restore unev)
  (restore env)
  (restore argl)
  (assign argl (cons (fetch val) (fetch argl)))
  (assign unev (rest-operands (fetch unev)))
  (goto eval-arg-loop)
eval-last-arg
  (assign continue accumulate-last-arg)
  (goto eval-dispatch)
accumulate-last-arg
  (restore argl)
  (assign argl (cons (fetch val) (fetch argl)))
  (restore fun)
  (goto apply-dispatch)

apply-dispatch
  (branch (primitive-procedure? (fetch fun)) primitive-apply)
  (branch (compound-procedure? (fetch fun)) compound-apply)
  (branch (compiled-procedure? (fetch fun)) compiled-apply)
  (goto unknown-procedure-type-error)
compiled-apply
   (assign val (compiled-procedure-entry (fetch fun)))
   (goto (fetch val))
primitive-apply
  (assign val
          (apply-primitive-procedure (fetch fun)
                                     (fetch argl)))
  (restore continue)
  (goto (fetch continue))
compound-apply
  (assign env (make-bindings (fetch fun) (fetch argl)))
  (assign unev (procedure-body (fetch fun)))
  (goto eval-sequence)
eval-sequence
  (assign exp (first-exp (fetch unev)))
  (branch (last-exp? (fetch unev)) last-exp)
  (save unev)
  (save env)
  (assign continue eval-sequence-continue)
  (goto eval-dispatch)
eval-sequence-continue
  (restore env)
  (restore unev)
  (assign unev (rest-exps (fetch unev)))
  (goto eval-sequence)
last-exp
  (restore continue)
  (goto eval-dispatch)

ev-cond
  (save continue)
  (assign continue evcond-decide)
  (assign unev (clauses (fetch exp)))
evcond-pred
  (branch (no-clauses? (fetch unev)) evcond-return-nil)
  (assign exp (first-clause (fetch unev)))
  (branch (else-clause? (fetch exp)) evcond-else-clause)
  (save env)
  (save unev)
  (assign exp (predicate (fetch exp)))
  (goto eval-dispatch)

evcond-return-nil
  (restore continue)
  (assign val nil)
  (goto (fetch continue))
evcond-decide
  (restore unev)
  (restore env)
  (branch (true? (fetch val)) evcond-true-predicate)
  (assign unev (rest-clauses (fetch unev)))
  (goto evcond-pred)
evcond-true-predicate
  (assign exp (first-clause (fetch unev)))
evcond-else-clause
  (assign unev (actions (fetch exp)))
  (goto eval-sequence)
ev-assignment
  (assign unev (assignment-variable (fetch exp)))
  (save unev)
  (assign exp (assignment-value (fetch exp)))
  (save env)
  (save continue)
  (assign continue ev-assignment-1)
  (goto eval-dispatch)
ev-assignment-1
  (restore continue)
  (restore env)
  (restore unev)
  (perform
   (set-variable-value! (fetch unev) (fetch val) (fetch env)))
  (goto (fetch continue))
ev-definition
  (assign unev (definition-variable (fetch exp)))
  (save unev)
  (assign exp (definition-value (fetch exp)))
  (save env)
  (save continue)
  (assign continue ev-definition-1)
  (goto eval-dispatch)
ev-definition-1
  (restore continue)
  (restore env)
  (restore unev)
  (perform
   (define-variable! (fetch unev) (fetch val) (fetch env)))
  (assign val (fetch unev)) 
  (goto (fetch continue))

  ;;end of controller of explicit-control-evaluator
  ))

; Step 6: Insert your photo session from running factorial with "-" being
; traced.  You can either edit this file by inserting the text of the
; photo file, or insert the photo page between this page and the next.


; Part II -- The compiler!

; Problem 5:

; Zap the following code definition into scheme, and then run compile-and-go 
; on count-atoms-code.

(define count-atoms-code '(define (count-atoms-comp lst)
	(cond ((null? lst) 0)
	      ((atom? lst) 1)
	      (else (+ (count-atoms-comp (car lst))
		       (count-atoms-comp (cdr lst)))))))


; count-atoms-comp
; 
;  ------------------------------------------------------------------------
;  ! n !             lst                 !  opers   !  pushes  !max depth !
;  ------------------------------------------------------------------------
;  ! 1 !           (a . b)               !          !          !          !
;  ------------------------------------------------------------------------
;  ! 2 !        ((a . b) c . d)          !          !          !          !
;  ------------------------------------------------------------------------
;  ! 3 ! (((a . b) c . d) (a . b) c . d) !          !          !          !
;  ------------------------------------------------------------------------


;  Formulas:
; 
;          Operations = 
; 
;          Pushes = 
; 
;          Depth =  


; Explanation of performance differences between the interpreted and 
; compiled code:








; Problem 6: Insert the compiled code for count-atoms-comp either by
; inserting the text of that file here, or by including it as a separate
; page.  Add you annotations by hand.






