;;;  These procedures are included in PS1-ANSWER.SCM, and will be needed
;;;  in problem 4.  The first is a modified version of user-print which 
;;;  calls the procedures you will be implementing.  It's old version
;;;  is included in the PS10-ECEVAL.SCM code.

(define (user-print object)
  (cond ((compound-procedure? object)
         (print (list 'compound-procedure
                      (parameters object)
		      (procedure-body object)
                      '[procedure-env])))
        ((compiled-procedure? object)
         (print '[compiled-procedure]))
; the following three lines will be used when tracing is added
        ((traced-procedure? object)			
         (print 'traced-procedure)
         (user-print (procedure-part-traced object)))
        (else (print object))))

;;;  This procedure will be helpful in actually printing the tracing 
;;;  information.

(define (print-call fun-name arglist)
	(print (list 'calling 
		     'procedure
		     fun-name
		     'with 
		     (reverse arglist))))       ; arguments stored in reverse

