;;;  Massachusetts Institute of Technology -- Spring Term 1987, April 9.
;;;			  6.001 Lecture Notes
;;;
;;; A meta-circular evaluator for SCHEME which can interpret itself.

(define mc-eval (lambda (exp env)
		  (cond ((number? exp) exp)			;base case
			((symbol? exp) (lookup exp env))	;base case
			((eq? (car exp) 'quote) (car (cdr exp)))	;special forms
			((eq? (car exp) 'cond) (evcond (cdr exp) env))
			((eq? (car exp) 'sequence) (evsequence (cdr exp) env))
			((eq? (car exp) 'lambda) (list 'closure (cdr exp) env))
			((eq? (car exp) 'define) (evdefine (cdr exp) env))
			(else (mc-apply (mc-eval (car exp) env)        ;procedure application
					(evlist (cdr exp) env))))))

(define mc-apply (lambda (fun args)
		   (cond ((atom? fun) (apply fun args))		;use scheme for dirty work
			 ((eq? (car fun) 'closure)
			  (mc-eval (car (cdr (car (cdr fun))))		;procedure body
				   (bind (car (car (cdr fun)))		;formal paramaters
					 args				;supplied arguements
					 (car (cdr (cdr fun))))))	;saved environment
			 (else (error "Unknown function")))))

(define evlist (lambda (lst env)		;map evaluator over a list
		 (cond ((null? lst) nil)
		       (else (cons (mc-eval (car lst) env)
				   (evlist (cdr lst) env))))))

(define evcond (lambda (clauses env)
		 (cond ((null? clauses) nil)
		       ((eq? 'else (car (car clauses))) (evsequence (cdr (car clauses)) env))
		       ((mc-eval (car (car clauses)) env) (evsequence (cdr (car clauses)) env))
		       (else (evcond (cdr clauses) env)))))

(define evsequence (lambda (clauses env)
		     (cond ((null? (cdr clauses))
			    (mc-eval (car clauses) env))
			   (else (mc-eval (car clauses) env)
				 (evsequence (cdr clauses) env)))))

(define evdefine (lambda (clauses env)		;mutate the first frame
		   (sequence (set-cdr! (car env)
				       (cons (cons (car clauses) (mc-eval (car (cdr clauses)) env))
					     (cdr (car env))))
			     (car clauses))))

(define bind (lambda (params values env)	;add a new frame
	       (cons (cons 'frame (make-frame-body params values)) env)))

(define make-frame-body (lambda (params values)	;frame body is an association list
			  (cond ((null? params)
				 (cond ((null? values) nil)
				       (else (error "Too many values supplied"))))
				((null? values) (error "Too few values supplied"))
				(else (cons (cons (car params) (car values))
					    (make-frame-body (cdr params) (cdr values)))))))

(define lookup (lambda (var env)
		 (cond ((null? env) (error "Unbound variable" var))	;not in any frames
		       (else ((lambda (binding)
				(cond ((null? binding)		;check each frame
				       (lookup var (cdr env)))	;in turn
				      (else (cdr binding))))	;binding is (<varname> . <value>)
			      (find-binding var (cdr (car env))))))))

(define find-binding (lambda (var frame-body)
		       ;this is just assq
		       (cond ((null? frame-body) nil)
			     ((eq? var (car (car frame-body))) (car frame-body))
			     (else (find-binding var (cdr frame-body))))))

(define global-env				;an initial environment
  (list (list 'frame (cons 'nil '()) (cons '+ +) (cons '- -) (cons '= =) (cons '* *)
	             (cons 'car car) (cons 'cdr cdr) (cons 'cons cons) (cons 'list list)
		     (cons 'set-car! set-car!) (cons 'set-cdr! set-cdr!)
		     (cons 'null? null?) (cons 'eq? eq?) (cons 'atom? atom?)
		     (cons 'number? number?) (cons 'symbol? symbol?)
		     (cons 'error error) (cons 'apply apply))))
   