;;-*-scheme-*-
;;This file contains everything that is needed to run the query system
;;from chapter 4 of the textbook.  Except where noted, the code is
;;from the book.
;;(Bug fixed 4/18/85 in contract-question-mark.  Blew up if variable
;; contained a rule-application-id)

;; Some magic to make things run faster .... (not from book)
(declare (compile-usual-primitive-functions)
         (compilable-primitive-variables
          car null? cdr))

;;First, we implement PUT and GET as in section 3.3.3

(define (make-table)
  (let ((local-table (list '*table*)))
    (define (lookup key-1 key-2)
      (let ((subtable (assq key-1 (cdr local-table))))
        (if (null? subtable)
            '()
            (let ((pair (assq key-2 (cdr subtable))))
              (if (null? pair)
                  '()
                  (cdr pair))))))

    (define (insert! key-1 key-2 value)
      (let ((subtable (assq key-1 (cdr local-table))))
        (if (null? subtable)
            (set-cdr! local-table
                      (cons (cons key-1
                                  (cons (cons key-2 value) '()))
                            (cdr local-table)))
            (let ((pair (assq key-2 (cdr subtable))))
              (if (null? pair)
                  (set-cdr! subtable
                            (cons (cons key-2 value)
                                  (cdr subtable)))
                  (set-cdr! pair value))))))

    (define (dispatch m)
      (cond ((eq? m 'lookup-proc) lookup)
            ((eq? m 'insert-proc!) insert!)
            (else (error "Unknown operation -- TABLE" m))))
    dispatch))

;;These will be set in initialize-data-base
(define get ())
(define put ())

;;Then some stream functions from chapter 3

(define (map proc s)
  (if (empty-stream? s)
      the-empty-stream
      (cons-stream (proc (head s))
                   (map proc (tail s)))))


(define (flatmap proc stream)
  (flatten (map proc stream)))

(define (flatten stream)
  (accumulate-delayed interleave-delayed the-empty-stream stream))

(define (singleton s) (cons-stream s the-empty-stream))
(define (interleave s1 s2)
  (if (empty-stream? s1)
      s2
      (cons-stream (head s1)
                   (interleave s2
                               (tail s1)))))
(define (interleave-delayed s1 delayed-s2)
  (if (empty-stream? s1)
      (force delayed-s2)
      (cons-stream (head s1)
                   (interleave-delayed (force delayed-s2)
                               (delay (tail s1))))))

(define (accumulate-delayed combiner initial-value stream)
  (if (empty-stream? stream)
      initial-value
      (combiner (head stream)
                (delay
                 (accumulate-delayed combiner initial-value (tail stream))))))

(define (append-streams s1 s2)
  (if (empty-stream? s1)
      s2
      (cons-stream (head s1)
                   (append-streams (tail s1) s2))))

;;This is not from the book
(define (initialize-data-base big-list)
  (define (deal-out statements rules assertions)
    (if (null? statements)
        (sequence (set! THE-ASSERTIONS (list-to-stream assertions))
                  (set! THE-RULES (list-to-stream rules))
                  'done)
        (let ((s (query-syntax-process (car statements))))
          (if (rule? s)
              (sequence (store-rule-in-index s)
                        (deal-out (cdr statements)
                                  (cons s rules)
                                  assertions))
              (sequence
               (store-assertion-in-index s)
               (deal-out (cdr statements)
                         rules
                         (cons s assertions)))))))
  (let ((operation-table (make-table)))
    (set! get (operation-table 'lookup-proc))
    (set! put (operation-table 'insert-proc!)))
  (put 'and 'qeval conjoin)
  (put 'or 'qeval disjoin)
  (put 'not 'qeval negate)
  (put 'lisp-value 'qeval lisp-value)
  (put 'always-true 'qeval always-true)
  (deal-out big-list '() '()))

;;This is not from the book.  Used by initialize-data-base
(define (list-to-stream l)
  (if (null? l)
      the-empty-stream
      (cons-stream (car l) (list-to-stream (cdr l)))))

;; Something to ease the pain... (not from book)

(enable-language-features)    ; That means magic ....

(define get-query-from-editor
  (let ((editor-zap-filename (access editor-zap-filename '()))
        (editor-crunch-volume (access editor-crunch-volume '()))
        (crunch (access crunch '()))
        (unwind-protect (access unwind-protect '()))
        (quit (access quit '())))
    (named-lambda (get-query-from-editor)
      (let ((form '())
            (file-channel '()))
        (newline)
        (princ "==> Editor")
        (quit)
        (tyo #o14)              ;Homes cursor and clears screen
        (if (file-exists? editor-zap-filename)
            (unwind-protect
             (lambda ()
               (set! file-channel
                     (open-reader-channel
                      editor-zap-filename))
               (let ((query (read file-channel)))
                 (newline)
                 (princ "QUERY from editor: ")
                 (pp query)
                 (newline)
                 (set! form query)))
             (lambda ()
               (if file-channel
                   (sequence
                    (close-channel file-channel)
                    (delete-file editor-zap-filename)
                    (crunch editor-crunch-volume))))))
        form))))

(disable-language-features)   ; End of magic, for now

;;This is the query language interpreter from section 4.5 of the book,
;;with a few changes
;;-The PUTs are commented out, because they are being done
;; in initialize-data-base
;;-PP responses instead of PRINTing them
;;-Driver loop reorganized to use the editor interface

;; Query-driver-loop changed from book
(define (query-driver-loop)
  (newline)
  (princ "query==> ")
  (let ((q (read)))
    (if (equal? q '(EDIT))
        (set! q (get-query-from-editor)))
    (if q (process-query q)))
  (newline)
  (query-driver-loop))

;; Pulled out of query-driver-loop
(define (process-query query)
  (newline)
  (princ "Responses to query:")
  (let ((q (query-syntax-process query)))
    (if (assertion-to-be-added? q)
        (sequence (add-rule-or-assertion!
                   (add-assertion-body q))
                  (print "assertion added to data base")
                  (query-driver-loop))
        (sequence
         (print-stream-elements-on-separate-lines
          (map (lambda (frame)
                 (instantiate q
                              frame
                              (lambda (v f) 
                                (contract-question-mark v))))
               (qeval q (singleton '()))))))))


(define (instantiate exp frame unbound-var-handler)
  (define (copy exp)
    (cond ((constant? exp) exp)
          ((var? exp)
           (let ((vcell (binding-in-frame exp frame)))
             (if (null? vcell)             
                 (unbound-var-handler exp frame)
                 (copy (binding-value vcell)))))
          (else (cons (copy (car exp))
                      (copy (cdr exp))))))
  (copy exp))

;SECTION 4.5.2

(define (qeval query frame-stream)
  (let ((qproc (get (type query) 'qeval)))
    (if (not (null? qproc))
        (qproc (contents query) frame-stream)
        (asserted? query frame-stream))))

(define (asserted? query-pattern frame-stream)
  (append-streams 
   (flatmap (lambda (frame)
              (find-assertions query-pattern frame))
            frame-stream)
   (flatmap (lambda (frame)
              (apply-rules query-pattern frame))
            frame-stream)))

(define (conjoin conjuncts frame-stream)
  (if (empty-conjunction? conjuncts)
      frame-stream
      (conjoin (rest-conjuncts conjuncts)
               (qeval (first-conjunct conjuncts)
                      frame-stream))))

;(put 'and 'qeval conjoin)

(define (disjoin disjuncts frame-stream)
  (if (empty-disjunction? disjuncts)
      the-empty-stream
      (interleave (qeval (first-disjunct disjuncts)
                         frame-stream)
                  (disjoin (rest-disjuncts disjuncts)
                           frame-stream))))

;(put 'or 'qeval disjoin)

(define (negate a frame-stream)
  (flatmap
   (lambda (frame)
     (if (empty-stream? (qeval (negated-query a)
                               (singleton frame)))
         (singleton frame)
         the-empty-stream))
   frame-stream))

;(put 'not 'qeval negate)

(define (lisp-value call frame-stream)
  (flatmap
   (lambda (frame)
     (if (execute
          (instantiate call
                       frame
                       (lambda (v f)
                         (error "Unknown pat var -- LISP-VALUE"
                 
;;;TRUNCATED HERE ON HP MACHINE (APRIL 8, 1984 VERSION)
;;;REMAINDER OF THIS FILE IS FROM THE MARCH 26 CIT VERSION

                                v))))
         (singleton frame)
         the-empty-stream))
   frame-stream))
;(put 'lisp-value 'qeval lisp-value)
(define (execute exp)
  (apply (eval (predicate exp) user-initial-environment)
         (args exp)))

(define (always-true ignore frame-stream)
  frame-stream)                                        
;(put 'always-true 'qeval always-true)
(define (find-assertions pattern frame)
  (flatmap (lambda (datum)
             (pattern-match pattern datum frame))
           (fetch-assertions pattern frame)))
(define (pattern-match pat dat frame)
  (let ((result (internal-match pat dat frame)))
    (if (eq? result 'failed)
        the-empty-stream
        (singleton result))))
(define (internal-match pat dat frame)
  (cond ((eq? frame 'failed) 'failed)
        ((var? pat)
         (extend-if-consistent pat dat frame))
        ((constant? pat)
         (if (constant? dat)
             (if (same-constant? pat dat)
                 frame
                 'failed)
             'failed))
        ((constant? dat) 'failed)
        (else (internal-match (cdr pat)
                              (cdr dat)
                              (internal-match (car pat)
                                              (car dat)
                                              frame)))))
(define (extend-if-consistent var dat frame)
  (let ((value (binding-in-frame var frame)))
    (if (null? value)
        (extend var dat frame)
        (internal-match (binding-value value) dat frame))))
(define (apply-rules pattern frame)
  (flatmap (lambda (rule)
             (apply-a-rule rule pattern frame))
           (fetch-rules pattern frame)))
(define (apply-a-rule rule query-pattern query-frame)
  (let ((clean-rule (rename-variables-in rule)))
    (let ((unify-result (unify-match query-pattern
                                     (conclusion clean-rule)
                                     query-frame)))            
      (if (empty-stream? unify-result)
          the-empty-stream
          (qeval (rule-body clean-rule)
                 unify-result)))))
(define (rename-variables-in rule)
  (let ((rule-application-id (new-rule-application-id)))
    (define (tree-walk exp)
      (cond ((constant? exp) exp)
            ((var? exp)
             (make-new-variable exp rule-application-id))
            (else (cons (tree-walk (car exp))
                        (tree-walk (cdr exp))))))
    (tree-walk rule)))
(define (unify-match p1 p2 frame)
  (let ((result (internal-unify p1 p2 frame)))
    (if (eq? result 'failed)
        the-empty-stream
        (singleton result))))
(define (internal-unify p1 p2 frame)
  (cond ((eq? frame 'failed) 'failed)
        ((var? p1) (extend-if-possible p1 p2 frame))
        ((var? p2) (extend-if-possible p2 p1 frame))   ; ***
        ((constant? p1)
         (if (constant? p2)
             (if (same-constant? p1 p2)
                 frame
                 'failed)
             'failed))
        ((constant? p2) 'failed)
        (else (internal-unify (cdr p1)
                              (cdr p2)
                              (internal-unify (car p1)
                                              (car p2)
                                              frame)))))
(define (extend-if-possible var val frame)
  (if (equal? var val)                          ;***
      frame
      (let ((value-cell (binding-in-frame var frame)))
        (if (null? value-cell)
            (if (freefor? var val frame)        ;***
                (extend var val frame)
                'failed)
            (internal-unify (binding-value value-cell)
                            val
                            frame)))))
(define (freefor? var exp frame)
  (define (freewalk e)
    (cond ((constant? e) t)
          ((var? e)
           (if (equal? var e)
               nil
               (freewalk (lookup-in-frame e frame))))
          ((freewalk (car e)) (freewalk (cdr e)))
          (else nil)))
  (freewalk exp))
(define THE-ASSERTIONS the-empty-stream)
(define (fetch-assertions pattern frame)
  (if (use-index? pattern)
      (get-indexed-assertions pattern)
      (get-all-assertions)))
(define (get-all-assertions) THE-ASSERTIONS)
(define (get-indexed-assertions pattern)
  (get-stream (index-key-of pattern) 'assertion-stream))
(define (get-stream key1 key2)
  (let ((s (get key1 key2)))
    (if (null? s) the-empty-stream s)))
(define THE-RULES the-empty-stream)
(define (fetch-rules pattern frame)
  (if (use-index? pattern)
      (get-indexed-rules pattern)
      (get-all-rules)))
(define (get-all-rules) THE-RULES)
(define (get-indexed-rules pattern)
  (append-streams
   (get-stream (index-key-of pattern) 'rule-stream)
   (get-stream '? 'rule-stream)))
(define (add-rule-or-assertion! assertion)
  (if (rule? assertion)
      (add-rule! assertion)
      (add-assertion! assertion)))
(define (add-assertion! assertion)
  (store-assertion-in-index assertion)
  (let ((old-assertions THE-ASSERTIONS))
    (set! THE-ASSERTIONS
          (cons-stream assertion old-assertions))
    'ok))
(define (add-rule! rule)
  (store-rule-in-index rule)
  (let ((old-rules THE-RULES))
    (set! THE-RULES (cons-stream rule old-rules))
    'ok))
(define (store-assertion-in-index assertion)
  (if (indexable? assertion)
      (let ((key (index-key-of assertion)))
        (let ((current-assertion-stream
               (get-stream key 'assertion-stream)))
          (put key
               'assertion-stream
               (cons-stream assertion
                            current-assertion-stream))))))
(define (store-rule-in-index rule)
  (let ((pattern (conclusion rule)))
    (if (indexable? pattern)
        (let ((key (index-key-of pattern)))
          (let ((current-rule-stream
                 (get-stream key 'rule-stream)))
            (put key
                 'rule-stream
                 (cons-stream rule
                              current-rule-stream)))))))
(define (indexable? pat)
  (or (constant-symbol? (car pat))
      (var? (car pat))))
(define (index-key-of pat)
  (let ((key (car pat)))
    (if (var? key) '? key)))
(define (use-index? pat)
  (constant-symbol? (car pat)))
(define (type exp)
  (if (atom? exp) 
      (error "Unknown expression TYPE" exp)
      (if (symbol? (car exp))
          (car exp)
          nil)))
(define (contents exp)
  (if (atom? exp) 
      (error "Unknown expression CONTENTS" exp)
      (cdr exp)))
(define (assertion-to-be-added? exp)
  (eq? (type exp) 'assert!))
(define (add-assertion-body exp) (car (contents exp)))
(define empty-conjunction? null?)
(define first-conjunct car)
(define rest-conjuncts cdr)
(define empty-disjunction? null?)
(define first-disjunct car)
(define rest-disjuncts cdr)
(define negated-query car)
(define predicate car)
(define args cdr)
(define (rule? statement)
  (if (atom? statement)
      nil
      (eq? (car statement) 'rule)))
(define conclusion cadr)
(define (rule-body rule)
  (if (null? (cddr rule))
      '(always-true)
      (caddr rule)))
(define (query-syntax-process exp)
  (map-over-atoms expand-question-mark exp))
(define (map-over-atoms proc exp)
  (if (atom? exp)
      (proc exp)
      (cons (map-over-atoms proc (car exp))
            (map-over-atoms proc (cdr exp)))))
(define (expand-question-mark atom)
  (if (symbol? atom)
      (let ((characters (explode atom)))
        (if (eq? (car characters) '?)
            (list '? (implode (cdr characters)))
            atom))
      atom))
(define (var? exp)
  (if (atom? exp)
      nil
      (eq? (car exp) '?)))
(define constant? atom?)
(define constant-symbol? symbol?)
(define same-constant? equal?)

;**Bug fixed
(define (contract-question-mark variable)
  (implode (cons '? (explode (if (number? (cadr variable)) ; rule-app-id
				 (caddr variable)
				 (cadr variable))))))

(define rule-counter 0)
(define (new-rule-application-id)
  (set! rule-counter (1+ rule-counter))
  rule-counter)
(define (make-new-variable var rule-application-id)
  (cons '? (cons rule-application-id (cdr var))))
(define (make-binding variable value)
  (cons variable value))
(define (binding-variable binding)
  (car binding))
(define (binding-value binding)
  (cdr binding))
(define (binding-in-frame variable frame)
  (assoc variable frame))
(define (extend variable value frame)
  (cons (make-binding variable value) frame))
(define (unbound? variable frame)
  (null? (binding-in-frame variable frame)))
(define (lookup-in-frame variable frame)
  (binding-value (binding-in-frame variable frame)))
;;The PP here is PRINT in the book
(define (print-stream-elements-on-separate-lines s)
  (if (empty-stream? s)
      (print "done")
      (sequence (pp (head s))
                (print-stream-elements-on-separate-lines
                 (tail s)))))
