;; 6.001 spring 1984
;; this is the code for problem set 2 -- Lunar lander
;; before running this code you must define the procedures
;; MAKE-SHIP-STATE, HEIGHT, VELOCITY, and FUEL


(define (update ship-state fuel-burn-rate)
    (make-ship-state
     (+ (height ship-state) (* (velocity ship-state) dt))
     (+ (velocity ship-state)
        (* (- (* engine-strength fuel-burn-rate) gravity)
           dt))
     (- (fuel ship-state) (* fuel-burn-rate dt))))


(define (lander-loop ship-state)
  (show-ship-state ship-state)
  (if (landed? ship-state)
      (end-game ship-state)
      (lander-loop (update ship-state (get-burn-rate)))))

(define (show-ship-state ship-state)
  (print (list
          'height (height ship-state)
          'velocity (velocity ship-state)
          'fuel (fuel ship-state))))

(define (landed? ship-state)
  (<= (height ship-state) 0))

(define (end-game ship-state)
  (let ((final-velocity (velocity ship-state)))
    (print final-velocity)
    (cond ((>= final-velocity safe-velocity)
           (print "good landing")
           'game-over)
          (else
           (print "you crashed!")
           'game-over))))

(define (get-burn-rate)
  (if (= (tyi) burn-key)
      1
      0))

(define (play) (lander-loop (initial-ship-state)))

(define (initial-ship-state)
  (make-ship-state 50
               0
               20))

(define dt 1)

(define gravity .5)

(define safe-velocity -2)

(define engine-strength 1)

(define burn-key 32)  ;space key

