;;;; Evaluator data structures for Chapter 4

;;; Please ignore the following magic for the Scheme compiler.
(declare (usual-integrations))



(define (true? x) (not (eq? x #f)))

(define (false? x) (eq? x #f))

(define the-unspecified-value (list 'the-unspecified-value))

;;; Primitive procedures are inherited from Scheme.

(define primitive-procedure? procedure?)
(define apply-primitive-procedure apply)

;;; Compound procedures


#| This section is commented out.
;;; This is the implmentation in the book.  It is simpler,
;;;  but not as efficient as the one that is actually 
;;;  installed.  See code after close of commented section.

(define (make-procedure parameters body env)
  (list 'procedure parameters body env))

(define (compound-procedure? exp)
  (tagged-list? exp 'procedure))

(define (procedure-parameters p) (list-ref p 1))
(define (procedure-body p) (list-ref p 2))
(define (procedure-environment p) (list-ref p 3))

;;; procedures with declarations are used with the
;;;  cbn interpreter.

(define (make-procedure-with-declarations vars bproc env)
  (list 'procedure-with-declarations vars bproc env))

(define (procedure-with-declarations? obj)
  (tagged-list? obj
		'procedure-with-declarations))
|#

;;; The following implementation is more efficient.
;;;  It represents procedures as linear vectors.

(define (make-procedure vars bprocs env)
  (vector 'procedure vars bprocs env))

(define (compound-procedure? obj)
  (and (vector? obj)
       (eq? (vector-ref obj 0) 'procedure)))

(define (procedure-parameters p) (vector-ref p 1))
(define (procedure-body p) (vector-ref p 2))
(define (procedure-environment p) (vector-ref p 3))


;;; procedures with declarations are used with the
;;;  cbn interpreter.

(define (make-procedure-with-declarations vars bproc env)
  (vector 'procedure-with-declarations vars bproc env))

(define (procedure-with-declarations? obj)
  (and (vector? obj)
       (eq? (vector-ref obj 0) 'procedure-with-declarations)))

;;;          Environments
;;; An ENVIRONMENT is a chain of FRAMES.

;;;This is the implmentation in the book.  It is simpler,
;;;  but not as efficient as the one that is actually installed.

#|
(define (environment-parent env)
  (cdr env))

(define (first-frame env) (car env))

(define the-empty-environment '())

(define (environment-variables env)
  (car (first-frame env)))

(define (environment-values env)
  (cdr (first-frame env)))

(define (extend-environment variables values base-environment)
  (if (= (length variables) (length values))
      (cons (cons variables values) base-environment)
      (if (< (length variables) (length values))
          (error "Too many arguments supplied" variables values)
          (error "Too few arguments supplied" variables values))))


;;;;;NOTE!!!  In the initial implementation in the book, we should
;;;;;give an unbound variable error if we run off the end.

(define (lookup-variable-value var env)
  (define (parent-loop env)
    (define (scan vars vals)
      (cond ((null? vars)
	     (parent-loop (cdr env)))
	    ((eq? var (car vars))
	     (car vals))
	    (else
	     (scan (cdr vars) (cdr vals)))))
    (if (eq? env the-empty-environment)
	(lookup-scheme-value var)
	(scan (caar env) (cdar env))))
  (parent-loop env))

(define (set-variable-value! var val env)
  (define (parent-loop env)
    (define (scan vars vals)
      (cond ((null? vars)
	     (parent-loop (cdr env)))
	    ((eq? var (car vars))
	     (set-car! vals val)
	     the-unspecified-value)
	    (else
	     (scan (cdr vars) (cdr vals)))))
    (if (eq? env the-empty-environment)
	(error "Unbound variable -- SET!" var)
	(scan (caar env) (cdar env))))
  (parent-loop env))

(define (define-variable! var val env)
  (define (scan vars vals)
    (cond ((null? vars)
	   (set-car! (car env) (cons var (caar env)))
	   (set-cdr! (car env) (cons val (cdar env))))
	  ((eq? var (car vars))
	   (set-car! vals val)
	   the-unspecified-value)
	  (else
	   (scan (cdr vars) (cdr vals)))))
  (if (eq? env the-empty-environment)
      (error "Unbound variable -- DEFINE" var) ;should not happen.
      (scan (caar env) (cdar env))))
|#

;;; Installed vector version is faster.

(define (extend-environment variables values base-environment)
  (if (fix:= (length variables) (length values))
      (vector variables values base-environment)
      (if (fix:< (length variables) (length values))
	  (error "Too many arguments supplied" variables values)
	  (error "Too few arguments supplied" variables values))))

(define (environment-variables env)
  (vector-ref env 0))
(define (environment-values env)
  (vector-ref env 1))
(define (environment-parent env)
  (vector-ref env 2))

(define the-empty-environment '())

(define (lookup-variable-value var env)
  (let parent-loop ((env env))
    (if (eq? env the-empty-environment)
	(lookup-scheme-value var)
	(let scan
	    ((vars (vector-ref env 0))
	     (vals (vector-ref env 1)))
	  (cond ((null? vars)
		 (parent-loop (vector-ref env 2)))
		((eq? var (car vars))
		 (car vals))
		(else
		 (scan (cdr vars) (cdr vals))))))))

(define (set-variable-value! var val env)
  (let parent-loop ((env env))
    (if (eq? env the-empty-environment)
	(error "Unbound variable -- SET!" var)
	(let scan
	    ((vars (vector-ref env 0))
	     (vals (vector-ref env 1)))
	  (cond ((null? vars)
		 (parent-loop (vector-ref env 2)))
		((eq? var (car vars))
		 (set-car! vals val)
		 the-unspecified-value)
		(else
		 (scan (cdr vars) (cdr vals))))))))

(define (define-variable! var val env)
  (if (eq? env the-empty-environment)
      (error "Unbound variable -- DEFINE" var) ;should not happen.
      (let scan
	  ((vars (vector-ref env 0))
	   (vals (vector-ref env 1)))
	(cond ((null? vars)
	       (vector-set! env 0 (cons var (vector-ref env 0)))
	       (vector-set! env 1 (cons val (vector-ref env 1))))
	      ((eq? var (car vars))
	       (set-car! vals val)
	       the-unspecified-value)
	      (else
	       (scan (cdr vars) (cdr vals)))))))

;;; We speed up Scheme variable lookup by keeping
;;; a cache of the variables that we actually look up.

(define lexical-unreferenceable?
  (make-primitive-procedure 'lexical-unreferenceable?))

(define lexical-reference
  (make-primitive-procedure 'lexical-reference))

(define scheme-variable-cache '())

(define (lookup-scheme-value var)
  (let ((vcell (assq var scheme-variable-cache)))
    (cond (vcell (cdr vcell))
	  ((not (lexical-unreferenceable? user-initial-environment var))
	   (let ((val (lexical-reference user-initial-environment var)))
	     (set! scheme-variable-cache
		   (cons (cons var val) scheme-variable-cache))
	     val))
	  (else
	   (error "Unbound variable" var)))))


;;; Compiled procedure data structures

(define (make-compiled-procedure entry env)
  (list 'compiled-procedure entry env))

(define (compiled-procedure? proc) (tagged-list? proc 'compiled-procedure))

(define (compiled-procedure-entry c-proc) (cadr  c-proc))
(define (compiled-procedure-env   c-proc) (caddr c-proc))


;;;This is to keep the Scheme printer from going into an infinite loop
;;;if you try to print a circular data structure, such as an environment

(set! *unparser-list-depth-limit* 10)
(set! *unparser-list-breadth-limit* 10)

;;; Useful Timer Procedure:
;;; Sample use is:
;;;         (timed m-eval '(fact 10) the-global-environment)

(define (timed f . args)
  (let ((init (runtime)))
    (let ((v (apply f args)))
      (write-line (list 'time: (- (runtime) init)))
      v)))
