;;; -*- Scheme -*- PS9-SOLN.SCM

;;;=====================================================================

;;;		     MASSACHUSETTS INSTITUTE OF TECHNOLOGY
;;;	   Department of Electrical Engineering and Computer Science
;;;	   6.001---Structure and Interpretation of Computer Programs
;;;			     Fall Semester, 1992
;;;
;;;			        Problem Set 9  --- Solutions

;;;=====================================================================
;;; Part 1
;;;========

;;;---------------------------------------------------------------------
;;; Tutorial Problem 1

;;; Our interesting Sum Power Pairs Scheme procedure:

(define (spp p)
  (define (inner-sum b)
    (cond ((= b 1) 1)
          (else
           (+ (expt b p)
              (inner-sum (-1+ b))))))
  (cond ((= p 1) 1)
        (else
         (+ (inner-sum p)
            (spp (-1+ p))))))

;;; Its register machine implementation

(define-machine sum-power-pairs
  (registers p val b continue)
  (controller
     (assign continue done)
    spp					; continue = where to return to
     (branch (= (fetch p) 1) rtn-1)
    spp-left-addend
     (assign b (fetch p))
     (save   continue)			; stack = rtn cont, ...
     (assign continue spp-right-addend)
     (goto inner-sum)
    spp-right-addend			; stack = rtn cont, ...
     (assign p (-1+ (fetch p)))
     (assign continue spp-add)
     (save val)				; stack = inner-sum(p), rtn cont, ...
     (goto spp)
    spp-add				; val=spp(p-1); stack= inner-sum(p), rtn cont,...
     (restore b)			;   b := inner-sum(p)  [hack temp register]
     (assign val			; stack = rtn cont, ...
	     (+ (fetch b) (fetch val)))	; val := inner-sum(p) + spp(p-1)
     (restore continue)			; continue = rtn cont; stack = ...
     (goto (fetch continue))
    inner-sum				; continue = rtn cont
     (branch (= (fetch b) 1) rtn-1)
    inner-sum-left-addend
     (assign val			; val := b^p
	     (expt (fetch b) (fetch p)))
    inner-sum-right-addend
     (assign b (-1+ (fetch b)))
     (save   continue)			; stack = rtn cont, ...
     (assign continue inner-sum-add)
     (save val)				; stack = b^p, rtn cont,...(or could use tmp reg)
     (goto inner-sum)
    inner-sum-add			; val = inner-sum(b-1); stack = b^p,...
     (restore b)			; b := b^p  [hack temp register]
     (assign val			; stack = rtn cont, ...
	     (+ (fetch b) (fetch val))) ; val := b^p + inner-sum(b-1)
     (restore continue)			; continue = rtn cont; stack = ...
     (goto (fetch continue))
    rtn-1				; continue = rtn cont
     (assign val 1)
     (goto (fetch continue))
    done
   ))

;;; The time  complexity of this machine is:
;;;           O(n^2) since it does O(n) calls to inner-sum, which is itself O(n) in time.
;;; Its space complexity is:               
;;;           O(n)   since at most one full branch of the binary search tree of height n
;;;                  is pending at any moment.

;;;=====================================================================
;;; Part 2
;;;========

;;; Max Stack depth =      2n - 1 for n > 1
;;; Total Pushes    = n^2 + n - 2 for n > 1 
;;;
;;; Total Mach Ops  = 1/2 (11n^2 + 21n - 24)

;;; The first two equations could be deduced by (careful) inspection.
;;; For the last one, we guess that the equation must be of the form
;;;
;;;    An^2 + Bn + C
;;;
;;; so we can solve for the three unknown constants (A,B,C) by generating
;;; three simultaneous linear equations:
;;;
;;;  n = 1:   A +  B + C =  4  [from the table]
;;;  n = 2:  4A + 2B + C = 31
;;;  n = 3:  9A + 3B + C = 69
;;;
;;; We now have three linear equations in three unknowns, so we can solve:
;;;
;;;  |  9  3  1 69 |    [1]
;;;  |  4  2  1 31 |    [2]
;;;  |  1  1  1  4 |    [3]
;;;
;;;  |  5  1  0 38 |   ; [1]-[2]
;;;  |  3  1  0 27 |   ; [2]-[3]
;;;  |  2  0  0 11 |   ; new1 - new2
;;;
;;; So:  A =  11/2
;;;      B =  21/2   [by back substitution into new2]
;;;      C = -12     [by back substitution into [3]]
;;;
;;; Thus: Total mach ops = (11/2)n^2 + (21/2)n - 12
;;;
;;; We can confirm that this indeed corresponds to the observed data via:
;;;
;;; (map (lambda (n) (/ (+ (* 11 n n) (* 21 n) -24) 2)) '(1 2 3 4 5 10))
;;;;Value: (4. 31. 69. 118. 178. 643.)

;;;=====================================================================
;;; Part 3
;;;========

;;;---------------------------------------------------------------------
;;; Lab exercise 3.1:
;;;
;;; Our machine was as listed above so our statistics were exactly those
;;;  tabularized in the Part 2.

;;;---------------------------------------------------------------------
;;; Lab exercise 3.2:
;;;
;;;   Answers will vary since we did not specify exactly what simple
;;;    expressions to trace.

;;;---------------------------------------------------------------------
;;; Lab exercise 3.3:
;;;
;;; Answers will vary as per your particular definition of the Scheme
;;;   procedure for computing SUM-POWER-PAIRS.
;;; Assuming that in tutorial covering Tutorial Problem 1 your tutor
;;;   cajoled you into using the Scheme definition shown above, you
;;;   should have discovered the following statistics:
;;;
;;;  Interpreted SPP emperical stats
;;; |----------------------------------------------------------------------|
;;; |  n |          val |   total ops |   total pushes |   max stack depth |
;;; |----+--------------+-------------+----------------+-------------------|
;;; |  1 |            1 |         188 |             21 |                 8 |
;;; |  2 |            6 |         897 |            108 |                16 |
;;; |  3 |           42 |        1904 |            232 |                19 |
;;; |  4 |          396 |        3209 |            393 |                22 |
;;; |  5 |         4821 |        4812 |            591 |                25 |
;;; | 10 |  15514603818 |       17297 |           2136 |                40 |
;;; |----------------------------------------------------------------------|

;;; From these figures, we derived the following equations:
;;;
;;; Max Stack Depth =                   3n  +  10     n > 1  [by inspection]
;;; Total Pushes    =   1/2 ( 37n^2 +  63n  -  58)
;;; Total Ops       =        149n^2 + 262n  - 223
;;;
;;; Notice that the orders of growth for these statistics have not changed:
;;;  only the constant factors have increased by running interpreted code
;;;  versus running a hand-made machine.
;;;
;;; By the way, these explicit formulas were derived by solving simultaneous
;;;  linear equations as sketched above. Specifically, we notice the following
;;;  family of solutions for all three equations:
;;;
;;;   A B C k
;;; | 9 3 1 X |      | 5 1 0  X-Y   |      B = X-Y-5A   [from 5 1 0 X-Y]
;;; | 4 2 1 Y |  --> | 3 1 0    Y-Z | -->  
;;; | 1 1 1 Z |      | 2 0 0 X-2Y-Z |      A = 1/2 (X-2Y+Z)
;;;                  |-2 0 1 2Z-Y   |      C = 2Z-Y+2A
;;;
;;; Thus plugging in X, Y, Z from the table generated the derived coefficients.

;;; Oh... the following Scheme procedure also came in handy [one of the morals
;;;       of 6.001 is ``If something is tedious, boring, and easily formalized
;;;       by a procedural abstraction, then make your stupid computer do it for
;;;       you!'']

(define (derive-formula X Y Z)
  (let ((A (/ (+ X (* -2 Y) Z) 2)))
    (let ((B  (- X Y (* 5 A)))
	  (C (+ (* 2 Z) (- Y) (* 2 A))))
      (list (list (list '* A 'n^2) '+ (list '* B 'n) '+ C)
	    (map (lambda (n) (+ (* A n n) (* B n) C))
		 '(1 2 3 4 5 10))))))

;;; You can verify for yourself that it derives the above shown formulae (and
;;;   displays their values at n = 1--5,10 for good measure).
;;;
;;; Indeed, this can be used to further verify the latter two equations of Part 2.

;;;---------------------------------------------------------------------
;;; Lab exercise 3.4:
;;;
;;; Again, your answers will vary, but assuming your tutor badgered you
;;;   into using our industry standard definition of sum-power-pairs...
;;;
;;;(pp (compile '(define (spp p)
;;;                (define (inner-sum b)
;;;                  (cond ((= b 1) 1)
;;;                        (else
;;;                         (+ (expt b p)
;;;                            (inner-sum (-1+ b))))))
;;;                (cond ((= p 1) 1)
;;;                      (else
;;;                       (+ (inner-sum p)
;;;                          (spp (-1+ p))))))
;;;             ))

;;; Compiled spp w/o open coding

;;;((assign val (make-compiled-procedure entry2 (fetch env)))
;;; (goto after-lambda1)
;;;
;;; entry2
;;; (assign env (compiled-procedure-env (fetch fun)))
;;; (assign env (extend-binding-environment '(p) (fetch argl) (fetch env)))
;;; (assign val (make-compiled-procedure entry9 (fetch env)))
;;; (goto after-lambda8)
;;; 
;;; entry9
;;; (assign env (compiled-procedure-env (fetch fun)))
;;; (assign env (extend-binding-environment '(b) (fetch argl) (fetch env)))
;;; (save env)
;;; (assign fun (lookup-variable-value '= (fetch env)))
;;; (assign val (lookup-variable-value 'b (fetch env)))
;;; (assign argl (cons (fetch val) '#f))
;;; (assign val '1)
;;; (assign argl (cons (fetch val) (fetch argl)))
;;; (assign continue after-call11)
;;; (save continue)
;;; (goto apply-dispatch)
;;; after-call11
;;; (restore env)
;;; (branch (true? (fetch val)) true-branch10)
;;; (assign fun (lookup-variable-value '+ (fetch env)))
;;; (save fun)
;;; (save env)
;;; (assign fun (lookup-variable-value 'expt (fetch env)))
;;; (assign val (lookup-variable-value 'b (fetch env)))
;;; (assign argl (cons (fetch val) '#f))
;;; (assign val (lookup-variable-value 'p (fetch env)))
;;; (assign argl (cons (fetch val) (fetch argl)))
;;; (assign continue after-call12)
;;; (save continue)
;;; (goto apply-dispatch)
;;; after-call12
;;; (assign argl (cons (fetch val) '#f))
;;; (restore env)
;;; (save argl)
;;; (assign fun (lookup-variable-value 'inner-sum (fetch env)))
;;; (save fun)
;;; (assign fun (lookup-variable-value '-1+ (fetch env)))
;;; (assign val (lookup-variable-value 'b (fetch env)))
;;; (assign argl (cons (fetch val) '#f))
;;; (assign continue after-call14)
;;; (save continue)
;;; (goto apply-dispatch)
;;; after-call14
;;; (assign argl (cons (fetch val) '#f))
;;; (restore fun)
;;; (assign continue after-call13)
;;; (save continue)
;;; (goto apply-dispatch)
;;; after-call13
;;; (restore argl)
;;; (assign argl (cons (fetch val) (fetch argl)))
;;; (restore fun)
;;; (goto apply-dispatch)
;;;
;;; true-branch10
;;; (assign val '1)
;;; (restore continue)
;;; (goto (fetch continue))
;;;
;;; after-lambda8
;;; (perform (define-variable! 'inner-sum (fetch val) (fetch env)))
;;; (save env)
;;; (assign fun (lookup-variable-value '= (fetch env)))
;;; (assign val (lookup-variable-value 'p (fetch env)))
;;; (assign argl (cons (fetch val) '#f))
;;; (assign val '1)
;;; (assign argl (cons (fetch val) (fetch argl)))
;;; (assign continue after-call4)
;;; (save continue)
;;; (goto apply-dispatch)
;;; after-call4
;;; (restore env)
;;; (branch (true? (fetch val)) true-branch3)
;;; (assign fun (lookup-variable-value '+ (fetch env)))
;;; (save fun)
;;; (save env)
;;; (assign fun (lookup-variable-value 'inner-sum (fetch env)))
;;; (assign val (lookup-variable-value 'p (fetch env)))
;;; (assign argl (cons (fetch val) '#f))
;;; (assign continue after-call5)
;;; (save continue)
;;; (goto apply-dispatch)
;;; after-call5
;;; (assign argl (cons (fetch val) '#f))
;;; (restore env)
;;; (save argl)
;;; (assign fun (lookup-variable-value 'spp (fetch env)))
;;; (save fun)
;;; (assign fun (lookup-variable-value '-1+ (fetch env)))
;;; (assign val (lookup-variable-value 'p (fetch env)))
;;; (assign argl (cons (fetch val) '#f))
;;; (assign continue after-call7)
;;; (save continue)
;;; (goto apply-dispatch)
;;; after-call7
;;; (assign argl (cons (fetch val) '#f))
;;; (restore fun)
;;; (assign continue after-call6)
;;; (save continue)
;;; (goto apply-dispatch)
;;; after-call6
;;; (restore argl)
;;; (assign argl (cons (fetch val) (fetch argl)))
;;; (restore fun)
;;; (goto apply-dispatch)
;;;
;;; true-branch3
;;; (assign val '1)
;;; (restore continue)
;;; (goto (fetch continue))
;;;
;;; after-lambda1
;;; (perform (define-variable! 'spp (fetch val) (fetch env)))
;;; (assign val '*undefined*)
;;; (restore continue)
;;; (goto (fetch continue)))

;;;---------------------------------------------------------------------
;;; Lab exercise 3.5:
;;;
;;;  Compiled SPP emperical stats
;;; |----------------------------------------------------------------------|
;;; |  n |          val |   total ops |   total pushes |   max stack depth |
;;; |----+--------------+-------------+----------------+-------------------|
;;; |  1 |            1 |          81 |              7 |                 3 |
;;; |  2 |            6 |         233 |             27 |                 9 |
;;; |  3 |           42 |         450 |             56 |                12 |
;;; |  4 |          396 |         732 |             94 |                15 |
;;; |  5 |         4821 |        1079 |            141 |                18 |
;;; | 10 |  15514603818 |        3789 |            511 |                33 |
;;; |----------------------------------------------------------------------|

;;; Max Stack Depth =                3n +  3     n > 1  [by inspection]
;;; Total Pushes    = 1/2 ( 9n^2 +  13n -  8)
;;; Total Ops       = 1/2 (65n^2 + 109n - 12)

;;; These last two were again generated by our handy-dandy DERIVE-FORMULA.


;;;---------------------------------------------------------------------
;;; Lab exercise 3.6
;;;
;;; Again, you answers may vary but not if you were properly coddled by
;;;   your tutor.
;;;
(pp (compile '(define (spp p)
		(define (inner-sum b)
		  (cond ((= b 1) 1)
			(else
			 (+ (expt b p)
			    (inner-sum (-1+ b))))))
		(cond ((= p 1) 1)
		      (else
		       (+ (inner-sum p)
			  (spp (-1+ p))))))
	     ))


;;; Compiled spp with open coding

;;;((assign val (make-compiled-procedure entry58 (fetch env)))
;;; (goto after-lambda57)
;;;
;;; entry58
;;; (assign env (compiled-procedure-env (fetch fun)))
;;; (assign env (extend-binding-environment '(p) (fetch argl) (fetch env)))
;;; (assign val (make-compiled-procedure entry63 (fetch env)))
;;; (goto after-lambda62)
;;;
;;; entry63
;;; (assign env (compiled-procedure-env (fetch fun)))
;;; (assign env (extend-binding-environment '(b) (fetch argl) (fetch env)))
;;; (assign arg2 (lookup-variable-value 'b (fetch env)))
;;; (assign arg3 '1)
;;; (assign val (= (fetch arg2) (fetch arg3)))
;;; (branch (true? (fetch val)) true-branch64)
;;; (assign arg2 (lookup-variable-value 'b (fetch env)))
;;; (assign arg3 (lookup-variable-value 'p (fetch env)))
;;; (assign arg2 (expt (fetch arg2) (fetch arg3)))
;;; (save arg2)
;;; (assign fun (lookup-variable-value 'inner-sum (fetch env)))
;;; (assign arg3 (lookup-variable-value 'b (fetch env)))
;;; (assign val (-1+ (fetch arg3)))
;;; (assign argl (cons (fetch val) '#f))
;;; (assign continue after-call65)
;;; (save continue)
;;; (goto apply-dispatch)
;;; after-call65
;;; (assign arg3 (fetch val))
;;; (restore arg2)
;;; (assign val (+ (fetch arg2) (fetch arg3)))
;;; (restore continue)
;;; (goto (fetch continue))
;;;
;;; true-branch64
;;; (assign val '1)
;;; (restore continue)
;;; (goto (fetch continue))
;;;
;;; after-lambda62
;;; (perform (define-variable! 'inner-sum (fetch val) (fetch env)))
;;; (assign arg2 (lookup-variable-value 'p (fetch env)))
;;; (assign arg3 '1)
;;; (assign val (= (fetch arg2) (fetch arg3)))
;;; (branch (true? (fetch val)) true-branch59)
;;; (save env)
;;; (assign fun (lookup-variable-value 'inner-sum (fetch env)))
;;; (assign val (lookup-variable-value 'p (fetch env)))
;;; (assign argl (cons (fetch val) '#f))
;;; (assign continue after-call61)
;;; (save continue)
;;; (goto apply-dispatch)
;;; after-call61
;;; (assign arg2 (fetch val))
;;; (restore env)
;;; (save arg2)
;;; (assign fun (lookup-variable-value 'spp (fetch env)))
;;; (assign arg3 (lookup-variable-value 'p (fetch env)))
;;; (assign val (-1+ (fetch arg3)))
;;; (assign argl (cons (fetch val) '#f))
;;; (assign continue after-call60)
;;; (save continue)
;;; (goto apply-dispatch)
;;; after-call60
;;; (assign arg3 (fetch val))
;;; (restore arg2)
;;; (assign val (+ (fetch arg2) (fetch arg3)))
;;; (restore continue)
;;; (goto (fetch continue))
;;;
;;; true-branch59
;;; (assign val '1)
;;; (restore continue)
;;; (goto (fetch continue))
;;;
;;; after-lambda57
;;; (perform (define-variable! 'spp (fetch val) (fetch env)))
;;; (assign val '*undefined*)
;;; (restore continue)
;;; (goto (fetch continue)))

;;;  Open-coded Compiled SPP emperical stats
;;; |----------------------------------------------------------------------|
;;; |  n |          val |   total ops |   total pushes |   max stack depth |
;;; |----+--------------+-------------+----------------+-------------------|
;;; |  1 |            1 |          70 |              5 |                 3 |
;;; |  2 |            6 |         147 |             11 |                 5 |
;;; |  3 |           42 |         251 |             19 |                 7 |
;;; |  4 |          396 |         382 |             29 |                 9 |
;;; |  5 |         4821 |         540 |             41 |                11 |
;;; | 10 |  15514603818 |        1735 |            131 |                21 |
;;; |----------------------------------------------------------------------|

;;; Max Stack Depth =               2n +   1   [by inspection]
;;; Total Pushes    =        n^2 +  3n +   1   [by our nifty
;;; Total Ops       = 1/2 (27n^2 + 73n + 140)      DERIVE-FORMULA hack]



;;;---------------------------------------------------------------------
;;; Lab exercise 3.7
;;;

;;;                    SUM-POWER-PAIRS on input N
;;;-------------------------------------------------------------------------------|
;;;                               total ops |            stack pushes | max stack |
;;;-------------------------------------------------------------------------------|
;;;  hand-coded:  1/2 ( 11n^2 + 21n  -  24) |  1/2 ( 2n^2 +  2n -  4) |  2n -  1  |
;;; interpreted:  1/2 (298n^2 + 524n - 446) |  1/2 (37n^2 + 63n - 58) |  3n + 10  |
;;;    compiled:  1/2 ( 65n^2 + 109n -  12) |  1/2 ( 9n^2 + 13n -  8) |  3n +  3  |
;;; compiled(o):  1/2 ( 27n^2 +  73n + 140) |  1/2 ( 2n^2 +  6n +  2) |  2n +  1  |
;;;-------------------------------------------------------------------------------|

;;;                 limit as N becomes large, of the ratio
;;;-------------------------------------------------------------------------------|
;;;                               total ops |            stack pushes | max stack |
;;; interpreted/hand-coded :           27:1 |                    18:1 |       2:1 |
;;; interpreted/compiled   :            5:1 |                     4:1 |       1:1 |
;;;    compiled/compiled(o):            2:1 |                     4:1 |       2:1 |
;;; compiled(o)/hand-coded :            2:1 |                     4:1 |       1:1 |
;;;-------------------------------------------------------------------------------|

;;; Many rich insights come to light from these emperical results. First, interpreted
;;; code can be moby slow and can thrash stack memory compared to hand-coded machine
;;; code. Naive compiling can speed interpreted code by a factor of 5 and 4 respectively
;;; and open coding of primitives can account for an additional factor of 2 in time
;;; and another factor of 4 in stack accesses. Notice that open coding can also reduce
;;; the total needed stack size for a computation to that of our clever hand-coded
;;; machine. All in all, compiled code can be within a factor of 2 in total time and
;;; factor of 4 in stack operations with respect to hand coded machine code. Given
;;; how tedious (and verbose) it is to generate hand-crafted machine code, this is
;;; not bad for an implemented-once compiler that can compile any Scheme program.
;;; In fact, it is down-right impressive for a compiler whose entire implementation
;;; listing spans only a handfull of pages.

;;; Many rich additional optimizations can be imagined. We leave these open to
;;; tutorial discussion. Annual conferences on this topic are sponsored by the ACM,
;;; along with sundry other annual conferences on many other aspects of programming
;;; that have been discussed in 6.001.

;;;=====================================================================
;;; Part 4
;;;========

;;;---------------------------------------------------------------------
;;; Lab exercise 4.1:
;;;
;;;  See listings.

;;;---------------------------------------------------------------------
;;; Lab exercise 4.2:
;;;
;;;  See Lab exercise 4.1

;;;---------------------------------------------------------------------
;;; Lab exercise 4.3:
;;;
;;;  The mystery Scheme code was:

(define (mumble n)
  (cond ((<= n 2) -11)
	(else (* n (mumble (- n 5))))))

;;; If our compiler were open coding primitives, the output would be:

;;;((assign val (make-compiled-procedure entry82 (fetch env)))
;;; (goto after-lambda81)
;;;
;;; entry82
;;; (assign env (compiled-procedure-env (fetch fun)))
;;; (assign env (extend-binding-environment '(n) (fetch argl) (fetch env)))
;;; (assign arg2 (lookup-variable-value 'n (fetch env)))
;;; (assign arg3 '2)
;;; (assign val (<= (fetch arg2) (fetch arg3)))
;;; (branch (true? (fetch val)) true-branch83)
;;; (assign arg2 (lookup-variable-value 'n (fetch env)))
;;; (save arg2)
;;; (assign fun (lookup-variable-value 'mumble (fetch env)))
;;; (assign arg2 (lookup-variable-value 'n (fetch env)))
;;; (assign arg3 '5)
;;; (assign val (- (fetch arg2) (fetch arg3)))
;;; (assign argl (cons (fetch val) '#f))
;;; (assign continue after-call84)
;;; (save continue)
;;; (goto apply-dispatch)
;;;
;;; after-call84
;;; (assign arg3 (fetch val))
;;; (restore arg2)
;;; (assign val (* (fetch arg2) (fetch arg3)))
;;; (restore continue)
;;; (goto (fetch continue))
;;;
;;; true-branch83
;;; (assign val '-11)
;;; (restore continue)
;;; (goto (fetch continue))
;;;
;;; after-lambda81
;;; (perform (define-variable! 'mumble (fetch val) (fetch env)))
;;; (assign val '*undefined*)
;;; (restore continue)
;;; (goto (fetch continue))
