;;; An interesting Sum Power Pairs procedure

(define (spp p)
  (define (inner-sum b)
    (cond ((= b 1) 1)
          (else
           (+ (expt b p)
              (inner-sum (-1+ b))))))
  (cond ((= p 1) 1)
        (else
         (+ (inner-sum p)
            (spp (-1+ p))))))

;;; It's register machine implementation

(define-machine sum-power-pairs
  (registers p val b continue)
  (controller
     (assign continue done)
    spp					; continue = where to return to
     (branch (= (fetch p) 1) rtn-1)
    spp-left-addend
     (assign b (fetch p))
     (save   continue)			; stack = rtn cont, ...
     (assign continue spp-right-addend)
     (goto inner-sum)
    spp-right-addend			; stack = rtn cont, ...
     (assign p (-1+ (fetch p)))
     (assign continue spp-add)
     (save val)				; stack = inner-sum(p), rtn cont, ...
     (goto spp)
    spp-add				; val = spp(p-1); stack = inner-sum(p), rtn cont, ...
     (restore b)			;   b := inner-sum(p)  [hack temp register]
     (assign val			; stack = rtn cont, ...
	     (+ (fetch b) (fetch val)))	; val := inner-sum(p) + spp(p-1)
     (restore continue)			; continue = rtn cont; stack = ...
     (goto (fetch continue))
    inner-sum				; continue = rtn cont
     (branch (= (fetch b) 1) rtn-1)
    inner-sum-left-addend
     (assign val			; val := b^p
	     (expt (fetch b) (fetch p)))
    inner-sum-right-addend
     (assign b (-1+ (fetch b)))
     (save   continue)			; stack = rtn cont, ...
     (assign continue inner-sum-add)
     (save val)				; stack = b^p, rtn cont, ...  (or could use tmp reg)
     (goto inner-sum)
    inner-sum-add			; val = inner-sum(b-1); stack = b^p,...
     (restore b)			; b := b^p  [hack temp register]
     (assign val			; stack = rtn cont, ...
	     (+ (fetch b) (fetch val))) ; val := b^p + inner-sum(b-1)
     (restore continue)			; continue = rtn cont; stack = ...
     (goto (fetch continue))
    rtn-1				; continue = rtn cont
     (assign val 1)
     (goto (fetch continue))
    done
   ))

;;; Test procedure for register machine

(define (test-spp n)
  (remote-assign sum-power-pairs 'p n)
  (start sum-power-pairs)
  (initialize-stack       sum-power-pairs)
  (initialize-ops-counter sum-power-pairs)
  (remote-fetch sum-power-pairs 'val)
  )

(define (spp-table n-list)
  (define separater (make-string 69 #\-))
  (define (pretty-spp n)
    (newline)
    (display separater)
    (let ((val (test-spp n)))
      (newline)
      (display (list 'val '= val))))
  (for-each pretty-spp n-list)
  (newline)
  (display separater)
  (newline)
  'done)
