;; -*- Scheme -*- PS9-LEXV.SCM

;;		     MASSACHUSETTS INSTITUTE OF TECHNOLOGY
;;	   Department of Electrical Engineering and Computer Science
;;	   6.001---Structure and Interpretation of Computer Programs
;;			     Fall Semester, 1992
;;
;;				 Problem Set 9

;;; Lexical variable addressing as per section 5.3.7

(define (compile-variable-expression exp c-t-env target cont)
  (append-instruction-sequences
   (let ((name (variable-expression-name exp)))
     (let ((lexical-address (variable->lexical-address name c-t-env)))
       (if (not lexical-address)
	   (compile-unknown-variable name c-t-env target)
	   (compile-known-variable lexical-address target))))
   (compile-continuation cont)))

(define (compile-unknown-variable name c-t-env target)
  (append-instruction-sequences
   (make-get-variable-binding name c-t-env)
   (make-register-assignment target
			     (make-operation 'binding-value
					     (make-fetch 'arg0)))))

(define (compile-known-variable lexical-address target)
  (append-instruction-sequences
   (make-get-lexically-addressed-binding lexical-address)
   (make-register-assignment target
			     (make-operation 'binding-value
					     (make-fetch 'arg0)))))

(define (make-get-lexically-addressed-binding lexical-address)
  (append-instruction-sequences
   (make-register-assignment
    'arg0
    (make-operation 'list-ref
		    (make-fetch 'env)
		    (make-constant
		     (lexical-address-depth lexical-address))))
   (make-register-assignment
    'arg0
    (make-operation 'list-ref
		    (make-fetch 'arg0)
		    (make-constant
		     (lexical-address-offset lexical-address))))))

(define (variable->lexical-address name c-t-env)
  (define (offset-in-frame frame offset)
    (cond ((null? frame)
	   false)
	  ((eq? name (car frame))
	   offset)
	  (else
	   (offset-in-frame (cdr frame) (1+ offset)))))

  (define (find-in-env env depth)
    (if (null? env)
	false
	(let ((offset (offset-in-frame (first-frame env) 0)))
	  (if offset
	      (make-lexical-address depth offset)
	      (find-in-env (rest-frames env) (1+ depth))))))

  (find-in-env c-t-env 0))

(define (make-lexical-address depth offset)
  (cons                       depth offset))

(define (lexical-address-depth  la) (car la))
(define (lexical-address-offset la) (cdr la))
