;;;;  PS3-CODE.SCM
;;; This is the code for the square-limit language
;;;  of problem set 3

;;;; Representing vectors, segments, and frames

(define make-vect cons)
(define vector-xcor car)
(define vector-ycor cdr)

(define make-segment cons)
(define segment-start car)
(define segment-end cdr)

(define (vector-add v1 v2)
  (make-vect (+ (vector-xcor v1) (vector-xcor v2))
             (+ (vector-ycor v1) (vector-ycor v2))))

(define (vector-sub v1 v2)
  (vector-add v1 (vector-scale -1 v2)))

(define (vector-scale x v)
  (make-vect (* x (vector-xcor v))
             (* x (vector-ycor v))))

(define (make-frame origin edge1 edge2)
  (list 'frame origin edge1 edge2))

(define frame-origin cadr)
(define frame-edge1 caddr)
(define frame-edge2 cadddr)

;;;; Primitive painters

;;;The following procedures create primitive painters.
;;;They are defined in the file primitive-painters, which is compiled
;;;so that things will run fast.  You need not deal with the implementation of
;;;these procedures, just use them as black boxes.

;;;construct a painter from a number
;;;(define (number->painter num) ....)

;;;construct a painter from a procedure
;;;(define (procedure->painter proc) ....)

;;;construct a painter from a list of segments
;;;(define (segments->painter segments) ....)

;;;construct a painter from a list of picture (as in PS1)
;;;(define (picture->painter picture) ....)

;;;The following procedure loads a painter from a image in the 6001-image directory

(define (load-painter file-name)
  (picture->painter (pgm-file->picture (string-append "~u6001/6001-images/" file-name ".pgm"))))

;;; Some simple painters

(define black (number->painter 0))

(define white (number->painter 255))

(define gray (number->painter 150))

(define diagonal-shading
  (procedure->painter (lambda (x y) (* 100 (+ x y)))))

(define mark-of-zorro
  (let ((v1 (make-vect .1 .9))
        (v2 (make-vect .8 .9))
        (v3 (make-vect .1 .2))
        (v4 (make-vect .9 .3)))
    (segments->painter
     (list (make-segment v1 v2)
           (make-segment v2 v3)
           (make-segment v3 v4)))))

(define fovnder (load-painter "fovnder"))

;;;; Painting images on the screen

(define (paint window painter)
  (if (not (graphics-device? window))
      (error "bad window" window))
  (set-painter-resolution! 128)
  (painter (screen-frame))
  (picture-display window *the-screen* 0 256))

(define (paint-hi-res window painter)
  (if (not (graphics-device? window))
      (error "bad window" window))
  (set-painter-resolution! 256)
  (painter (screen-frame))
  (picture-display window *the-screen* 0 256))

(define (print-last-image)
  (error "need to define print-last-image"))


;;;; Basic means of combination for painters

(define (rotate90 painter)
  (lambda (frame)
    (painter (make-frame
              (vector-add (frame-origin frame)
                          (frame-edge1 frame))
              (frame-edge2 frame)
              (vector-scale -1 (frame-edge1 frame))))))

(define (repeated proc n)
  (lambda (thing)
    (if (= n 0) thing
        ((repeated proc (- n 1)) (proc thing)))))

(define rotate180 (repeated rotate90 2))
(define rotate270 (repeated rotate90 3))

(define (flip-horiz painter)
  (lambda (frame)
    (painter (make-frame (vector-add (frame-origin frame) (frame-edge1 frame))
                         (vector-scale -1 (frame-edge1 frame))
                         (frame-edge2 frame)))))

(define (beside painter1 painter2)
  (lambda (frame)
    (painter1 (make-frame
               (frame-origin frame)
               (vector-scale .5 (frame-edge1 frame))
               (frame-edge2 frame)))
    (painter2 (make-frame
               (vector-add (frame-origin frame)
                           (vector-scale .5 (frame-edge1 frame)))
               (vector-scale .5 (frame-edge1 frame))
               (frame-edge2 frame)))))

(define (below painter1 painter2)
  (rotate270 (beside (rotate90 painter2)
                     (rotate90 painter1))))

(define (superimpose painter1 painter2)
  (lambda (frame)
    (painter1 frame)
    (painter2 frame)))

;;; More complex means of combination

(define (right-split painter n)
  (if (= n 1)
      painter
      (let ((smaller (right-split painter (- n 1))))
        (beside painter (below smaller smaller)))))

