;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; PS9-ENVX.SCM -- AMB-Scheme extensions for loading PS9 regsim code  ;;;
;;;                 into AMBScheme.  See also the file PS9-ENVX.AMB    ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;; NB: Be sure to Load Problem Set 8 before loading these extensions.

;;; Prepare for some extensions...

(define (extend-the-amb-global-environment!)
  (install-new-primitives)
  (install-new-constants)
  'extended)

(define (install-new-primitives)
  (set! the-global-environment (setup-environment))
  'installed)

(define (install-new-constants)
  (for-each (lambda (binding)
	      (define-variable! (binding-variable binding)
		                (binding-value    binding)
				the-global-environment))
	    new-constants-to-install)
  'installed)

;;; Show a little mercy for the aesthetically challenged user
(define new-constants-to-install  (list (make-binding 'nil    nil )
					(make-binding 't (not nil))))
(set! ducky-primitives (append '(and or pp) ducky-primitives)) ;; All ducky

;;; Support for CALL-WITH-CURRENT-CONTINUATION in AMB-Scheme

(define (initialize-evaluator)
  (set! the-global-environment (setup-environment))
  (let ((call-with-nonlocal-exit call-with-current-continuation))
    (call-with-nonlocal-exit
     (lambda (exit-driver-loop)	; cwcc not tail rec so need exit continuation
       (set! exit (lambda (exp)
		    (exit-driver-loop (if (atom? exp) exp (car exp)))))
       (driver-loop)))))

(define magic-recontinue driver-loop)	; Safe and non-disruptive default

;;; THE CORE OF THE EVALUATOR -- extended from PS8-AMB.SCM
;;;
;;; FAIL is a procedure of zero arguments.
;;; GOT-ONE is a procedure of two args, the value and the fail continuation

(define (amb-eval exp env got-one fail)
  (cond ((self-evaluating? exp)
         (got-one exp fail))
        ((quoted? exp)
         (got-one (text-of-quotation exp) fail))
        ((variable? exp)
         (got-one (lookup-variable-value exp env) fail))
        ((definition? exp)
         (eval-definition exp env got-one fail))
        ((assignment? exp)
         (eval-assignment exp env got-one fail))
        ((temporary-assignment? exp)
         (eval-temporary-assignment exp env got-one fail))
        ((lambda? exp)
         (got-one (make-procedure exp env) fail))
        ((conditional? exp)
         (eval-cond (clauses exp) env got-one fail))
        ((let? exp)
         (eval-let exp env got-one fail))
        ((amb? exp)
         (eval-amb (operands exp) env got-one fail))
        ((all-values? exp)
         (eval-all-values (operands exp) env got-one fail))
	;;;----------------New env extensions start here---------------------
	((if?             exp) (eval-if             exp env got-one fail))
	((delay?          exp) (eval-delay          exp env got-one fail))
	((the-env?        exp) (eval-the-env        exp env got-one fail))
	((define-machine? exp) (eval-define-machine exp env got-one fail))
	((make-env?       exp) (eval-make-env       exp env got-one fail))
	((error?          exp) (eval-error          exp env got-one fail))
	;;;----------------Normal stuff from here on---------------------------

        ((application? exp)
         (amb-eval (operator exp) 
                   env 
                   (lambda (proc fail-rator)
                     (list-of-values (operands exp) 
                                     env
                                     (lambda (args fail-rands)
                                       (amb-apply proc args got-one fail-rands))
                                     fail-rator)) 
                   fail))
        (else (amb-error "Unknown expression type -- AMB-EVAL" exp) 0)))

(define (if?             exp) (form-with-tag? 'if               exp))
(define (delay?          exp) (form-with-tag? 'delay            exp))
(define (the-env?        exp) (form-with-tag? 'the-environment  exp))
(define (define-machine? exp) (form-with-tag? 'define-machine   exp))
(define (make-env?       exp) (form-with-tag? 'make-environment exp))
(define (error?          exp) (form-with-tag? 'error            exp))

;;; Make environments be first-class

(define (eval-the-env exp env got-one fail)
  (got-one env fail))

;;; Some macros... syntax not very abstracted [DEFINE-MACROS would be handy!]

(define (eval-if exp env got-one fail)
  (amb-eval (cadr exp) env
	    (lambda (pred failp)
	      (if (true? pred)
		  (amb-eval (caddr  exp) env got-one failp)
		  (amb-eval (cadddr exp) env got-one failp)))
	    fail))

(define (eval-delay exp env got-one fail)
  (amb-eval (list 'MEMO-PROC (list 'LAMBDA '() (cadr exp))) env got-one fail))

(define (eval-define-machine exp env got-one fail)
  (amb-eval (list 'DEFINE (cadr exp)
		  (list 'BUILD-MODEL
			(list 'QUOTE (cdr (caddr exp)))
			(list 'QUOTE (cdr (cadddr exp)))))
	    env got-one fail))

(define (eval-make-env exp env got-one fail)
  (amb-eval (list* 'LET '() (append (cdr exp) '((the-environment))))
	    env got-one fail))

(define (eval-error exp env got-one fail)
  (error (cadr exp) (cddr exp)))


;;; Grumble... PS9-COMP uses dotted lambda lists, so we have to generalize
;;;            AMB-Scheme's MAKE-FRAME... <<Vive l'abstract syntax!!>>

(define (make-frame variables values)
  (cond ((and (null? variables) (null? values)) '())
        ((null? variables)
         (amb-error "Too many values supplied" values) 0)
	((atom? variables) ;; (lambda x x)
	 (cons (make-binding variables values) '()))
        ((null? values)
         (amb-error "Too few values supplied" variables) 0)
        (else
         (cons (make-binding (car variables)
                             (car values))
               (make-frame (cdr variables)
                           (cdr values))))))

;;; Provide CALL-WITH-CURRENT-CONTINUATION

(define (amb-apply procedure arguments got-one fail)
  (cond ((primitive-procedure? procedure)
         (got-one (apply-primitive-procedure procedure arguments)
                  fail))
        ((compound-procedure? procedure)
         (eval-sequence (procedure-body procedure)
                        (extend-environment (parameters procedure)
                                            arguments
                                            (procedure-environment procedure))
                        got-one
                        fail))
	;;------------------------New stuff here-------------------------------
	((cwcc? procedure)
	 (cond ((null? arguments)
		(mini-error "Too few args to CALL-WITH-CRYPTIC-CONBOBULATION"
			    arguments))
	       ((not (null? (cdr arguments)))
		(mini-error "Too many args to CALL-WITH-CAUSTIC-CONTAMINATION"
			    arguments))
	       (else
		(let ((call-with-nonlocal-exit call-with-current-continuation))
		  (got-one (call-with-nonlocal-exit
			    (lambda (exit)
			      (amb-apply (first arguments)
					 (list (make-primitive exit))
					 got-one
					 fail)))
			   fail)))))
	;;------------------------Old stuff below here-------------------------
        ((fail? procedure)
         (fail))
        ((next? procedure)
         (fail))
        ((done? procedure)
         (driver-loop))
        (else
         (amb-error "Unknown procedure type -- AMB-APPLY" procedure) 0)))

(define (cwcc? proc) (eq? proc *cwcc*))
(define *cwcc* (list '*call-with-wretched-abomination*)) ; Unique wrt EQ?

(set! new-constants-to-install
      (cons (make-binding 'call-with-current-continuation *cwcc*)
	    new-constants-to-install))

;;; Bring in some new primitives for AMB-Scheme

(enable-language-features)
(load "psets:ps9-magic.scm")		;; Get UNSYNTAX, STRING?, CALL-WITH-...
(disable-language-features)

(set! goosey-primitives (cons 'generate-uninterned-symbol goosey-primitives))
(set!  ducky-primitives (append '(unsyntax string? clear-graphics draw-point)
				ducky-primitives))

; Portability for various graphics-less Schemes
;----------------------------------------------
; (define (draw-point . stuff) (cons 'I-dont-know-how-to-draw stuff))

;;; Install our extensions before loading any files that may build atop them

(extend-the-amb-global-environment!)


;;; Make the elevation complete by lifting EVAL to AMB-EVAL in PS9 code.

(define (the-amb-global-environment) the-global-environment)

(define (return-got-one val fail) val)
(define (ignore-failure) 'so-sue-me)

(set! goosey-primitives (cons 'amb-eval goosey-primitives))
(set!  ducky-primitives
      (append '(the-amb-global-environment ;; These are explicitly
		return-got-one ignore-failure)      ;; EXTENDED in PS9-ENVX.AMB
	      ducky-primitives))


(define *freeze-eval?* false)		;; Don't let PS9-ECEVAL stomp EVAL

(cond ((user-load "psets:ps9-envx.amb")	;; Make calls to EVAL be to AMB-EVAL
       (set! *freeze-eval?* true)       ;; & install memoizing FORCE
       'loaded)
      (else 'load-failed--try-again-bub))

(define (define-variable! var val env)
  (if (and (eq? var 'EVAL-IN-INITIAL-ENV)
	   *freeze-eval?*)
      'I-was-contented-with-the-old-value ; PS9-ECEVAL tries to redefine it.
      (really-define-variable! var val env)))

(define (really-define-variable! var val env)	; From PS8-AMB.SCM
  (let ((b (binding-in-frame var (first-frame env))))
    (if (found-binding? b)
        (set-binding-value! b val)
        (set-first-frame! env
			  (adjoin-binding (make-binding var val)
					  (first-frame env))))))

;;; Now start loading all this REGSIM/ECEVAL/COMP/OPEN festering bilge...

(user-load "psets:ps9-syntax.scm")
(user-load "psets:ps9-regsim.scm")
(user-load "psets:ps9-eceval.scm")
(user-load "psets:ps9-comp.scm")	; Uhm... these last two compiler
(user-load "psets:ps9-open.scm")	; hacks could be loaded into the
					; normal Scheme then exported up
					; to AMBScheme via EXTEND-PRIM..S
;;; fini

'Whew!
