(define try-10
  (lambda ()

    (define message-1-lat-deg 138811)
    (define message-1-lat-ori 541278)
    (define message-1-lon-deg 604581)
    (define message-1-lon-ori 298324)

    (define message-2-lat-deg 478627)
    (define message-2-lat-ori  87832)
    (define message-2-lon-deg 393106)
    (define message-2-lon-ori 336014)

    (define forgers "Israelis")
    (define traders "Iraqis")

    (define message-valid?
      (lambda (lat-deg lat-ori lon-deg lon-ori)

	(define valid-lat-degree?
	  (lambda (degree)
	    (conjunction (not (negative? degree)) ; degrees non-neg by convention
			 (<= degree 90))))	  ; Poles are at 90 degrees

	(define valid-lon-degree?
	  (lambda (degree)
	    (conjunction (not (negative? degree)) ; degrees non-neg by convention
			 (<= degree 180))))	  ; Int'l Date Line at 180 degrees

	(define valid-lat-orientation?
	  (lambda (orient)
	    (disjunction (= orient 14)
			 (= orient 19))))
      
	(define valid-lon-orientation?
	  (lambda (orient)
	    (disjunction (= orient  5)
			 (= orient 23))))
      
	(conjunction (valid-lat-degree? lat-deg) (valid-lat-orientation? lat-ori)
		     (valid-lon-degree? lon-deg) (valid-lon-orientation? lon-ori))))
    
    (define decode-orient
      (lambda (orient-num)
	(cond ((= orient-num  5) "E")
	      ((= orient-num 14) "N")
	      ((= orient-num 19) "S")
	      ((= orient-num 23) "W")
	      (else              "?"))))
    
    (let ((Bn 146087) (Be 907)
	  (An 612569) (Ae 271))
      (let ((Bd (crack-rsa Bn Be))		; Bd not actually used... but interesting
	    (Ad (crack-rsa An Ae)))
	
	(define  weak-decrypt (lambda (message) (decrypt               message  Ad An)))
	(define ducky-decrypt (lambda (message) (decrypt (weak-decrypt message) Be Bn)))
	
	(define show-forger/trader-msgs
	  (lambda (f-lat-deg f-lat-ori f-lon-deg f-lon-ori f-num
		   t-lat-deg t-lat-ori t-lon-deg t-lon-ori t-num)
	    (newline) (newline)
	    (princ "The ")(princ forgers)(princ " have forged message")
	    (newline)
	    (princ f-num)(princ ": ")
	    (princ f-lat-deg)(princ " ")(princ (decode-orient f-lat-ori))(princ " Lat")
	    (newline)
	    (princ "   ")
	    (princ f-lon-deg)(princ " ")(princ (decode-orient f-lon-ori))(princ " Lon")
	    (newline)
	    (newline)
	    (princ "The real ")(princ traders)(princ " sent message")
	    (newline)
	    (princ t-num)(princ ": ")
	    (princ t-lat-deg)(princ " ")(princ (decode-orient t-lat-ori))(princ " Lat")
	    (newline)
	    (princ "   ")
	    (princ t-lon-deg)(princ " ")(princ (decode-orient t-lon-ori))(princ " Lon")
	    ))
	
	(define show-lossage
	  (lambda (lat-deg-1 lat-ori-1 lon-deg-1 lon-ori-1
		   lat-deg-2 lat-ori-2 lon-deg-2 lon-ori-2 winning?)
	    (newline)
	    (newline)
	    (princ "Yow! something appears to be broken...")
	    (newline)
	    (princ "...both messages appear to be ")(princ (if winning? "valid." "bogus."))
	    (newline)
	    (princ "Message 1: ")
	    (princ lat-deg-1)(princ " ")(princ (if winning?
						   (decode-orient lat-ori-1)
						   lat-ori-1)) (princ " Lat")
	    (newline)
	    (princ "           ")
	    (princ lon-deg-1)(princ " ")(princ (if winning?
						   (decode-orient lon-ori-1)
						   lon-ori-1)) (princ " Lon")
	    (newline)
	    (princ "Message 2: ")
	    (princ lat-deg-2)(princ " ")(princ (if winning?
						   (decode-orient lat-ori-2)
						   lat-ori-2)) (princ " Lat")
	    (newline)
	    (princ "           ")
	    (princ lon-deg-2)(princ " ")(princ (if winning?
						   (decode-orient lon-ori-2)
						   lon-ori-2)) (princ " Lon")
	    ))
	
	(let ((w1ad (weak-decrypt message-1-lat-deg))
	      (w1ao (weak-decrypt message-1-lat-ori))
	      (w1od (weak-decrypt message-1-lon-deg))
	      (w1oo (weak-decrypt message-1-lon-ori))
	      
	      (w2ad (weak-decrypt message-2-lat-deg))
	      (w2ao (weak-decrypt message-2-lat-ori))
	      (w2od (weak-decrypt message-2-lon-deg))
	      (w2oo (weak-decrypt message-2-lon-ori))
	      
	      (d1ad (ducky-decrypt message-1-lat-deg))
	      (d1ao (ducky-decrypt message-1-lat-ori))
	      (d1od (ducky-decrypt message-1-lon-deg))
	      (d1oo (ducky-decrypt message-1-lon-ori))
	      
	      (d2ad (ducky-decrypt message-2-lat-deg))
	      (d2ao (ducky-decrypt message-2-lat-ori))
	      (d2od (ducky-decrypt message-2-lon-deg))
	      (d2oo (ducky-decrypt message-2-lon-ori)))
	  
	  (let ((message-1-bogus? (message-valid? w1ad w1ao w1od w1oo))
		(message-2-bogus? (message-valid? w2ad w2ao w2od w2oo))
		(message-1-valid? (message-valid? d1ad d1ao d1od d1oo))
		(message-2-valid? (message-valid? d2ad d2ao d2od d2oo)))
	    
	    (newline)
	    (newline)
	    (princ "Ad = ")(princ Ad)
	    
	    (cond ((and message-1-bogus? message-2-valid?)
		   (show-forger/trader-msgs w1ad w1ao w1od w1oo 1
					    d2ad d2ao d2od d2oo 2))
		  ((and message-1-valid? message-2-bogus?)
		   (show-forger/trader-msgs w2ad w2ao w2od w2oo 2
					    d1ad d1ao d1od d1oo 1))
		  ((and message-1-valid? message-2-valid?)
		   (show-lossage d1ad d1ao d1od d1oo
				 d2ad d2ao d2od d2oo
				 true))
		  ((and message-1-bogus? message-2-bogus?)
		   (show-lossage w1ad w1ao w1od w1oo
				 w2ad w2ao w2od w2oo
				 false))
		  (else (error "ZOINKS!!! Something very fishy is going on here..."
			       message-1-bogus? message-1-valid?
			       message-2-bogus? message-2-valid?)))))))))
