;;; -*- Mode:Scheme; Base:10 -*-

;; Exercise 1
;;-----------

(define try-1
  (lambda ()
    (newline)(princ "Expmod-1 10^511  mod 7 ...")(timed-exp expmod-1 10  511 7)
    (newline)(princ "Expmod-1 10^1023 mod 7 ...")(timed-exp expmod-1 10 1023 7)
    (newline)(princ "Expmod-1 10^2047 mod 7 ...")(timed-exp expmod-1 10 2047 7)
    (newline)
    (newline)(princ "Expmod-2 10^511  mod 7 ...")(timed-exp expmod-2 10  511 7)
    (newline)(princ "Expmod-2 10^1023 mod 7 ...")(timed-exp expmod-2 10 1023 7)
    (newline)(princ "Expmod-2 10^2047 mod 7 ...")(timed-exp expmod-2 10 2047 7)
    (newline)
    (newline)(princ "Expmod-3 10^511  mod 7 ...")(timed-exp expmod-3 10  511 7)
    (newline)(princ "Expmod-3 10^1023 mod 7 ...")(timed-exp expmod-3 10 1023 7)
    (newline)(princ "Expmod-3 10^2047 mod 7 ...")(timed-exp expmod-3 10 2047 7)
    ))

;; Exercise 2
;;-----------

(define try-2
  (lambda ()
    (newline) (select-keys)
    (newline) (select-keys)
    (newline) (select-keys)
    (newline) (select-keys)
    ))

;; Exercise 3
;;-----------

(define crack-rsa
  (lambda (n e)
    (let ((start-time (runtime)))
      (let ((p (prime-component n)))
	(if (= p 1)
	    (sequence (print "Sorry - cannot find prime component") 1)
	    (let ((q (/ n p)))
	      (let ((m (* (-1+ p)(-1+ q))))
		(define iter
		  (lambda (r-guess)
		    (let ((numerator (- 1 (* m r-guess))))
		      ;; Avoid full blown division; remainder is faster
		      (if (zero? (remainder numerator e))
			  (sequence
			    (newline)
			    (princ "Elapsed time is... ")
			    (princ (- (runtime) start-time))
			    (/ numerator e))
			  ;; Try each successive negative integer in turn
			  (iter (-1+ r-guess))))))
		;; r must be a negative integer so start at -1
		(iter -1))))))))

(define prime-component
  (lambda (n)
    (define iter
      (lambda (p-guess)
	;; remainder is faster than fast-prime so try it first
	(if (conjunction (zero? (remainder n p-guess))
			 (fast-prime? p-guess 2))
	    p-guess
	    (iter (improve p-guess)))))
    ;; (sqrt n) is a good first guess... it is the maximum feasible guess
    ;; because one of the primes composing n must surely be less than it.
    (iter (floor (sqrt n)))))


;; Exercise 4
;;-----------

(define loudly-crack-rsa
  (lambda (n e)
    (let ((random-number (random 42)))  ;; Very random
      (let ((encrypted-rn     (encrypt random-number e n)))
	(let ((d (crack-rsa n e)))
	  (let ((decrypted-rn (decrypt encrypted-rn  d n)))
	    (let ((result (if (= decrypted-rn random-number)
			      "cracked."
			      "CROAKED!!")))
	      (newline)
	      (princ "Crack-RSA of")
	      (princ " n=")(princ n)
	      (princ " e=")(princ e)
	      (princ " d=")(princ d)
	      (princ "...")(princ result)
	      (newline)
	      )))))))

(define try-4
  (lambda ()
    (loudly-crack-rsa  35369 697)
    (loudly-crack-rsa  31789 859)
    (loudly-crack-rsa  43931  17)
    (loudly-crack-rsa 146087 907)
    ))
	      
;; ==> (try-4)
;;Elapsed time is... 1.29
;;Crack-RSA of n=35369 e=697 d=15241...cracked.
;; 
;;Elapsed time is... 2.85
;;Crack-RSA of n=31789 e=859 d=26547...cracked.
;;
;;Elapsed time is... .21
;;Crack-RSA of n=43931 e=17 d=38393...cracked.
;;
;;Elapsed time is... .85
;;Crack-RSA of n=146087 e=907 d=31243...cracked.

;; Exercise 5
;;-----------

(define improve-odd-only
  (lambda (guess)
    (if (even? guess)
	(-1+ guess)
	(-   guess 2))))

(define weak-improve improve)			; Keep a handle on old&moldy

;;(define improve improve-odd-only)		; Install better version
;;(define improve weak-improve)			; Destall better version

;;(try-4)  ; time2

;; Exercise 6
;;-----------

(define tough-select-prime
  (lambda ()
    (let ((n (random 40)))			; Upper bound = 40
      (if (<= n 10)				; Lower bound = 10
	  (tough-select-prime)
	  (let ((p (+ (square n) n 41)))
	    (if (fast-prime? p 2)
		p
		(tough-select-prime)))))))

(define weak-select-prime select-prime)		; Keep a handle on old&moldy

;;(define select-prime tough-select-prime)	; Install better version
;;(define select-prime  weak-select-prime)	; Destall better version

;;(try-2)	; Generate some new tough select-keys so we can crack 'em
;;
;;Please wait for your daily lottery numbers........
;;Your first  public key is.....1682861
;;Your second public key is.....233
;;Elapsed time is................91
;;
;;Please wait for your daily lottery numbers........
;;Your first  public key is.....447631
;;Your second public key is.....733
;;Elapsed time is................76
;;
;;Please wait for your daily lottery numbers........
;;Your first  public key is.....1189543
;;Your second public key is.....757
;;Elapsed time is................67
;;
;;Please wait for your daily lottery numbers........
;;Your first  public key is.....227119
;;Your second public key is.....527
;;Elapsed time is................84

(define try-6	; Some cracking, encrypt & decrypt w/ new large keys
  (lambda ()
    (loudly-crack-rsa 1682861 233) ; Keys here generated via tough-select-prime
    (loudly-crack-rsa  447631 733)
    (loudly-crack-rsa 1189543 757)
    (loudly-crack-rsa  227119 527)
    ))


(define tough-improve
  (lambda (guess)
    (define iter
      (lambda (n)
	(if (<= n 1)	;; Fell below old lower bound?
	    1	        ;; Give up: make prime-component admit defeat
	    (let ((new-guess (+ (square n) n 41)))
	      (if (< new-guess guess)
		  new-guess
		  (iter (-1+ n)))))))
    ;; Start at first integer below the upper bound
    (iter (-1+ 40))))

(define tougher-improve
  (lambda (guess)
    (define iter
      (lambda (n)
	(if (<= n 1)	;; Fell below old lower bound?
	    1	        ;; Give up: make prime-component admit defeat
	    (let ((new-guess (+ (square n) n 41)))
	      (if (< new-guess guess)
		  new-guess
		  (iter (-1+ n)))))))
    ;; Start at first integer below the upper bound
    (iter (min (-1+ 40) (floor (sqrt (- guess 41)))))))
  
;;(define improve tough-improve)			; Install better version
;;(define improve tougher-improve)
;;(define improve  weak-improve)			; Destall better version

;;(try-6) ; w/ toughened IMPROVE
;;(try-4) ; time3

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; TODO: Discuss how incorporating IMPROVE into CRACK-RSA would allow knowing
;;;       what the last n was so we needn't bother rediscovering it.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


;; Exercise 7
;;-----------

;; Version w/o internal iterater wastes some time passing non-state variables
;;
;;(define general-search
;;  (lambda (guess success-test next-guess returner)
;;    (if (success-test guess)
;;        (returner guess)
;;        (general-search (next-guess guess) success-test next-guess returner))))

(define general-search
  (lambda (guess success-test next-guess returner)
    (define iter
      (lambda (current-guess)
	(if (success-test current-guess)
	    (returner current-guess)
	    (iter (next-guess current-guess)))))
    (iter guess)))


(define searching-prime-component
  (lambda (n)
    (let ((initial-guess (floor (sqrt n)))
	  (success-test  (lambda (p-guess)
			   (conjunction (zero? (remainder n p-guess))
					(fast-prime? p-guess 2))))
	  (next-guess    tough-improve)
	  (returner      identity))
      (general-search initial-guess success-test next-guess returner))))
		  
(define old-prime-component prime-component)	; Keep a handle on old&moldy

;;(define prime-component searching-prime-component)	; Install searching version
;;(define prime-component       old-prime-component)	; Destall searching version

;;(try-4)  ; Verify that it all still works...
;;(try-6)

(define crack-rsa-search			; The search extracted
  (lambda (e m start-time)
    (define numerator (lambda (r-guess) (- 1 (* m r-guess))))
    (let ((initial-guess -1)
	  (success-test  (lambda (r-guess)
			   (zero? (remainder (numerator r-guess) e))))
	  (next-guess    -1+)
	  (returner      (lambda (r-guess)
			   (newline)
			   (princ "Elapsed time is... ")
			   (princ (- (runtime) start-time))
			   (/ (numerator r-guess) e))))
      (general-search initial-guess success-test next-guess returner))))

(define searching-crack-rsa			; crack-rsa via search
  (lambda (n e)
    (let ((start-time (runtime)))
      (let ((p (prime-component n)))
	(if (= p 1)
	    (sequence (print "Sorry - cannot find prime component") 1)
	    (let ((q (/ n p)))
	      (let ((m (* (-1+ p)(-1+ q))))
		(crack-rsa-search e m start-time))))))))

(define old-crack-rsa crack-rsa)		; Keep a handle on old&moldy

;;(define crack-rsa searching-crack-rsa)		; Install searching version
;;(define crack-rsa       old-crack-rsa)		; Destall searching version

;; (try-4)  ; Make sure everything still works...
;; (try-6)

;; Exercise 8
;;-----------

(define make-encrypter
  (lambda (e n)
    (lambda (message)
      (encrypt message e n))))

(define try-8
  (lambda ()

    (define encrypt-yousame (make-encrypter                   907  146087))
    (define decrypt-yousame (make-encrypter (crack-rsa 146087 907) 146087))
  
    (define encrypt-cia     (make-encrypter                   271  612569))
    (define decrypt-cia     (make-encrypter (crack-rsa 612569 271) 612569))

    (define iter
      (lambda (count)
	(cond ((zero? count) (newline)(princ "You win!") true)
	      ((not (let ((r (random 42)))
		      (conjunction (= (encrypt-yousame (decrypt-yousame r))
				      (decrypt-yousame (encrypt-yousame r))
				      r)
				   (= (encrypt-cia     (decrypt-cia r))
				      (decrypt-cia     (encrypt-cia r))
				      r))))
	       (newline)(princ "You lose."))
	      (else (iter (-1+ count))))))
    (iter 37)))
			 
;; Exercise 9
;;-----------

(define try-9
  (lambda ()
    (let ((n 146087)
	  (e    907))
      (let ((d (crack-rsa n e)))
	(newline)
	(newline)
	(princ "Yousame's d = ")(princ d)
	(newline)
	(princ "Date is ")(princ (decrypt  90507 d n))
	(princ        "-")(princ (decrypt 117680 d n))
	(princ        "-")(princ (decrypt 131064 d n))))))

;; Exercise 10
;;------------

(define try-10
  (lambda ()

    (define message-1-lat-deg 138811)
    (define message-1-lat-ori 541278)
    (define message-1-lon-deg 604581)
    (define message-1-lon-ori 298324)

    (define message-2-lat-deg 478627)
    (define message-2-lat-ori  87832)
    (define message-2-lon-deg 393106)
    (define message-2-lon-ori 336014)

    (define forgers "Israelis")
    (define traders "Iraqis")

    (define message-valid?
      (lambda (lat-deg lat-ori lon-deg lon-ori)

	(define valid-lat-degree?
	  (lambda (degree)
	    (conjunction (not (negative? degree)) ; degrees non-neg by convention
			 (<= degree 90))))	  ; Poles are at 90 degrees

	(define valid-lon-degree?
	  (lambda (degree)
	    (conjunction (not (negative? degree)) ; degrees non-neg by convention
			 (<= degree 180))))	  ; Int'l Date Line at 180 degrees

	(define valid-lat-orientation?
	  (lambda (orient)
	    (disjunction (= orient 14)
			 (= orient 19))))
      
	(define valid-lon-orientation?
	  (lambda (orient)
	    (disjunction (= orient  5)
			 (= orient 23))))
      
	(conjunction (valid-lat-degree? lat-deg) (valid-lat-orientation? lat-ori)
		     (valid-lon-degree? lon-deg) (valid-lon-orientation? lon-ori))))
    
    (define decode-orient
      (lambda (orient-num)
	(cond ((= orient-num  5) "E")
	      ((= orient-num 14) "N")
	      ((= orient-num 19) "S")
	      ((= orient-num 23) "W")
	      (else              "?"))))
    
    (let ((Bn 146087) (Be 907)
	  (An 612569) (Ae 271))
      (let ((Bd (crack-rsa Bn Be))		; Bd not actually used... but interesting
	    (Ad (crack-rsa An Ae)))
	
	(define  weak-decrypt (lambda (message) (decrypt               message  Ad An)))
	(define ducky-decrypt (lambda (message) (decrypt (weak-decrypt message) Be Bn)))
	
	(define show-forger/trader-msgs
	  (lambda (f-lat-deg f-lat-ori f-lon-deg f-lon-ori f-num
		   t-lat-deg t-lat-ori t-lon-deg t-lon-ori t-num)
	    (newline) (newline)
	    (princ "The ")(princ forgers)(princ " have forged message")
	    (newline)
	    (princ f-num)(princ ": ")
	    (princ f-lat-deg)(princ " ")(princ (decode-orient f-lat-ori))(princ " Lat")
	    (newline)
	    (princ "   ")
	    (princ f-lon-deg)(princ " ")(princ (decode-orient f-lon-ori))(princ " Lon")
	    (newline)
	    (newline)
	    (princ "The real ")(princ traders)(princ " sent message")
	    (newline)
	    (princ t-num)(princ ": ")
	    (princ t-lat-deg)(princ " ")(princ (decode-orient t-lat-ori))(princ " Lat")
	    (newline)
	    (princ "   ")
	    (princ t-lon-deg)(princ " ")(princ (decode-orient t-lon-ori))(princ " Lon")
	    ))
	
	(define show-lossage
	  (lambda (lat-deg-1 lat-ori-1 lon-deg-1 lon-ori-1
		   lat-deg-2 lat-ori-2 lon-deg-2 lon-ori-2 winning?)
	    (newline)
	    (newline)
	    (princ "Yow! something appears to be broken...")
	    (newline)
	    (princ "...both messages appear to be ")(princ (if winning? "valid." "bogus."))
	    (newline)
	    (princ "Message 1: ")
	    (princ lat-deg-1)(princ " ")(princ (if winning?
						   (decode-orient lat-ori-1)
						   lat-ori-1)) (princ " Lat")
	    (newline)
	    (princ "           ")
	    (princ lon-deg-1)(princ " ")(princ (if winning?
						   (decode-orient lon-ori-1)
						   lon-ori-1)) (princ " Lon")
	    (newline)
	    (princ "Message 2: ")
	    (princ lat-deg-2)(princ " ")(princ (if winning?
						   (decode-orient lat-ori-2)
						   lat-ori-2)) (princ " Lat")
	    (newline)
	    (princ "           ")
	    (princ lon-deg-2)(princ " ")(princ (if winning?
						   (decode-orient lon-ori-2)
						   lon-ori-2)) (princ " Lon")
	    ))
	
	(let ((w1ad (weak-decrypt message-1-lat-deg))
	      (w1ao (weak-decrypt message-1-lat-ori))
	      (w1od (weak-decrypt message-1-lon-deg))
	      (w1oo (weak-decrypt message-1-lon-ori))
	      
	      (w2ad (weak-decrypt message-2-lat-deg))
	      (w2ao (weak-decrypt message-2-lat-ori))
	      (w2od (weak-decrypt message-2-lon-deg))
	      (w2oo (weak-decrypt message-2-lon-ori))
	      
	      (d1ad (ducky-decrypt message-1-lat-deg))
	      (d1ao (ducky-decrypt message-1-lat-ori))
	      (d1od (ducky-decrypt message-1-lon-deg))
	      (d1oo (ducky-decrypt message-1-lon-ori))
	      
	      (d2ad (ducky-decrypt message-2-lat-deg))
	      (d2ao (ducky-decrypt message-2-lat-ori))
	      (d2od (ducky-decrypt message-2-lon-deg))
	      (d2oo (ducky-decrypt message-2-lon-ori)))
	  
	  (let ((message-1-bogus? (message-valid? w1ad w1ao w1od w1oo))
		(message-2-bogus? (message-valid? w2ad w2ao w2od w2oo))
		(message-1-valid? (message-valid? d1ad d1ao d1od d1oo))
		(message-2-valid? (message-valid? d2ad d2ao d2od d2oo)))
	    
	    (newline)
	    (newline)
	    (princ "Ad = ")(princ Ad)
	    
	    (cond ((and message-1-bogus? message-2-valid?)
		   (show-forger/trader-msgs w1ad w1ao w1od w1oo 1
					    d2ad d2ao d2od d2oo 2))
		  ((and message-1-valid? message-2-bogus?)
		   (show-forger/trader-msgs w2ad w2ao w2od w2oo 2
					    d1ad d1ao d1od d1oo 1))
		  ((and message-1-valid? message-2-valid?)
		   (show-lossage d1ad d1ao d1od d1oo
				 d2ad d2ao d2od d2oo
				 true))
		  ((and message-1-bogus? message-2-bogus?)
		   (show-lossage w1ad w1ao w1od w1oo
				 w2ad w2ao w2od w2oo
				 false))
		  (else (error "ZOINKS!!! Something very fishy is going on here..."
			       message-1-bogus? message-1-valid?
			       message-2-bogus? message-2-valid?)))))))))
