;;; -*- Mode:Scheme; Base:10 -*-

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;                          						     ;;
;; Fall Semester, 1991       Problem Set 1 Solutions       Ziggy@LCS.MIT.EDU ;;
;;                          						     ;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;; Given...

(define lissajous
  (lambda (a-x a-y f-x f-y phi dt)
    ;;clear the screen and set graphics at initial point
    (clear-graphics)
    (position-pen (sinusoid 0 a-x f-x 0)
                  (sinusoid 0 a-y f-y phi))
    (lissajous-loop 0 a-x a-y f-x f-y phi dt))) ;start drawing

(define sinusoid
  (lambda (t a f phi)
    (* a (sin (+ (* f t) phi)))))

;; Redefined below to have a termination condition
;;
;;(define lissajous-loop
;;  (lambda (t a-x a-y f-x f-y phi dt)
;;    (draw-line-to (sinusoid t a-x f-x 0)
;;                  (sinusoid t a-y f-y phi))
;;    (lissajous-loop (+ t dt) a-x a-y f-x f-y phi dt)))


;; Exercise 3.1
;;-------------

(define (ampl-mult m)
  (lissajous 50 (* m 50) 1 1 pi/2 0.05))

(define pi (* 4 (atan 1 1)))

(define pi/2 (/ pi 2))

;; Explore the family of figures generated by {\tt ampl-mult} as {\tt m}
;; varies smoothly from $-2$ to 2.  By modifying {\tt ampl-mult}, perform
;; the same analysis for figures with $f_x=1$ and $f_y=3$.  Turn in
;; sketches of some of the figures you find.

(define accum-lissajous
  (lambda (a-x a-y f-x f-y phi dt)
    ;; DONT clear the screen and set graphics at initial point
;   (clear-graphics)
    (position-pen (sinusoid 0 a-x f-x 0)
                  (sinusoid 0 a-y f-y phi))
    (lissajous-loop 0 a-x a-y f-x f-y phi dt))) ;start drawing

(define (accum-ampl-mult m)
  (accum-lissajous 50 (* m 50) 1 1 pi/2 0.05))

(define (try-3.1)
  (      ampl-mult -2  )
  (accum-ampl-mult -1.5)
  (accum-ampl-mult -1  )
  (accum-ampl-mult -0.5)
  (accum-ampl-mult  0  )
  (accum-ampl-mult  0.5)
  (accum-ampl-mult  1  )
  (accum-ampl-mult  1.5)
  (accum-ampl-mult  2  )
  )

(define (try-3.1b)

  (define (ampl-mult-b m)
    (lissajous 50 (* m 50) 1 3 pi/2 0.05))	; NB: f_x=1;f_y=3

  (define (accum-ampl-mult-b m)
    (accum-lissajous 50 (* m 50) 1 3 pi/2 0.05))

  (      ampl-mult-b -2  )
  (accum-ampl-mult-b -1.5)
  (accum-ampl-mult-b -1  )
  (accum-ampl-mult-b  0.5)
  (accum-ampl-mult-b  0  )
  (accum-ampl-mult-b  0.5)
  (accum-ampl-mult-b  1  )
  (accum-ampl-mult-b  1.5)
  (accum-ampl-mult-b  2  )
  )

;; Exercise 3.2
;;-------------

(define (phase-shift f-x f-y phi)
  (lissajous 150 150 f-x f-y phi 0.05))

;; Using this procedure, explore the family of figures generated
;; for $f_x=1$ and $f_y=2$. What does the resulting figure look like for
;; $\phi=0$? For $\phi=\pi/2$? For $\phi=\pi$? For intermediate values of
;; $\phi$?

(define (accum-phase-shift f-x f-y phi)
  (accum-lissajous 150 150 f-x f-y phi 0.05))


(define  pi/4 (/      pi  4))			; A couple more useful constants
(define 3pi/4 (/ (* 3 pi) 4))

(define (try-3.2)
  (      phase-shift 1 2  0   )
  (accum-phase-shift 1 2  pi/2)
  (accum-phase-shift 1 2  pi  )
  (accum-phase-shift 1 2  pi/4)
  (accum-phase-shift 1 2 3pi/4)
  )


;; Exercise 3.3
;;-------------

;; Examine the Lissajous figures formed by signals with different
;; frequencies: $f_x=2$ and $f_y=3$; $f_x=5$ and $f_y=6$; $f_x=3$ and
;; $f_y=5$. For some of these you may want to decrease the value of {\tt
;; dt} to obtain a more accurate plot.  Experiment with the figures,
;; noting how they change as the phase shift varies from 0 to $\pi$.
;; Turn in sketches of some of the interesting figures that you find.

(define (try-3.3a)
  (phase-shift 2 3  0   )
  (phase-shift 2 3  pi/4)
  (phase-shift 2 3  pi/2)
  (phase-shift 2 3 3pi/4)
  (phase-shift 2 3  pi  )
  )

(define (try-3.3b)
  (phase-shift 5 6  0   )
  (phase-shift 5 6  pi/4)
  (phase-shift 5 6  pi/2)
  (phase-shift 5 6 3pi/4)
  (phase-shift 5 6  pi  )
  )

(define (try-3.3c)
  (phase-shift 3 5  0   )
  (phase-shift 3 5  pi/4)
  (phase-shift 3 5  pi/2)
  (phase-shift 3 5 3pi/4)
  (phase-shift 3 5  pi  )
  )

;; Exercise 3.4
;;-------------

(define 2pi (* 2 pi))    ;; To avoid recomputing 2 pi

(define lissajous-loop
  (lambda (t a-x a-y f-x f-y phi dt)
    (draw-line-to (sinusoid t a-x f-x 0)
		  (sinusoid t a-y f-y phi))
    (if (>= t 2pi)
	42
	(lissajous-loop (+ t dt) a-x a-y f-x f-y phi dt))))

;; Exercise 3.5
;;-------------

;; Using your modified procedure of exercise 3.4, draw a Lissajous figure
;; with $f_x=6$ and $f_y=8$.  How many times is the figure traced before
;; the program stops?  Describe how to modify your program so that it
;; will stop after drawing the figure once.  You need consider only the
;; case where the frequencies are integers.  Explain the idea behind your
;; stop rule.  (Hint: You may want to make use of the Scheme primitive
;; {\tt gcd}, which computes the greatest common divisor of two integers.
;; See section 1.2.5 of the course text.)

(define (try-3.5)
  (phase-shift 6 8 0))


(define uno-lissajous
  (lambda (a-x a-y f-x f-y phi dt)
    ;;clear the screen and set graphics at initial point
    (clear-graphics)
    (position-pen (sinusoid 0 a-x f-x 0)
                  (sinusoid 0 a-y f-y phi))
    (uno-lissajous-loop 0 a-x a-y f-x f-y phi dt))) ;start drawing

(define uno-lissajous-loop
  (lambda (t a-x a-y f-x f-y phi dt)
    (draw-line-to (sinusoid t a-x f-x 0)
		  (sinusoid t a-y f-y phi))
    (if (>= t (/ 2pi (gcd f-x f-y)))
	42
	(uno-lissajous-loop (+ t dt) a-x a-y f-x f-y phi dt))))

(define (uno-phase-shift f-x f-y phi)
  (uno-lissajous 150 150 f-x f-y phi 0.05))


(define (try-3.5b)
  (uno-phase-shift 6 8 0))

;; Exercise 3.6
;;-------------

;; Some Lissajous figures contain places where the curve ``stops'' and
;; the graph backs up and retraces itself.  An example is $f_x=3$,
;; $f_y=5$, $\phi=0$.  
;;
;; (a) Why does this happen?  Give some more examples of
;; triples $f_x$, $f_y$, and $\phi$ that exhibit this behavior.  
;;
;; (b) Give a
;; rule (in terms of $f_x$, $f_y$, and $\phi$) that predicts which
;; figures will contain such ``stop points.''  Be sure to test your rule
;; by trying various figures.

(define (try-3.6)
  (uno-phase-shift 3 5 0    )
  (uno-phase-shift 2 3 3pi/4)
  (uno-phase-shift 2 3  pi/4)
  (uno-phase-shift 1 1 0    )
  (uno-phase-shift 2 1  pi/4)
  )

;; Exercise 3.7
;;-------------

(define lissajous-3.7
  (lambda (a-x a-y f-x f-y phi dt)

    (define sinusoid
      (lambda (t a f phi)
        (* a (sin (+ (* f t) phi)))))

    ;; We use our ducky new lissajous loop from Exercise 3.4
    (define lissajous-loop
      (lambda (t)
	(draw-line-to (sinusoid t a-x f-x 0)
		      (sinusoid t a-y f-y phi))
        (if (>= t 2pi)
	    42
	    (lissajous-loop (+ t dt)))))

    ;;clear the screen and set graphics at initial point
    (clear-graphics)
    (position-pen (sinusoid 0 a-x f-x 0)
                  (sinusoid 0 a-y f-y phi))
    (lissajous-loop 0))) ;start drawing


(define (phase-shift-3.7 f-x f-y phi)
  (lissajous-3.7 150 150 f-x f-y phi 0.05))

(define (try-3.7)
  (phase-shift-3.7 5 6  0   )
  (phase-shift-3.7 5 6  pi/4)
  (phase-shift-3.7 5 6  pi/2)
  (phase-shift-3.7 5 6 3pi/4)
  (phase-shift-3.7 5 6  pi  )
  )

;; Exercise 3.8
;;-------------

(define (lissajous-3.8 a-x a-y f-x f-y phi dt)

    (define (sinusoid t a f phi)
      (* a (sin (+ (* f t) phi))))

    ;; We use our ducky new lissajous loop from Exercise 3.4
    (define (lissajous-loop t)
      (draw-line-to (sinusoid t a-x f-x 0)
		    (sinusoid t a-y f-y phi))
      (if (>= t 2pi)
	  42
	  (lissajous-loop (+ t dt))))

    ;;clear the screen and set graphics at initial point
    (clear-graphics)
    (position-pen (sinusoid 0 a-x f-x 0)
                  (sinusoid 0 a-y f-y phi))
    (lissajous-loop 0)) ;start drawing


(define (phase-shift-3.8 f-x f-y phi)
  (lissajous-3.8 150 150 f-x f-y phi 0.05))

(define (try-3.8)
  (phase-shift-3.8 3 5  0   )
  (phase-shift-3.8 3 5  pi/4)
  (phase-shift-3.8 3 5  pi/2)
  (phase-shift-3.8 3 5 3pi/4)
  (phase-shift-3.8 3 5  pi  )
  )