;;; This is the modifications file for problem set 8.  It contains the
;;; procedures from the evaluator that you will need to modify in order
;;; to do the assignment.  Of course, you will also have to write
;;; additional procedures from scratch.

;;; WARNING:  Depending on how you do the problem set, there may be
;;; other procedures from the evaluator that you may want to modify.
;;; You may want to ask a TA about how to move blocks of code between
;;; editor buffers.

(DEFINE (MAKE-THUNK EXP ENV) (LIST 'THUNK EXP ENV))
(DEFINE (THUNK? OBJ) (IF (PAIR? OBJ) (EQ? (CAR OBJ) 'THUNK) FALSE))
(DEFINE (THUNK-EXP THUNK) (CADR THUNK))
(DEFINE (THUNK-ENV THUNK) (CADDR THUNK))
(DEFINE (UNDELAY OBJ)
  (IF (THUNK? OBJ) ;; To undelay a thunk, evaluate its expression in its environment.
      (UNDELAY     ;; The result of that evaluation could also be a thunk, so undelay
        (MINI-EVAL (THUNK-EXP OBJ) (THUNK-ENV OBJ)))   ;; the result too.
      OBJ))        ;; Any non-thunk object is already undelayed, so just return it.

(define (user-print object)
  (cond
   ((compound-procedure? object)
    (print (list 'compound-procedure
                 (procedure-text object))))
   ((THUNK? OBJECT) (USER-PRINT (UNDELAY OBJECT)))
   (else (print object))))


(define (mini-eval exp env)
  (cond ((self-evaluating? exp) exp)
        ((quoted? exp) (text-of-quotation exp))
        ((variable? exp) (lookup-variable-value exp env))
        ((definition? exp) (eval-definition exp env))
        ((assignment? exp) (eval-assignment exp env))
        ((lambda? exp) (make-procedure exp env))
        ((conditional? exp) (eval-cond (clauses exp) env))
        ((application? exp)  ; To get the proc to apply, we must force evaluation of
         (mini-apply (UNDELAY (mini-eval (operator exp) env))  ; the operator expr.
                (OPERANDS EXP) ENV))  ; pass in the unevaled operands and the ENV.
        (else (error "Unknown expression type -- EVAL"))))


(define (mini-apply procedure OP-EXPRESSIONS ENVIRONMENT)
  (cond ((primitive-procedure? procedure)     ; For primitives, evaluate the operand
         (apply-primitive-procedure procedure ; expressions as before.
                                    (LIST-OF-VALUES OP-EXPRESSIONS ENVIRONMENT)))
        ((compound-procedure? procedure)
         (eval-sequence (procedure-body procedure)
                        (extend-environment
                          ;; Extract the possibly delayed symbols from the param list.
                         (PARAMETER-SYMBOLS (parameters procedure))
                          ;; For compound procedures, pass either the values of operand
                          ;; expressions, or thunks, as determined by the param list.
                         (LIST-OF-VALUES-OR-THUNKS
                           OP-EXPRESSIONS (PARAMETERS PROCEDURE) ENVIRONMENT)
                         (procedure-environment procedure))))
        (else (error "Unknown procedure type -- APPLY"))))


(DEFINE FIRST-PARAMETER CAR) ;; Maintain good abstraction hygiene.
(DEFINE REST-PARAMETERS CDR)
(DEFINE EMPTY-PARAMS? NULL?)
(DEFINE (DELAYED? PARAM) (IF (PAIR? PARAM) (EQ? (CAR PARAM) 'DELAYED) FALSE))
(DEFINE (DELAYED-VARIABLE DELAYED-PARAM)  (CADR DELAYED-PARAM))
(DEFINE (PARAMETER-SYMBOLS PARAMS)
  (IF (EMPTY-PARAMS? PARAMS)
      PARAMS
      (CONS (LET ((PARAM (FIRST-PARAMETER PARAMS)))
              (IF (DELAYED? PARAM)
                  (DELAYED-VARIABLE PARAM)
                  PARAM))
            (PARAMETER-SYMBOLS (REST-PARAMETERS PARAMS)))))

(DEFINE (LIST-OF-VALUES-OR-THUNKS OP-EXPS PARAMS ENV)
   (IF (NO-OPERANDS? OP-EXPS)
       '()
       (CONS (IF (DELAYED? (FIRST-PARAMETER PARAMS))
                 (MAKE-THUNK (FIRST-OPERAND OP-EXPS) ENV)
                 (MINI-EVAL (FIRST-OPERAND OP-EXPS) ENV))
             (LIST-OF-VALUES-OR-THUNKS
                (REST-OPERANDS OP-EXPS) (REST-PARAMETERS PARAMS) ENV))))


(define (apply-primitive-procedure p args)  ; Force evaluation of the arguments before
  (apply p (MAPCAR UNDELAY args)))          ; applying the primitive procedure.

(define (true? x) (not (null? (UNDELAY x))))  ; EVAL-COND calls TRUE?, which needs 
                                              ; to force evaluation of predicates.

