;;; This is file PS8-ANSWER.SCM

;;; This is the modifications file for problem set 8.  It contains the
;;; procedures from the evaluator that you will need to modify in order
;;; to do the assignment.  Of course, you will also have to write additional
;;; procedures from scratch.

;;; WARNING: Depending on how you do the problem set, there may be other
;;; procedures from the evaluator that you may want to modify.  You may want
;;; to ask a Lab Assistant about how to move blocks of code between editor
;;; buffers (or consult your "Don't Panic" manual, sections 2.10 and 2.11).

(define (user-print object)
  (cond ((compound-procedure? object)
	 (print (list 'compound-procedure
		      (procedure-text object)
		      '<env>)))
	(else (print object))))


(define (mini-eval exp env)
  (cond ((self-evaluating? exp) exp)
        ((quoted?          exp) (text-of-quotation     exp     ))
        ((variable?        exp) (lookup-variable-value exp  env))
        ((definition?      exp) (eval-definition       exp  env))
        ((assignment?      exp) (eval-assignment       exp  env))
        ((lambda?          exp) (make-procedure        exp  env))
        ((conditional?     exp) (eval-cond    (clauses exp) env))
        ((application?     exp) ;; NB: This must be last form tested
         (mini-apply (mini-eval      (operator exp) env)
		     (list-of-values (operands exp) env)))
        (else (error "Unknown expression type --MINI-EVAL"))))


(define (mini-apply procedure arguments)
  (cond ((primitive-procedure? procedure)
         (apply-primitive-procedure procedure arguments))
        ((compound-procedure? procedure)
         (eval-sequence (procedure-body procedure)
                        (extend-environment
			  (parameters procedure)
			  arguments
			  (procedure-environment procedure))))
        (else (error "Unknown procedure type -- MINI-APPLY"))))


(define (apply-primitive-procedure p args)
  (apply p args))
