;; This is the file PS7-CODE.SCM: code for problem set 7, Fall Term 1990

;; The following are some useful stream procedures

(define (interleave s1 s2)
  (if (empty-stream? s1)
      s2
      (cons-stream (head s1)
                   (interleave s2 (tail s1)))))

(define (print-stream s n)
  (cond ((empty-stream? s) s)
	((= n 0) s)
        (else (print (head s))
              (print-stream (tail s) (- n 1)))))

(define (map proc stream)
  (if (empty-stream? stream)
      the-empty-stream
      (cons-stream (proc (head stream))
                   (map proc (tail stream)))))

(define (filter pred stream)
  (cond ((empty-stream? stream) the-empty-stream)
        ((pred (head stream))
         (cons-stream (head stream) (filter pred (tail stream))))
        (else (filter pred (tail stream)))))

(define (for-each proc stream)
  (cond ((empty-stream? stream)
	 'done)
	(else (proc (head stream))
	      (for-each proc (tail stream)))))

(define (accumulate combiner initial-value stream)
  (if (empty-stream? stream)
      initial-value
      (combiner (head stream)
                (accumulate combiner initial-value (tail stream)))))


;; The following procedure is to be used in problem 7.2
;;
;; You must define MERGE-WEIGHTED

(define (weighted-pairs s t pair-weight)
  (cons-stream (list (head s) (head t))
               (merge-weighted
		 (map (lambda (z) (list (head s) z))
		      (tail t))
		 (weighted-pairs (tail s)
				 (tail t)
				 pair-weight)
		 (lambda (p)
                   (pair-weight (car p) (cadr p))))))

;; The following procedure is to be used in problem 7.5
;;
;; You must define COMBINE-SAME-WEIGHTS (in problem 7.4)

(define (same-weight-pairs s t pair-weight)
  (combine-same-weights (weighted-pairs s t pair-weight)
                        pair-weight))



;; The following utilities are of use in problem 7.12
  
(define (insert-sort el lst)
  (cond ((null? lst) (list el))
	((< el (car lst)) (cons el lst))
	(else (cons (car lst) (insert-sort el (cdr lst))))))

(define (sort-min lst)
  (cond ((null? lst) '())
	((null? (cdr lst)) lst)
	(else (insert-sort (car lst) (sort-min (cdr lst))))))

(define (general-member? el lst)
  (not (null? (member el lst))))		; MEMBER uses EQUAL?

(define (list-equal? a b) (equal? a b))		; EQUAL? uses = on numbers

;; Aliases for those who have an aversion to shifty characters (like `?')

(define general-member
        general-member?)

(define list-equal
	list-equal?)

;; For some awful reason, the Chipmunks think INTEGERS starts at 0 whereas the
;; textbook says they start at 1.  Let's make the Chipmunks agree with the
;; textbook...

(define (integers-starting-from n)
  (cons-stream n (integers-starting-from (1+ n))))

(define integers (integers-starting-from 1))

;; ...  of course, (integers-starting-from 0) is really the whole numbers
;; [non-negatives] and (integers-starting-from 1) is the natural numbers
;; [positives].  Can you think of a way to define the integers to be the
;; stream of both positive *and* negative integers?
