;;; Simple object system with inheritance

(define (ask object message . args)
  (let ((method (get-method object message)))
    (if (method? method)
        (apply method (cons object args))
        (error "No method" message (cadr method)))))

(define (get-method object message)
  (object message))

(define (no-method name)
  (list 'no-method name))

(define (no-method? x)
  (if (pair? x)
      (eq? (car x) 'no-method)
      false))

(define (method? x)
  (not (no-method? x)))


(define (make-speaker)
  (lambda (message)
    (cond ((eq? message 'say)
           (lambda (self stuff) stuff))
          (else (no-method "SPEAKER")))))

(define (make-shouter)
  (let ((speaker (make-speaker)))
    (lambda (message)
      (cond ((eq? message 'shout)
             (lambda (self) '(hey)))
            (else (get-method speaker message))))))

(define (make-lecturer)
  (let ((speaker (make-speaker)))
    (lambda (message)
      (cond ((eq? message 'lecture)
             (lambda (self stuff)
               (list (ask self 'say stuff)
                     (ask self 'say '(you should be taking notes)))))
            (else (get-method speaker message))))))

(define (make-arrogant-lecturer)
  (let ((lecturer (make-lecturer)))
    (lambda (message)
      (cond ((eq? message 'say)
             (lambda (self stuff)
               (ask lecturer 'say
                    (append '(it is obvious that) stuff))))
            (else (get-method lecturer message))))))


(define (make-singer)
  (lambda (message)
    (cond ((eq? message 'sing)
           (lambda (self) '(tra-la-la)))
          ((eq? message 'say)
           (lambda (self stuff)
              (append '(tra-la-la --) stuff)))
          (else (no-method "SINGER")))))

(define ben
  (let ((singer (make-singer))
        (lecturer (make-lecturer)))
    (lambda (message)
      (let ((sing (get-method singer message))
            (lect (get-method lecturer message)))
        (if (method? sing)
            sing
            lect)))))

(define alyssa
  (let ((singer (make-singer))
        (lecturer (make-lecturer)))
    (lambda (message)
      (let ((sing (get-method singer message))
            (lect (get-method lecturer message)))
        (if (method? lect)
            lect
            sing)))))

