;;;This is the code for the advisor problem set

;;; Before it can run, you need to define ENTRY-KEYS, ENTRY-VALUE,
;;; and FILTER


;;;Top-level procedure
(define (see-advisor name)
  (print (list 'hi name))
  (print '(i am your freshman advisor))
  (print '(what are your plans for the semester))
  (advisor-driver-loop name))

;;;Driver loop
(define (advisor-driver-loop name)
  (newline)
  (princ '**)
  (let ((user-response (read-from-keyboard)))
    (cond ((equal? user-response '(goodbye))
	   (print (list 'goodbye name))
	   (print '(have a good semester!)))
	  (else (print (reply user-response))
		(advisor-driver-loop name)))))

;;;Select method for generating the reply
(define (reply input)
  (cond ((check-prerequisite input))
	((find-response conventional-wisdom input))
	((with-odds 1 2) (reflect-input input))
	(else (pick-random general-advice))))

;;;Reply "you have to take ... first" if the input mentions
;;;a course that has a known prerequisite
(define (check-prerequisite input)
  (let ((prereq (find-response prerequisite-structure input)))
    (if (null? prereq)
	false
	(append '(you have to take) prereq '(first)))))

;;;Check the elements of the input against a list of keyword-response
;;;entries
(define (find-response entries input)
  (let ((possible-responses
	 (filter (lambda (val) (not (null? val)))
		 (mapcar (lambda (x) (lookup x entries))
			 input))))
    (if (null? possible-responses)
	false
	(pick-random possible-responses))))

;;;Repeat the user's reponse, after changing first-person words
;;;to second person
(define (reflect-input input)
  (append (pick-random beginnings) (change-person input)))

(define (change-person phrase)
  (sublist '((i you) (me you) (am are) (my your))
                phrase))


;;;The advisor uses the following tables

;;;Here is the constructor for making tables
(define (make-entry keys value)
  (list keys value))

;;; The corresponding selectors ENTRY-KEYS and ENTRY-VALUE need to
;;; be defined.


;;;course prequisites
(define prerequisite-structure
  (list
   (make-entry '(18:03) '(18:02))
   (make-entry '(18:02) '(18:01))))

(define conventional-wisdom
  (list
   (make-entry
    '(6:001)
    '(6:001 is too much work for freshmen -- wait until next year))
   (make-entry
    '(8:01 physics)
    '(students really enjoy 8:01))
   (make-entry
    '(seminar seminars)
    '(i hear that snorkeling in Boston Harbor is a really exciting seminar))
   ))

(define general-advice
  '((make sure to take some humanities)
    (have you considered a context subject)
    (mit has a lot of interesting departments)
    (make sure to get time to explore the Boston area)
    (how about a freshman seminar)))

;;;tack on a random one of these when reflecting the user's input
(define beginnings
  '((you say)
    (why do you say)
    (i am glad to hear that)
    ()))


;;;Utility procedures

(define (find-entry item entries)
  (cond ((null? entries) false)
	((member item (entry-keys (car entries))) (car entries))
	(else (find-entry item (cdr entries)))))

(define (lookup item entries)
  (let ((val (find-entry item entries)))
    (if (null? val)
	false
	(entry-value val))))

(define (pick-random list)
  (list-ref list (random (length list))))


(define (substitute replacements item)
  (cond ((null? replacements) item)
	((eq? item (caar replacements)) (cadar replacements))
	(else (substitute (cdr replacements) item))))


(define (sublist replacements list)
  (mapcar (lambda (elt) (substitute replacements elt))
	  list))

(define (with-odds n1 n2)
  (< (random n2) n1))


;;; The definition of FILTER is missing and must be supplied.
