;;A TROLL is a kind of person


(define (take-all person)
  (let ((place (ask person 'place)))
    (for-each
     (lambda (object) (ask person 'take object))
     (filter (lambda (thing)
	       (if (is-a thing 'ownable?)
		   (not (ask thing 'owned?))
		   false))
	     (ask place 'things)))))
		   

;;A beer is a kind of ownable object

(define (make-beer)
  (let ((p (make-thing 'beer)))
    (make-object
     (object-cond
      (defmethod (beer?) true)
      (else (get-method p message))))))


;;A dean is a kind of person

(define (make-dean name place threshold)
  (let ((p (make-person name place threshold)))
    (make-object
     (object-cond
      (defmethod (act)
	(let ((place (ask self 'place)))
	  (let ((beers (filter (lambda (object) (is-a object 'beer?))
			       (ask place 'things))))
	    (if (not (null? beers))
		(sequence (ask self 'say
			       '("I will not tolerate beer on campus!"))
		       (for-each (lambda (beer) (smash-beer beer place)) 
				 beers)
		       (ask self 'say '("I have smashed the beer.")))
		((get-method p 'act) self)))))
      (else (get-method p message))))))


(define (smash-beer beer place)
  (if (ask beer 'owned?)
      (let ((owner (ask beer 'owner)))
	(ask owner 'lose beer)
	(ask owner 'have-fit))
      'done)
  (ask place 'gone beer)
  'smashed)

