;; compatability stuff (load "/usr/local/lib/scheme/sicp.scm")
;; GJS NEW load file (load "/usr/wren/berwick/6001/ps3-new.scm")

(define center-width
  (lambda (c w)
    (make-interval (- c w) (+ c w))))

(define center
  (lambda (i)
    (/ (+ (lower-bound i) (upper-bound i)) 2)))

(define make-interval
  (lambda (a b)
    (cons a b)))

(define upper-bound 
  (lambda (x)
    (cdr x)))

(define lower-bound
  (lambda(x)
    (car x)))

;; 2.11
(define make-center-percent
  (lambda (center p-tol)
    (let ((w (* center (/ p-tol 100.0))))
      (center-width center w))))


(define percent
  (lambda (i)
    (let ((ctr (center i)))
      (* (/ (- (upper-bound i)
	    ctr) ctr)
	 100.0))))

;;; Laboratory exercises

(define distance-tolerance 0.5)
(define magnitude-tolerance 2.0)

(define star-name
  (lambda (star) (first star)))


(define star-position
  (lambda (x) (cadr x)))

(define star-magnitude
  (lambda (x) (caddr x)))

(define second 
  (lambda (x)
    (cadr x)))

(define third
  (lambda (x)
    (caddr x)))

(define spot-number
  (lambda (spot) (first spot)))

(define spot-position
  (lambda (x) (cadr x)))

(define spot-brightness
  (lambda (x) (caddr x)))

(define similar-magnitudes?
  (lambda (star spot)
    (< (abs (- (star-magnitude star)
	       (spot-brightness spot)))
       magnitude-tolerance)))

;; this selector
;; gets individual coordinates assuming (x, y) pairs were built
;; by the constructor CONS

;; these are defined by Paula in lab as x-coord and y-coord
(define x-position 
  (lambda (point)
    (first point)))

(define y-position 
  (lambda (point)
    (second point)))

;; seems to work OK
(define distance
  (lambda (point1 point2)
    (define square (lambda (x) (* x x)))
    (let ((x-diff (- (x-position point1)
		     (x-position point2)))
	  (y-diff (- (y-position point1)
		     (y-position point2))))
      (sqrt (+ (square x-diff)
	       (square y-diff ))))))

	   
;; constructor assumes we have (spot, star)
;; pair-up makes a list of a spot and a star, so
;; we need a selector to pull these apart and get the positions
(define star-position-from-pair 
  (lambda (spot-star-pair)
    (star-position (pair-star spot-star-pair))))

(define spot-position-from-pair
  (lambda (spot-star-pair)
    (spot-position (pair-spot spot-star-pair))))

;; computes whether the distance between spots 1 and 2 is like those
;; between stars 1 and 2
(define similar-distances?
  (lambda (pair1 pair2)
    (let ((spot1 (spot-position-from-pair pair1))
	  (star1 (star-position-from-pair pair1))
	  (spot2 (spot-position-from-pair pair2))
	  (star2 (star-position-from-pair pair2)))
      (< (abs (- (distance spot2 spot1)
		 (distance star2 star1)))
	 distance-tolerance))))


;; standard recursion down list of interpretations, checking distance
;; for each one with the new-pair
(define distances-check
  (lambda (new-pair interpretation)
    (cond ((null? interpretation) true)
	  ((similar-distances? new-pair (first interpretation))
	   (distances-check new-pair (rest interpretation)))
	  (else false))))


;;original
(define (extend-interpretations pair interpretations)
  (define (extend-all interps)
    (if (null? interps)
	the-empty-list
	(cons (augment-interpretation pair (car interps))
	      (extend-all (cdr interps)))))
  (extend-all interpretations))


;; modification number 1
(define (all-interpretations image chart)
  (if (null? image)
      (list the-empty-interpretation)
      (let ((spot-to-match (first image))
            (spots (rest image)))
        (define (match-all stars)
          (cond ((null? stars)
                 the-empty-list)
                ((not (similar-magnitudes? (first stars) spot-to-match))
                 (match-all (rest stars)))   ; not similar, try rest
                (else (append (extend-interpretations     ; are similar, 
                                   (pair-up spot-to-match ; extend interp.
                                            (car stars))
                                   (all-interpretations 
                                            spots
                                            (delete (car stars) chart)))
                              (match-all (cdr stars))))))
      (match-all chart))))

;; modification number 2 to include distances-check
(define extend-interpretations
  (lambda (pair interpretations)
    (define extend-all 
      (lambda (interps)
	(cond ((null? interps)
	       the-empty-list)
	      ((distances-check pair (car interps)) ; if new pair consistent
	       (cons (augment-interpretation pair (car interps))
		     (extend-all (cdr interps))))    ; add it and try next
	      (else (extend-all (cdr interps))))))    ; o.w., just try next
    (extend-all interpretations)))


(define find-transformation
  (lambda (star1 spot1 star2 spot2)
    (let ((xa (x-position (star-position star1)))
	  (ya (y-position (star-position star1)))
	  (xb (x-position (star-position star2)))
	  (yb (y-position (star-position star2)))
	  (ua (x-position (spot-position spot1)))
	  (va (y-position (spot-position spot1)))
	  (ub (x-position (spot-position spot2)))
	  (vb (y-position (spot-position spot2))))
      (compute-transformation xa ya xb yb ua va ub vb))))
;; probably should use a different distance tolerance than for
;; similar-pairs test, defined as distance-tolerance-trans
;; might want to put IF test early to check for null interpretation

;; selects the first intepretation in a list of interpretation
(define first-interp 
  (lambda (interp)
    (first interp)))

;; selectors for x-pos-spot, etc. (could replace above)
(define u-pos-spot
  (lambda (interp)
    (x-position (spot-position-from-pair interp))))

(define v-pos-spot
  (lambda (interp)
    (y-position (spot-position-from-pair interp))))

(define x-pos-star
  (lambda (interp)
    (x-position (star-position-from-pair interp))))

(define y-pos-star
  (lambda (interp)
    (y-position (star-position-from-pair interp))))

(define distance-tolerance-trans 0.3)


;; check-matched pairs
(define check-matched-pairs
  (lambda (interpretation transformation)
    (define check-tolerance
      (lambda (trans-spot-pt star-pt)
	(<  (abs (- trans-spot-pt star-pt))
	    distance-tolerance-trans)))
    (if (null? interpretation)   ;do no filtering
	true
	(let ((current-interp (first interpretation)))
	  (let ((mapped-spot (map-uv-to-xy 
			      (u-pos-spot current-interp)
			      (v-pos-spot current-interp)
			    transformation)))
	    (if (not (and (check-tolerance (first mapped-spot) 
				       (x-pos-star current-interp))
		      (check-tolerance (rest mapped-spot)
				       (y-pos-star current-interp))))
		 false
		 (check-matched-pairs (rest interpretation)
					   transformation)))))))

;;define a test transformation
(define test-trans (lambda ()
		     (find-transformation
		      (first trial-stars-1) (third trial-spots-1)
		      (second trial-stars-1) (first trial-spots-1))))

;;define a test matching
(define test-match
  (lambda ()
    (all-interpretations trial-spots-1 trial-stars-1)))

(define get-transform
  (lambda (interp)
    (if (> (length interp) 1)  ; must be at least 2 stars
	(let ((pair1 (first interp))
	      (pair2 (second interp)))
	  (compute-transformation (x-pos-star pair1)
				  (y-pos-star pair1)
				  (x-pos-star pair2)
				  (y-pos-star pair2)
				  (u-pos-spot pair1)
				  (v-pos-spot pair1)
				  (u-pos-spot pair2)
				  (v-pos-spot pair2)))
	false)))

;; modification number 3
(define extend-interpretations
  (lambda (pair interpretations)
    (define extend-all 
      (lambda (interps)
	(cond ((null? interps)
	       the-empty-list)
	      ((pair-check? pair (car interps)) ; if new pair consistent
	       (cons (augment-interpretation pair (car interps))
		     (extend-all (cdr interps))))  ; add it and try next
	      (else (extend-all (cdr interps))))))   ; o.w., just try next
    (extend-all interpretations)))


;; pair-check
(define pair-check?
  (lambda (pair interp)
    (let ((trans (get-transform interp)))
      (cond ((not (distances-check pair interp)) false)
	    (trans
	     (check-matched-pairs
	      (augment-interpretation pair interp) trans))
	    (else true)))))

