;;; This is the file     10-ANSWER.SCM

; ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
; PROBLEM 1:  CLENGTH
; Form to be evaluated:

      (compile-and-go
       '(define clength
          (lambda (lst)
            (cond
             ((null? lst) 0)
             (else (+ 1 (clength (cdr lst))))))))

;  ------------------------------------------------------------
;  | n |       lst           |  opers   |  pushes  |max depth |
;  ------------------------------------------------------------
;  | 0 | ()                  |          |          |          |
;  ------------------------------------------------------------
;  | 1 | (a)                 |          |          |          |
;  ------------------------------------------------------------
;  | 2 | (a b)               |          |          |          |
;  ------------------------------------------------------------
;  | 3 | (a b c)             |          |          |          |
;  ------------------------------------------------------------
;  | 4 | (a b c d)           |          |          |          |
;  ------------------------------------------------------------

; Formulas:   Operations = 

;             Pushes = 

;             Depth =  

; ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
; PROBLEM 2:  ILENGTH
; Form to be evaluated within EC-EVAL:

           (define ilength
              (lambda (lst)
                (cond
                 ((null? lst) 0)
                 (else (+ 1 (ilength (cdr lst)))))))

;  ------------------------------------------------------------
;  | n |       lst           |  opers   |  pushes  |max depth |
;  ------------------------------------------------------------
;  | 4 | (a b c d)           |          |          |          |
;  ------------------------------------------------------------


; Reasons for difference in performance of compiled and interpreted code:

; Reason 1:




; Reason 2:




; Reason 3:





; ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
; PROBLEM 3: Compiled code for CLENGTH
; Form to evaluate:

        (pp (compile
               '(define clength
                  (lambda (lst)
                    (cond
                     ((null? lst) 0)
                     (else (+ 1 (clength (cdr lst)))))))))

; Compiled code, annotated with explanations:


; ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
; PROBLEM 4: Extension of compiler for (WHILE p e1 ... eN) forms.

; 4a.: New WHILE? predicate:




;      New clause in COMPILE-EXPRESSION:




; 4b.: New COMPILE-WHILE function:


; 4c.: Compiled code for ITER-FACT, annotated with comments:
; Form to be entered:

        (pp
         (compile
           '(define iter-fact
              (lambda (n f)
                (while (> n 1)
                   (set! f (* n f))
                   (set! n (- n 1)))
                f))))




; 4d.: Trace of runs of ITER-FACT:
; Form to be entered:

        (compile-and-go
           '(define iter-fact
              (lambda (n f)
                (while (> n 1)
                   (set! f (* n f))
                   (set! n (- n 1)))
                f)))







; Then, in explicit-control evaluator:

        (iter-fact 4 1)








        (iter-fact 5 1)








; 4e. (For Extra Credit Only) : Improved COMPILE-WHILE:




; ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
; PROBLEM 5: Parallelism profile of (GEN-TREE 4).
; Form to be entered:

        (s-eval
         '(define gen-tree
            (lambda (n)
              (if (= n 0)
        	  23
        	  (let ((j (- n 1)))
                    (cons (gen-tree j)
        		  (gen-tree j)))))))

; Parallelism profile of

        (s-eval '(gen-tree 4))




















;     Explanation:


; ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
; PROBLEM 6: Strict and nonstrict evaluations of
;               (count-atoms (gen-tree 3))
; Form to be entered:
        (s-eval
         '(define count-atoms
            (lambda (lst)
              (cond
               ((null? lst) 0)
               ((not (pair? lst)) 1)
               (else (+ (count-atoms (car lst))
                        (count-atoms (cdr lst))))))))

; Test runs:

        (s-eval  '(count-atoms (gen-tree 3)))
        (ns-eval '(count-atoms (gen-tree 3)))

;  ---------------------------------------------------
;  |                         |  strict   | nonstrict |
;  ---------------------------------------------------
;  | Result returned at step |           |           |
;  ---------------------------------------------------
;  | Steps                   |           |           |
;  ---------------------------------------------------
;  | Max Parallelism         |           |           |
;  ---------------------------------------------------
;  | Processes               |           |           |
;  ---------------------------------------------------
;
;  Parallelism profiles
;      strict:














;      non-strict:















; Explanation of the different shapes of the parallelism profiles.






; Explanation of why the number of processes forked is the same.







; ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
; PROBLEM 7: Speculating in FUTUREs

; 7a. Implementation of FUTURE? and TOUCH? predicates:










; 7b. New instructions in EVAL-DISPATCH to handle FUTUREs and TOUCHes:






; 7c. Code at EV-FUTURE:




















; 7d. Code at EV-TOUCH:



















; 7e. Running the evaluator of the future on the expression:
                (count-atoms (gen-tree 3))

; Forms to be entered:

        (f-eval
         '(define gen-tree
            (lambda (n)
              (if (= n 0)
                  23
                  (let ((j (- n 1)))
                    (let ((t1 (future (gen-tree j)))
                          (t2 (future (gen-tree j))))
                      (cons (touch t1) (touch t2))))))))

        (f-eval
         '(define count-atoms
            (lambda (lst)
              (cond
               ((null? lst) 0)
               ((not (pair? lst)) 1)
               (else (let ((v1 (future (count-atoms (car lst))))
                           (v2 (future (count-atoms (cdr lst)))))
                       (+ (touch v1)
                          (touch v2))))))))

; Test run of
        (f-eval '(count-atoms (gen-tree 3)))




























; ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
; PROBLEM 8:
; Explanation of effect, if any, in parallelism of COUNT-ATOMS:




















; ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
; PROBLEM 9 (For Extra Credit Only):
; Consequences on programming style when we have implicit TOUCHes
