;;; This is the code for Problem Set 5

;;; each companies files are labelled with company name

(defabs '(company name file))

;;; basic structures for information

(defabs '(folder id info))

;; records will use labelled structures, much a like a labelled list

(defabs '(records folder rest))
(defabs 'no-records)

;;; Lookup, insert and delete for Stunned Macrosystems
;;; note that procedures are to be applied to file portion of company structure

(define (lookup-unordered name file)
  (cond ((no-records? file) #f)
        ((eq? (person-at-current-folder file) name)
          (records-folder file))
        (else (lookup-unordered name (records-rest file))))))

(define (person-at-current-folder file)
  (folder-id (records-folder file)))

(define (insert-unordered name info file)
  (let ((rec (folder name info)))
    (cond ((no-records? file)
           (records rec file))
          ((eq? (person-at-current-folder file) name)
           (records rec (records-rest file)))
          (else (records (records-folder file)
                         (insert-unordered name info
                                           (records-rest file)))))))

(define (delete-unordered name file)
  (cond ((no-records? file)
         file)
        ((eq? (person-at-current-folder file) name)
         (records-rest file))
        (else (records (records-folder file)
                       (delete-unordered name (records-rest file))))))

;; trial sample

(define stunned
  (company 'stunned
           (insert-unordered 'moe
                (insert-unordered 'salary 40000
                                  (insert-unordered 'address
                                                    '(77 mass ave)
                                                    no-records))
                (insert-unordered 'joe
                                  (insert-unordered 'salary 30000
                                                    (insert-unordered 'address
                                                                      '(88 main st)
                                                                      no-records))
                                  no-records))))


;;; Oops, lookup, insert and delete for Numerics is destroyed
;;; in a fire.

;; once you have defined your procedures, try evaluating
;; and manipulating the following procedure.

;(define numerics
;  (company 'numerics
;          (insert-ordered 'jane
;               (insert-ordered 'salary 45000
;                               (insert-ordered 'address
;                                               '(350 memorial drive)
;                                               no-records))
;               (insert-ordered 'ruth
;                               (insert-ordered 'salary 50000
;                                               (insert-ordered 'address
;                                                               '(90 summer st)
;                                                               no-records))
;                               no-records))))

;;; data structures for a tree

(defabs '(tree left right symbols))

;;; Lookup, insert and delete for Quince

(define (lookup-tree name file)
  (let ((next-branch (choose-branch name file)))
    (cond ((null? next-branch) #f)
          ((folder? next-branch) next-branch)
          (else (lookup-tree name next-branch)))))

(define (choose-branch name file)
  (let ((left-branch (tree-left file))
        (right-branch (tree-right file)))
    (cond ((memq name (find-symbols left-branch)) left-branch)
          ((memq name (find-symbols right-branch)) right-branch)
          (else nil))))

(define (find-symbols tree)
  (cond ((no-records? tree) '())
        ((folder? tree) (list (folder-id tree)))
        (else (tree-symbols tree))))

(define (make-tree left right)
  (tree left right (append (find-symbols left)
                           (find-symbols right))))

(define (insert-tree name info file)
  (let ((new-folder (folder name info)))
    (cond ((and (no-records? (tree-left file))
                (no-records? (tree-right file)))
           ;; bare file, so create using left branch
           (make-tree new-folder (tree-right file)))
          (else
           (let ((path (choose-path name file)))
             (if (null? path)
                 (let ((r (random 2)))
                   (if (= r 1)
                       (cond ((no-records? (tree-left file))
                              (make-tree new-folder (tree-right file)))
                             ((folder? (tree-left file))
                              (make-tree (make-tree new-folder (tree-left file))
                                         (tree-right file)))
                             (else
                              (make-tree (insert-tree name info (tree-left file))
                                         (tree-right file))))
                       (cond ((no-records? (tree-right file))
                              (make-tree (tree-left file) new-folder))
                             ((folder? (tree-right file))
                              (make-tree (tree-left file)
                                         (make-tree (tree-right file) new-folder)))
                             (else
                              (make-tree (tree-left file)
                                         (insert-tree name info (tree-right file)))))))
               (if (folder? (choose-branch name file))
                   (if (eq? path 'left)
                       (make-tree new-folder (tree-right file))
                       (make-tree (tree-left file) new-folder))
                   (if (eq? path 'left)
                       (make-tree (insert-tree name info (tree-left file))
                                  (tree-right file))
                       (make-tree (tree-left file)
                                  (insert-tree name info (tree-right file)))))))))))


(define (delete-tree name file)
   (let ((path (choose-path name file)))
      (cond ((eq? 'left path)
             (if (folder? (tree-left file))
                 (make-tree no-records (tree-right file))
                 (make-tree (delete-tree name (tree-left file))
                            (tree-right tree))))
            ((eq? 'right path)
             (if (folder? (tree-right file))
                 (make-tree (tree-left file) no-records)
                 (make-tree (tree-left tree)
                            (delete-tree name (tree-right file)))))
            (else file))))

(define (choose-path name file)
  (cond ((memq name (find-symbols (tree-left file))) 'left)
        ((memq name (find-symbols (tree-right file))) 'right)
        (else nil)))

;; trial sample

(define bare-tree (tree no-records no-records nil))

(define bob-rec (tree (folder 'address '(23 summer st))
                      (folder 'salary 45300)
                      '(address salary)))


(define amy-rec (tree (folder 'address '(709 winter st))
                      no-records 
                      '(address)))

(define quince
  (company 'quince
           (insert-tree 'bob bob-rec
                        (insert-tree 'amy amy-rec
                                     bare-tree))))




