;; code for food problem set 

;; constructor for dishes

(define make-dish
  (lambda (name ingredients cals cost)
    (list name ingredients cals cost)))


;; constructor for ingredients

(define make-ingredient
  (lambda ( name cals-unit cost-unit)
     (list name cals-unit cost-unit)))

;; sample list of dishes
(define dishes
   (list (make-dish 'hamburger '((beef .25) (bun 1)) 0 0)
         (make-dish 'cheeseburger '((beef .25) (bun 1) (am-cheese 1)) 0 0) 
         (make-dish 'swissburger '((beef .25) (bun 1) (sw-cheese 1)) 0 0) 
         (make-dish 'hotdog '((frankfurter 1) (hbun 1)) 0 0)
         (make-dish 'reg-coke '((coke-syrup .5)) 0 0)
         (make-dish 'large-coke '((coke-syrup 1)) 0 0)
         (make-dish 'doubleburger '((beef .5) (bun 1)) 0 0)))
;; note that coke has an empty list of ingredients, and that
;; the calories and cost have already been inserted into the structure

;; sample list of ingredients
(define ingredients
  (list (make-ingredient 'beef 200 1.50)
        (make-ingredient 'am-cheese 100 .10)
        (make-ingredient 'sw-cheese 200 .20)
        (make-ingredient 'bun 50 .15)
        (make-ingredient 'hbun 50 .10)
        (make-ingredient 'frankfurter 150 .20)
        (make-ingredient 'coke-syrup 75 .10)))

(define calories-of-dish
  (lambda (dish ings-list)                      
    ;arguments are a dish structure and a list of ingredient structures
    (let ((dish-ings (dish-ingredients dish)))  ; get the ingredients of the dish
      (accumulate-cals dish-ings ings-list))))  ; determine number of calories

;;general procedures for manipulating list structures
(define map
  (lambda (proc lst)
    (if (null? lst)   ; if lst is empty
        '()           ; then return an empty list
        (cons (proc (car lst))   ; otherwise apply procedure to first element
              (map proc (cdr lst))))))

(define filter
  (lambda (pred lst)
    (cond ((null? lst)   ; if lst is empty
           '())          ; then return an empty list
          ((pred (car lst))  ; if first element satisfies predicate
           (cons (car lst) (filter pred (cdr lst))))  ; then add to new list
          (else  ; otherwise discard from new list, and handle remainder
           (filter pred (cdr lst))))))

(define accumulate
  (lambda (combiner init lst)
     (if (null? lst)  ; if lst is empty
         init         ; return initial value
         (combiner (car lst)  ;; otherwise combine first element
                   (accumulate combiner init (cdr lst))))))


(define flatten
  (lambda (l)
    (accumulate append '() l)))