;;; This is the code for problem set 2

;;; This is the answer to Ex. 1.11 for you to work on Ex. 1.13

(define (new-exp b n)
  (define (square x) (* x x))
  (define (iter-exp multiplier product exponent)
    (cond ((= exponent 0) product)
          ((even? exponent)
           (iter-exp (square multiplier) product (/ exponent 2)))
          (else (iter-exp multiplier
                          (* product multiplier)
                          (- exponent 1)))))
  (iter-exp b 1 n))

;;; Procedures needed to implement fermat's test of primality

(define square (lambda (x) (* x x)))

(define big-random
  (lambda (n)
    (random (min n (expt 10 10)))))

(define fermat-test
  (lambda (n)
    (define a (big-random n))
      (= (expmod-3 a n n) a)))

(define timed-exp
  (lambda (f b e m)
    (define start-time (runtime))
    (f b e m)
    (print (- (runtime) start-time))))

;;; Louis Reasoner's 3 versions of expmod

(define expmod-1
  (lambda (b e m)
    (cond ((= e 0) 1)
          (else (remainder (* b
                              (expmod-1 b (-1+ e) m))
                           m)))))

(define expmod-2
  (lambda (b e m)
    (define exp-helper
      (lambda (times)
        (cond ((= times 0) 1)
              ((even? times)
               (square (exp-helper (\ times 2))))
              (else (* b (exp-helper (-1+ times)))))))
  (remainder (exp-helper e) m)))

(define expmod-3
  (lambda (b e m)
    (cond ((= e 0) 1)
          ((even? e)
           (remainder (square (expmod-3 b (/ e 2) m))
                      m))
          (else
           (remainder (* b (expmod-3 b (-1+ e) m))
                      m)))))


;;; CIA's key selection procedures

(define select-prime
  (lambda ()
    (let ((n (random 20)))
      (if (<= n 1)
          (select-prime)
          (let ((p (+ (square n) n 41)))
            (if (fast-prime? p 2)
                p
                (select-prime)))))))

(define select-keys
  (lambda ()
    (print "Please wait for your daily lottery numbers........")
    (define start-time (runtime))
    (let ((p (select-prime))
          (q (select-prime)))
      (if (not (= 1 (gcd p q)))
          (select-keys)
          (sequence
           (print "Your first public key is.....")
           (print (* p q))
           (print "Your second public key is.....")
           (print (select-e (* (- p 1) (- q 1))))
           (print "elapsed time is")
           (print (- (runtime) start-time)))))))

(define select-e
  (lambda (m)
    (let ((e (random 1000)))
      (if (= (gcd e m) 1)
          e
          (select-e m)))))

(define gcd
  (lambda (a b)
    (if (= b 0)
        a
        (gcd b (remainder a b)))))


;;; Encryption and Decryption procedures (really simple)


(define encrypt
  (lambda (message e n)
    (expmod-3 message e n)))

(define decrypt
  (lambda (message d n)
    (expmod-3 message d n)))


;;; Part of KGB's Ordr O. Grofiev and Bloch Schtraktur's Code-cracker


(define (improve guess)
  (- guess 1)))

;;; The rest is for you to complete.
