;;; This is the first code file for the series-parallel circuit problem set
;;; Modified by WELG to be consistent with proper dispatching

(define (make-resistor resistance)
  (attach-type 'resistor resistance))

(define (resistor? ckt)
  (eq? (type ckt) 'resistor))

(define (make-series ckt1 ckt2)
  (attach-type 'series-combination (list ckt1 ckt2)))

(define (series-combination? ckt)
  (eq? (type ckt) 'series-combination))

(define (make-parallel ckt1 ckt2)
  (attach-type 'parallel-combination (list ckt1 ckt2)))

(define (parallel-combination? ckt)
  (eq? (type ckt) 'parallel-combination))

(define (resistance ckt)
  (cond ((resistor? ckt)
	 (resistance-resistor (contents ckt)))
	((parallel-combination? ckt)
	 (resistance-parallel (contents ckt)))
	((series-combination? ckt)
	 (resistance-series (contents ckt)))
	(else
	 (error "Unknown circuit type -- RESISTANCE" ckt))))

(define (conductance ckt)
  (cond ((resistor? ckt)
	 (conductance-resistor (contents ckt)))
	((parallel-combination? ckt)
	 (conductance-parallel (contents ckt)))
	((series-combination? ckt)
	 (conductance-series (contents ckt)))
	(else
	 (error "Unknown circuit type -- CONDUCTANCE" ckt))))

(define (resistance-resistor resistor)
  resistor)

(define (conductance-resistor resistor)
  (/ 1 (resistance-resistor resistor)))

(define (conductance-parallel ckt)
  (+ (conductance (left-branch ckt))
     (conductance (right-branch ckt))))

(define (conductance-series ckt)
  (/ 1 (resistance-series ckt)))

(define (resistance-series ckt)
  (+ (resistance (left-branch ckt))
     (resistance (right-branch ckt))))

(define (resistance-parallel ckt)
  (/ 1 (conductance-parallel ckt)))

(define (left-branch ckt)
  (car ckt))

(define (right-branch ckt)
  (cadr ckt))

;;;Type stuff the same as before
(define (attach-type type contents)
  (cons type contents))

(define (type datum)
  (if (not (atom? datum))
      (car datum)
      (error "Bad typed datum -- TYPE" datum)))

(define (contents datum)
  (if (not (atom? datum)) 
      (cdr datum)
      (error "Bad typed datum -- CONTENTS" datum)))
