;;; Answers for PS5

; Exercise 1
(define r1 (make-resistor 10))
(define r2 (make-resistor 20))
(define r3 (make-resistor 20))
(define r4 (make-resistor 40))
(define N
  (make-series (make-parallel r1 r2)
	       (make-parallel r3 r4)))

;a. Box-and-pointer

;b. 3 times:
; 1. (r1//r2)+(r3//r4)
; 2. (r1//r2)
; 3. (r3//r4)


; Exercise 2

(define (l-extend base series-part parallel-part)
  (make-series series-part (make-parallel parallel-part base)))

; Exercise 3

(define ex3 (l-extend n (make-resistor 10) (make-resistor 20)))

(resistance ex3)

; Exercise 4

(define (ladder-extension stages base series-part parallel-part)
  ((repeated (lambda (base) (l-extend base series-part parallel-part)) stages) 
   base))

; Exercise 5

(define (ladder-loop increment)
  (define (iter stages)
    (newline)
    (princ stages)
    (princ ": ")
    (princ (resistance (ladder-extension stages 
					 (make-resistor 1)
					 (make-resistor 1)
					 (make-resistor 1))))
    (iter (+ stages increment)))
  (iter 0))
				
; Converges to 1.61803 = golden ratio.

; Exercise 6.

; When you use resistance-parallel which works in terms of
; conductances, it ends up computing the conductances (and
; therefore the resistances) of the component parts only once.
; Could get the same effect here by using a LET.

;a. 2N+1 resistors in an N-stage ladder.

;b. Originally, will call it only once for each resisitor - i.e. 
;   2N+ 1 times

;c. For each series case, will evaluate RESISTANCE-RESISTOR once
;   (on the left branch) and  will evaluate the parallel network once.
;   For each parallel case, will evaluate RESISTANCE-RESITOR twice (for
;   the left branch, and will evaluate the series network twice.
;   For the base case will evaluate the resistance once.  Thus we have
;   1 + 2( 1 + 1 + 2( 1 + 1 + 2 ( ...

; Or, perhaps better, 
; T(0) = 1
; T(N) = 1 + 2(1 + T(N-1)) = 1 + 2 + 2T(N-1) = 3 + 2T(N-1)
; Thus T(N) = 1 + 2 + 2 + 4 + 4 + 8 + 8 + ... + 2^(N+1) + 2^N+1
; = [2^(N+1) - 1] {for series 1, 2, 4, 8 , ...} + [2^(N+2) - 2] {for series 4, 8, 16 ...}
; So in general get 2^(N+2) - 3

;d. he's slowed it down exponentially!

;;; PART 2

; Exercise 7. 

(define n2 (make-parallel (make-resistor 2) 
			  (make-parallel (make-inductor 1)
					 (make-capacitor 1))))

(define fooler (make-parallel (make-series (make-resistor 1)
					   (make-capacitor 1))
			      (make-series (make-resistor 1)
					   (make-inductor 1))))

((resistance n2) (make-complex 2 0))

((resistance n2) (make-complex 0 2))

; Exercise 8

(define (frequency-response-magnitude circuit)
  (lambda (imaginary-part)
    (magnitude ((resistance circuit) (make-complex 0 imaginary-part)))))

(define (plot-circuit circuit)
  (clear-graphics)
  (line-plot
   (frequency-response-magnitude circuit)
   0.001
   2
   0.05))

;(plot-circuit n2)

; Exercise 9

(define n3 (make-parallel (make-resistor 10) 
			  (make-parallel (make-inductor 1)
					 (make-capacitor 1))))

;( plot-circuit n3)
     
   

;;; PART 3

; Exercise 10

(define (heads)
  (= (random 2) 0))

; Recursive version

(define (split-list lst)
  (if (null? lst) 
      (cons '() '())
      (let ((split-rest-pair (split-list (cdr lst))))
	(if (heads)
	    (cons (cons (car lst)
			(car split-rest-pair))
		  (cdr split-rest-pair))
	    (cons (car split-rest-pair)
		  (cons (car lst)
			(cdr split-rest-pair)))))))

; Iterative version

(define (split-list-1 lst)
  (define (iter original-list pile-1 pile-2)
    (cond ((null? original-list)
	   (cons pile-1 pile-2))
	  ((heads)
	   (iter (cdr original-list) (cons (car original-list) pile-1) pile-2))
	  (else (iter (cdr original-list) pile-1 (cons (car original-list) pile-2)))))
  (iter lst '() '()))

(define (random-circuit parts)
  (if (= (length parts) 1)
      (car parts)
      (let ((split-parts-pair (split-list parts)))
	(let ((subset1 (car split-parts-pair))
	      (subset2 (cdr split-parts-pair)))
	  (cond ((or (null? subset1)
		     (null? subset2))
		 (random-circuit parts))
		((heads)
		 (make-series (random-circuit subset1)
			      (random-circuit subset2)))
		(else (make-parallel (random-circuit subset1)
				     (random-circuit subset2))))))))

; Exercise 11

(define parts-list (list (make-capacitor 1)
			 (make-capacitor 2)
			 (make-inductor 1)
			 (make-resistor 1)
			 (make-resistor 2)))

(define (generate-circuits parts number)
  (if (= number 0)
      '()
      (cons (random-circuit parts)
	    (generate-circuits parts (- number 1)))))

(define sample-circuits (generate-circuits parts-list 5))

; Of my circuits, the first, second, fourth, and fifth showed resonant behavior.
  

; Exercise 13.

; Idea is to test for a sharp peak or deep (where we define what "sharpness" means.

; Derivative will be useful - we'll find the zero crossings of the 
; derivative of our resonance curve to determine its peaks and dips.

(define (deriv f dx)
  (lambda (x) 
    (/ (- (f (+ x dx)) 
	  (f x))
       dx)))

; Returns a list of all x-values between from and to at which a zero-crossing
; of fn occurs.  Step determines the stepping value between from and to (and the
; granularity at which the zero-crossings are measured - e.g. show some sin examples)
; The function arbitrarily returns the x value after the detected zero-crossing

(define (zero-crossings fn from to step)
  (define (loop current-x previous-y current-y zero-crossing-list)
    (cond ((> current-x to) zero-crossing-list)
	  ((or (= current-y 0)
	       (< (* previous-y current-y) 
		  0))                                  ; if these are of opposite sign, must be zero-crossing in between
	   (loop (+ current-x step) 
		 current-y 
		 (fn (+ current-x step)) 
		 (cons (if (< (abs current-y) (abs previous-y))
			   current-x
			   (- current-x step))
		       zero-crossing-list)))
	  (else (loop (+ current-x step) 
		      current-y 
		      (fn (+ current-x step)) 
		      zero-crossing-list))))
  (loop (+ from step) (fn from) (fn (+ from step)) nil))

(define default-dx 0.01)
(define default-scan-step 0.1)
(define default-max-frequency 2)
(define default-sharpness-offset 0.1)
(define default-sharpness-threshold 5)

; Returns a list of the values near which a max or min occurs
(define (maxes-and-mins fn from to step)
  (zero-crossings (deriv fn default-dx) from to step))

; Finds maxes and mins and returns those which are "sharp", as determined
; by some notion of sharpness.
(define (sharp? fn x threshold)
  (> (abs ((deriv (deriv fn default-dx) default-dx) x))
     threshold))
  
(define (check-resonance ckt)
  (let ((magnitude-of-impedance (frequency-response-magnitude ckt)))
    (let ((sharp-peaks-and-dips 
	   (filter (lambda (x) (sharp? magnitude-of-impedance 
				       x
				       default-sharpness-threshold))
		   (maxes-and-mins magnitude-of-impedance
				   0
				   default-max-frequency
				   default-scan-step))))
      (print-resonance sharp-peaks-and-dips)
      sharp-peaks-and-dips)))

(define (print-resonance peaks-and-dips)
  (cond ((null? peaks-and-dips)
	 (newline)
	 (princ "The circuit does not exhibit resonance between the frequencies of 0 and ")
	 (princ default-max-frequency))
	(else (princ "The circuit exhibits resonance between 0 and ")
	      (princ default-max-frequency)
	      (newline)
	      (princ " at the following frequencies: "))))

		
(define (filter pred lst)
  (cond ((null? lst) nil)
	((pred (car lst))
	 (cons (car lst)
	       (filter pred (cdr lst))))
	(else (filter pred (cdr lst)))))
	       
	 
		       
		
		
; Circuit Generation

; Two methods

; Method 1: generate all circuits, but remove duplicates

(define (make-subset-pairs lst)
  (cond ((< (length lst) 2) (error "I must have a list greater than two"))
	((= (length lst) 2)
	 (list (list (list (car lst)) 
	             (list (cadr lst)))))
	(else (let ((smaller-sets (make-subset-pairs (cdr lst)))
		    (new-elt (car lst)))
		(append (list (list (list new-elt) (cdr lst)))
			(mapcar (lambda (pair)
				  (list (cons new-elt (car pair))
					(cadr pair)))
				smaller-sets)
			(mapcar (lambda (pair)
				  (list (cons new-elt (cadr pair))
					(car pair)))
				smaller-sets))))))

(define (generate-all list-of-parts)
  (if (<= (length list-of-parts) 1)                    ; Handle the 0 and 1 cases specially
      list-of-parts
      (let ((subsets (make-subset-pairs list-of-parts)))
	(let ((all-subcircuit-pairs (mapappend all-subset-combinations subsets)))
	  (remove-duplicates
	   circuit=?
	   (append (mapcar (lambda (ckt-pair)
			     (make-series (car ckt-pair)
					  (cadr ckt-pair)))
			   all-subcircuit-pairs)
		   (mapcar (lambda (ckt-pair)
			     (make-parallel (car ckt-pair)
					    (cadr ckt-pair)))
			   all-subcircuit-pairs)))))))
	      
	
; Take a pair of subsets and return a list of all possible
; pairs of circuits makeable from the subsets

(define (all-subset-combinations subset-pair)
  (all-pairs (generate-all (car subset-pair))
	     (generate-all (cadr subset-pair))))

; Given two lists, return all possible pairs using one element
; from each list

(define (all-pairs lst1 lst2)
  (if (null? lst1)
      nil
      (append (mapcar (lambda (elt-of-lst2)
			(list (car lst1) elt-of-lst2))
		      lst2)
	      (all-pairs (cdr lst1) lst2))))
			      
(define (remove-duplicates equal-fn lst)
  (if (null? lst)
      nil
      (cons (car lst)
	(filter (lambda (elt)
		  (not (equal-fn (car lst) elt)))
		(remove-duplicates equal-fn (cdr lst))))))

(define (circuit=? ckt1 ckt2)
  (define (compare-circuits number-of-tests)
    (cond ((= number-of-tests 0) #!true)
	  ((same-impedance ckt1 ckt2 (random-frequency))
	   (compare-circuits (- number-of-tests 1)))
	  (else #!false)))
  (compare-circuits 3))

(define (same-impedance ckt1 ckt2 freq)
  (close-enough? ((frequency-response-magnitude ckt1) freq)
		 ((frequency-response-magnitude ckt2) freq)))

(define (random-frequency)
    (/ (random 2000) 1000))

(define (close-enough? num1 num2)
  (< (abs (- num1 num2))
     0.001))
      
      
      
; Method 2: 

(define (generate-all list-of-parts)
  (generate-with-combiners list-of-parts 
			   '()
			   (list make-series make-parallel)))

(define (generate-with-combiners list-of-parts
				 unusable-combiner
				 possible-combiners)
  (if (<= (length list-of-parts) 1)                    ; Handle the 0 and 1 cases specially
      list-of-parts
      (let ((subset-pairs (make-subset-pairs list-of-parts)))
	(mapappend 
	 (lambda (pair)
	   (let ((all (generate-all (cadr pair))))
	     (mapappend
	      (lambda (combiner)
		(combine-all-pairs combiner 
				   (generate-with-combiners (car pair)
							    combiner
							    possible-combiners)
				   all))
	      (remove unusable-combiner possible-combiners))))
	 subset-pairs))))

(define (mapappend proc lst)
  (if (null? lst)
      nil
      (append (proc (car lst))
	      (mapappend proc (cdr lst)))))

(define (remove elt lst)
  (filter (lambda (thing)
	    (not (eq? thing elt)))
	  lst))

(define (flatten lst)
  (mapappend (lambda (x) x) lst))

(define (combine-all-pairs combiner lst1 lst2)
  (mapappend 
   (lambda (elt1)
     (mapcar
      (lambda (elt2)
	(combiner elt1 elt2))
      lst2))
   lst1))
       
			  
(define (circuits lst)
  (define (print-ckts ckts)
    (define (iter things num)
      (cond ((null? things) npo)
	    (else
      (newline)
      (princ num)
      (princ ". ")
      (princ (short-form (car things)))
      (iter (cdr things) (1+ num)))))
    (iter ckts 1))
  (let ((result (generate-all lst)))
    (newline)
    (newline)
    (princ "There are ")
    (princ (length result))
    (princ " circuits for ")
    (princ (length lst))
    (princ " elements:")
    (newline)
    (if print-ckts?
	(print-ckts result))
    (length result)))

(define print-ckts? nil)
	  
;;; Creates a short form better for printing.	 
(define (short-form ckt-elt)
  (cond ((resistor? ckt-elt)
	 ; A hack for now because I cant figure out how to 
	 ; attach a number to a symbol.
	 (let ((value (cadar (contents ckt-elt))))
	   (cond ((= value 1) 'r1)
		 ((= value 2) 'r2)
		 ((= value 3) 'r3)
		 ((= value 4) 'r4)
		 ((= value 5) 'r5)
		 ((= value 6) 'r6)
		 ((= value 7) 'r7))))
	((series-combination? ckt-elt)
	 (let ((stuff (contents ckt-elt)))
	   (list '+ 
		 (short-form (left-branch stuff))
		 (short-form (right-branch stuff)))))
	((parallel-combination? ckt-elt)
	 (let ((stuff (contents ckt-elt)))
	   (list '// 
		 (short-form (left-branch stuff))
		 (short-form (right-branch stuff)))))))

(define r1 (make-resistor 1))

(define r2 (make-resistor 2))

(define r3 (make-resistor 3))

(define r4 (make-resistor 4))

(define r5 (make-resistor 5))

(define r6 (make-resistor 6))

(define r7 (make-resistor 7))
