% for yTeX
\typesize=11pt
\hsize=34pc
\vsize=50pc
\parskip 6pt plus 2pt

\def\v#1{\hbox{\bf #1}}

\def\psetheader{
\centerline{MASSACHUSETTS INSTITUTE OF TECHNOLOGY}
\centerline{Department of Electrical Engineering and Computer Science}
\centerline{6.001 Structure and Interpretation of Computer Programs}
\centerline{Fall Semester, 1986}}

\rectoleftheader={6.001 -- Fall Semester 1986}
\rectorightheader={Problem Set 3}
\onheaders
\onfooters

\null
\vskip 1truein

\psetheader

\vskip .25truein

\centerline{Problem Set 3}

\vskip 0.25truein

\vpar
Issued:  September 23, 1986

\vpar
Due: October 1, 1986

\vpar
Reading Assignment: Chapter 2, Section 2.1, 2.2



\beginfigure
\vskip 3truein
\begincaption
Figure \figdef{1}. Tiling patterns (made by Andy diSessa and Doug Hill).  This
assignment asks you to implement a graphics language for drawing
figures such as these.
\endcaption
\endfigure

Write up and turn in the following exercise from the text:

\beginbullets

\bpar
Exercise 2.16 -- Defining {\it last}:  do this, using direct list
manipulation, that is without using procedures such as {\it length}.

\bpar
Exercise 2.17 -- Defining {\it reverse}:  Write both a recursive version
and an iterative version of {\it reverse}  What is the order of growth
of each version?

\bpar List manipulation:
Write a procedure {\it add-items} that takes a list of numbers and
returns the sum of the elements of the list.  Write a procedure {\it
add-squares} that takes a list of numbers and returns the sum of the
squares of the elements of the list.  Write a procedure {\it
add-transformed} that is a generalization of {\it add-items} and {\it
add-squares}.  It should take as arguments both a list of numbers and a
procedure and should return the sum of the results of applying the
procedure to each number in the list.  Rewrite {\it add-items} and {\it
add-squares} so that they use {\it add-transformed}.

\bpar Exercise 2.22  -- list representations

\bpar Exercise 2.23 -- {\it car-cdr} finger exercises.
\endbullets

\chapter{1. Lecture Notes:  The Square-Limit Language}

The laboratory assignment for this week begins on page 7
of this handout.  For the assignment,
you are to implement a variation of Peter Henderson's ``Escher
Square-Limit'' language, discussed in lecture on
September 25.  This handout begins with a listing of the
procedures that implement Henderson's language.  The explanation given
here is very minimal, since this will be covered in lecture.

%%next chunk gobbled from <6001.ps>squarelimit.tex

%%revised version for gobbling into Tex files

The Square-Limit Language is a simple graphics language is due to Peter
Henderson, of Oxford University.  One of the key features of 
the implementation is that it represents figures as procedures.

In particular, a ``picture'' is defined to be a procedure that takes a
rectangle as
input and causes something to be drawn, scaled to fit in the
rectangle.  A rectangle will be represented by three vectors: an
origin, a ``horizontal'' vector, and a ``vertical'' vector.   The origin \v{o}
will be represented as a vector whose coordinates give the coordinates
of the origin with respect to some external coordinate system, such as
the graphics screen coordinates.  The ``horizontal'' vector (call it
\v{h}) and the ``vertical'' vector (call it \v{v}) give the offsets of
the sides of the rectangle from the origin.  As a consequence, any
rectangle defines a linear transformation coordinate map by
mapping the point (1,0) in its coordinate frame into the point specified
by the end of the \v{horizontal} vector, offset from the origin, and by
mapping the point (0,1) in its coordinate frame into the point specified
by the end of the \v{vertical} vector, offset from the origin.

In algebraic terms, a general point $(x,y)$
gets mapped to the vector

\math{\v{o} + x*\v{h} + y*\v{v}}

where remember that \v{o}, \v{h}, and \v{v} are vectors, and $x$ and $y$
are scalars.

\vpar
We represent a rectangle by a list of three vectors: the location of the
origin of the rectangle, the vector from that origin to the end of the
``horizontal'' axis, and the vector to the end of the ``vertical'' axis.

\beginlisp
(define make-rect list)             ;; origin-vect H-vect V-vect
(define origin first)
(define horiz second)
(define vert third)
\endlisp
	
Using this map, points with coordinates between 0 and 1 end up inside
the rectangle.  Here is a procedure that takes a rectangle as input
and returns the corresponding coordinate transformation, which is itself
a procedure: 

\beginlisp
(define (coord-map rect)
  (lambda (point)
    (+vect
     (+vect (scale (xcor point)
                   (horiz rect))
            (scale (ycor point)
                   (vert rect)))
     (origin rect))))

\endlisp

The contents of a picture are defined by a
collection of line segments.
Segments are
represented as pairs of points, and
points (vectors) are represented as pairs of numbers:

\beginlisp
(define make-vector cons)
(define xcor car)
(define ycor cdr)
\pbrk
(define make-segment cons)
(define seg-start car)
(define seg-end cdr)
\endlisp


Given a rectangle as input, the picture
draws the image of each line segment inside the rectangle.  Here is a
procedure that constructs the picture, given a list of segments:
\beginlisp
(define (make-picture seglist)
  (lambda (rect)
    (for-each
     (lambda (segment)
       (drawline ((coord-map rect) (seg-start segment))
                 ((coord-map rect) (seg-end segment))))
     seglist)))

\pbrk
(define empty-picture (make-picture '()))
\endlisp

{\it Make-picture} uses a higher-order procedure {\it for-each}, which applies
a given procedure to each item in a given list:

\beginlisp
(define (for-each proc list)
  (cond ((null? list) "done")
        (else (proc (car list))
              (for-each proc (cdr list)))))
\endlisp

\section{Rotation}

To rotate a picture 90 degrees counterclockwise, we need only draw the
picture with respect to a new rectangle:

\beginfigure
\vskip 2truein
\endfigure

\beginlisp
(define (rotate90 pict)
  (lambda (rect)
    (pict (make-rect
           (+vect (origin rect)          ;O'
                  (horiz rect))          
           (vert rect)                   ;H'
           (scale -1 (horiz rect))))))   ;V'
\pbrk
(define (repeated proc n)
  (lambda (thing)
    (if (= n 0)
        thing
        ((repeated proc (-1+ n)) (proc thing)))))
\pbrk
(define rotate180 (repeated rotate90 2))
(define rotate270 (repeated rotate90 3))
\endlisp

Horizontal flip is also drawing with respect to a new rectangle:
\beginfigure
\vskip 2truein
\endfigure

\beginlisp
(define (flip pict)
  (lambda (rect)
    (pict (make-rect (+vect (origin rect) (horiz rect))
                     (scale -1 (horiz rect))
                     (vert rect)))))
\endlisp

\section{Means of combining pictures}

Since pictures are specified by procedures, we can create higher order
procedures that combine simple pictures together in various ways.  For
example, the {\it together} operation takes
two
pictures and combines them into a single picture, lying superimposed.
\beginlisp
(define (together pict1 pict2)
  (lambda (rect)
    (pict1 rect)
    (pict2 rect)))
\endlisp
The {\it beside} operation takes two pictures and
scales them according to some relative width to fit in a single rectangle. 
{\it Beside} takes as input, the two pictures, plus a variable {\it
a} which specifies the  percentage of horizontal devoted to the
first picture.

\beginlisp
(define (beside pict1 pict2 a)
  (lambda (rect)
    (pict1 (make-rect
            (origin rect)
            (scale a (horiz rect))
            (vert rect)))
    (pict2 (make-rect
            (+vect (origin rect)
                   (scale a (horiz rect)))
            (scale (- 1 a) (horiz rect))
            (vert rect)))))
\endlisp

{\it Above} is defined in terms of {\it beside}
\beginlisp
(define (above pict1 pict2 a)
  (rotate270 (beside (rotate90 pict1)
                     (rotate90 pict2)
                     a)))
\endlisp

Here are some operations defined in terms of the basic ones above:
\beginlisp
(define (4pict pict1 rot1 pict2 rot2 pict3 rot3 pict4 rot4)
  (beside (above ((repeated rotate90 rot1) pict1)
                 ((repeated rotate90 rot2) pict2)
                 .5)
          (above ((repeated rotate90 rot3) pict3)
                 ((repeated rotate90 rot4) pict4)
                 .5)
          .5))
\pbrk
(define (4same pict rot1 rot2 rot3 rot4)
  (4pict pict rot1 pict rot2 pict rot3 pict rot4))
\pbrk
(define (up-push pict n)
  (if (= n 0)
      pict
      (above (up-push pict (-1+ n))
             pict
             .25)))
\pbrk
(define (right-push pict n)
  (if (= n 0)
      pict
      (beside pict (right-push pict (-1+ n)) .75)))

\pbrk
(define (corner-push pict n)
  (if (= n 0)
      pict
      (above
       (beside (up-push pict n)
               (corner-push pict (-1+ n))
               .75)
       (beside
        pict
        (right-push pict (-1+ n))
        .75)
       .25)))
\pbrk
(define (square-limit pict n)
  (4same (corner-push pict n) 1 2 0 3))
\endlisp

\section{Rectangles and primitive pictures}

The rectangle that defines the original screen of the Chipmunk is
defined as:
\beginlisp
(define screen (make-rect (make-vector -190 -190) 
                          (make-vector 380 0)
                          (make-vector 0 380)))
\endlisp

A useful test picture is one that draws the ouline of its given
rectangle: 
\beginlisp
(define outline-picture
  (let ((v1 (make-vector 0 0))
        (v2 (make-vector 1 0))
        (v3 (make-vector 1 1))
        (v4 (make-vector 0 1)))
    (make-picture (list (make-segment v1 v2)
                        (make-segment v2 v3)
                        (make-segment v3 v4)
                        (make-segment v4 v1)))))
\endlisp
With the above, one could, for example, cause the outline rectangle to
be drawn on the full (square) screen by:
\beginlisp
(outline-picture screen)
\endlisp
The following procedure, which applies its argument to the screen after
clearing the graphics screen, will save some typing.
\beginlisp
(define (draw pict)
  (clear-graphics)
  (pict screen))
\endlisp
The definitions below present a few simple (and not very interesting)
patterns.  To gain a better understanding of the square-limit language,
you can play with them, using various combinations of the
operators, and define new primitives.
All the code in this description of the square-limit language may be
loaded by using {\bf load problem set} and specifying {\it problem set number}
as {\it squares}.  Note that this description (and code and suggestions)
are for your edification only.  There is nothing to hand in related to
the square-limit language.
\beginlisp
(define wedge (make-picture
               (list (make-segment (make-vector 0 0)
                                   (make-vector .5 .5))
                     (make-segment (make-vector .5 .5)
                                   (make-vector 1 0)))))

\pbrk
(define line (make-picture
              (list (make-segment (make-vector 0 .5)
                                  (make-vector 1 .5)))))
\pbrk
(define star (make-picture
              (list (make-segment (make-vector 0 .5)
                                  (make-vector .5 0))
                    (make-segment (make-vector .5 0)
                                  (make-vector 1 .5))
                    (make-segment (make-vector 1 .5)
                                  (make-vector .5 1))
                    (make-segment (make-vector .5 1)
                                  (make-vector 0 .5)))))
\endlisp

%end of gobbled chunk

\chapter{2. Laboratory Assignment: A Drawing Language Based on Triangles}

For this assignment, you are to implement a language similar to
Henderson's, except based on triangles rather than squares.  We begin
by describing the implementation, and listing the procedures that have
been installed on the Chipmunk system for you to work with.

The implementation of the language is very similar to the one
described above.

\section{Points and segments}

Points (vectors) are represented as pairs of numbers, and segments are
represented as pairs of points, just as in the square-limit language:
\beginlisp
(define make-vector cons)
(define xcor car)
(define ycor cdr)
\pbrk
(define zero-vector (make-vector 0 0))
\pbrk
(define make-segment cons)
(define seg-start car)
(define seg-end cdr)
\endlisp

We will use the operations of vector addition, subtraction, and
scaling a vector by a number:
\beginlisp
(define (+vect v1 v2)
  (make-vector (+ (xcor v1) (xcor v2))
               (+ (ycor v1) (ycor v2))))
\pbrk
(define (-vect v1 v2)
  (+vect v1 (scale -1 v2)))
\pbrk
(define (scale x v)
  (make-vector (* x (xcor v))
               (* x (ycor v))))
\endlisp

We will also make use of an operation called {\it shift}, which takes as
arguments two vectors {\rm o1} and {\rm o2} and a vector {\rm v} which is
meant to represent a point relative to an ``origin'' {\rm o1}.
{\it Shift} returns a vector that represents the same point as {\rm v},
but with respect to the ``origin'' {\rm o2}.  See figure \figref{2}.
\beginlisp
(define (shift v o1 o2)
  (-vect (+vect v o1) o2))
\endlisp

\beginfigure
\vskip 3truein
\begincaption
Figure \figdef{2}. Shifting a vector from one origin to another.
\endcaption
\endfigure


The following procedure takes 2 points as arguments and draws a line
between them on the Chipmunk screen.

\beginlisp
(define (drawline start end)
  (position-pen (xcor start) (ycor start))
  (draw-line-to (xcor end) (ycor end)))
\endlisp

\section{Triangles}

\beginlisp
(define make-triangle list)
\pbrk
(define origin car)
(define side1 cadr)
(define side2 caddr)
\endlisp


A triangle is represented as a triple of vectors -- an origin and two
sides.  See figure \figref{3}.  The origin will be represented as
a vector whose coordinates give the coordinates of the origin with
respect to some external coordinate system, such as the graphics
screen coordinates.  The two sides are specified as vectors which give
the {\it offsets} of the other two vertices of the triangle from the
origin point.  In other words, they specify the coordinates of the
other two vertices with respect to a coordinate system whose
``origin'' is at the {\it origin} of the triangle.

As shown in figure \figref{3}, we can express the points of a
triangle in terms of so-called {\it triangular coordinates}, which are
pairs $x, y$ such that $x+y \leq 1$.  Another way to
say this is that each point of the triangle can be expressed as a
vector

\math{x \hbox{\bf\  Side}_1(\hbox{\rm Tri}) + y \hbox{\bf\ Side}_2(\hbox{\rm Tri})}
\vpar
where $x+y\leq 1$ and \v{Side}$_1$ and \v{Side}$_2$ are vectors.  Still another way
to express
this is that mapping the point in the plane whose coordinates are $x, y$
to the point given by
\math{\hbox{\bf Origin(Tri)} + x \hbox{\bf\  Side}_1\hbox{\rm (Tri)}
+ y \hbox{\bf\  Side}_2\hbox{\rm (Tri)}}
maps one-half of the unit square onto the given triangle.

\beginlisp
(define (coord-map triangle)
  (lambda (point)
    (+vect
     (+vect (scale (xcor point)
                   (side1 triangle))
            (scale (ycor point)
                   (side2 triangle)))
     (origin triangle))))
\endlisp

\beginfigure
\vskip 3truein
\begincaption
Figure \figdef{3}. A triangle represented as origin and two sides; triangular
coordinates.
\endcaption
\endfigure

Finally, we define a standard {\it screen-triangle}, which is an
isosceles triangle whose base and height are the edges of the Chipmunk
screen:
\beginlisp
(define screen-lower-left (make-vector -190 -190))
(define screen-lower-right (make-vector 190 -190))
(define screen-upper-left (make-vector  -190 190))
\pbrk
(define screen-lower-edge
  (-vect screen-lower-right screen-lower-left))
\pbrk
(define screen-left-edge
  (-vect screen-upper-left screen-lower-left))
\pbrk
(define screen-triangle
  (make-triangle screen-lower-left
                 screen-lower-edge
                 (+vect screen-left-edge
                        (scale 0.5 screen-lower-edge))))
\endlisp

\section{Pictures}

As in the square-limit language, a picture is a procedure, this time a
procedure on triangles, which draws inside the given triangle.
{\it Make-picture} constructs a picture from a list of segments:
\beginlisp
(define (make-picture seglist)
  (lambda (triangle)
    (for-each
     (lambda (segment)
       (drawline ((coord-map triangle) (seg-start segment))
                 ((coord-map triangle) (seg-end segment))))
     seglist)))
\endlisp

Also, as in the square-limit language, we include the following
procedure, which clears the screen and causes a designated picture to
be drawn in the standard {\it screen-triangle}:

\beginlisp
(define (draw pict)
  (clear-graphics)
  (pict screen-triangle))
\endlisp


We will also define some simple pictures to use as drawing elements:
the empty picture, a picture that just outlines the triangle, one that
connects the center of the triangle to the midpoints of the sides, one
that draws a ``band'' across the triangle, and one that draws a ``V''
shape.  Figure \figref{4} shows how these figures are
specified in terms of triangular coordinates.
\beginlisp
(define empty-picture (make-picture '()))
\pbrk
(define outline-picture
  (let ((v1 (make-vector 0 0))
        (v2 (make-vector 0 1))
        (v3 (make-vector 1 0)))
    (make-picture (list (make-segment v1 v2)
                        (make-segment v2 v3)
                        (make-segment v3 v1)))))
\pbrk
(define midpoints
  (let ((center (make-vector (/ 1 3) (/ 1 3)))
        (m1 (make-vector (/ 1 2) 0))
        (m2 (make-vector 0 (/ 1 2)))
        (m3 (make-vector (/ 1 2) (/ 1 2))))
    (make-picture (list (make-segment m1 center)
                        (make-segment m2 center)
                        (make-segment m3 center)))))

\pbrk
(define band
  (let ((a1 (make-vector .4 0))
        (a2 (make-vector .6 0))
        (b1 (make-vector 0 .4))
        (b2 (make-vector 0 .6)))
    (make-picture (list (make-segment a1 b1)
                        (make-segment a2 b2)))))
\pbrk
(define v-shape
  (let ((m1 (make-vector (/ 2 9) (/ 2 9)))
        (m2 (make-vector (/ 4 9) (/ 4 9)))
        (a1 (make-vector (/ 1 3) 0))
        (a2 (make-vector (/ 2 3) 0))
        (b1 (make-vector 0 (/ 1 3)))
        (b2 (make-vector 0 (/ 2 3))))
    (make-picture (list (make-segment a1 m1)
                        (make-segment m1 b1)
                        (make-segment a2 m2)
                        (make-segment m2 b2)))))

\endlisp

\beginfigure
\vskip 3truein
\begincaption
Figure \figdef{4}. Sample pictures, specified using triangular coordinates.
\endcaption
\endfigure

\section{Means of combination}

We define a means of combination, called {\it split}, which takes
as arguments two pictures and a {\it ratio} between 0 and 1.  When given
a triangle as argument, the {\it split} picture first splits the
triangle by dividing {\it side1} of the triangle as specified by the
{\it ratio}.  Then it draws one picture in each subtriangle, as shown in
figure \figref{5}.



\beginfigure
\vskip 3truein
\begincaption
Figure \figdef{5}. The {\it split} combination of two pictures.
\endcaption
\endfigure

The procedure for {\it split} must compute the new origin and sides for
each of the two component triangles.
\beginlisp
(define (split pict1 pict2 ratio)
  (lambda (triangle)
    (define p (scale ratio (side1 triangle)))
    (define oa (origin triangle))
    (define ob (shift p oa zero-vector))
    (pict1 (make-triangle oa p (side2 triangle)))
    (pict2 (make-triangle ob
                          (shift (side1 triangle) oa ob)
                          (shift (side2 triangle) oa ob)))))
\endlisp
Observe how {\it split} computes the two subtriangles, so that these can
be handed to the appropriate {\it pict1} and {\it pict2}: We first compute
the vector {\rm p}, which represents the point on the side where the
triangle is to be split.  (Note that {\rm p} will be given as a vector
with respect to the origin of the triangle to be split.)  The first
subtriangle has origin {\rm oa} the same as the original triangle,
{\it side1} given by {\rm p}, and {\it side2} which is the same as the
{\it side2} of the original triangle.

The second subtriangle has an origin {\rm ob} at the point designated by
{\rm p}, and the other two vertices at the same points as the original
triangle.  However, according to our representation of triangles, we
must express the origin in ``external'' (screen) coordinates, and
express the other two vertices as offsets from the origin of the
triangle.  This is where {\it shift} comes in handy: With respect to the
origin {\rm oa} of the original triangle, the origin of our second
subtriangle is given by the vector {\rm p}.  So to find the coordinates
for {\rm ob}, we {\it shift} {\rm p} from the origin {\rm oa} to an origin
at the zero-vector. Similarly, we can find the correct {\it side1} and
{\it side2} for the second subtriangle by using the fact that these are
the vectors running from {\rm ob} to the endpoints of the sides of the
original triangle: With respect to the {\it old} origin {\rm oa}, these
are just the vectors {\it side1} and {\it side2}.  So to find the offsets
from the {\it new} origin {\rm ob}, we {\it shift side1} and {\it side2}
from {\rm oa} to {\rm ob}.

{\it Split} illustrates a useful general method for specifying new
triangles: Find the vertices of the triangle with respect to some
fixed coordinate system (such as the triangle that is being
decomposed); then use {\it shift} to express points in the external
coordinate system (this is required when specifying an origin for
a new triangle), or as offsets from a new origin (this is required when
specifying the sides of a new triangle).

\chapter{3. To do in lab}

Begin by installing the code for problem set 3 on your floppy disk,
using the {\it load-problem-set} operation documented in the Chipmunk
manual.  The file to be loaded contains all of the code listed above
in section 2.  You will not need to edit or
modify any of it.  The ``modifications file'' for problem set 3 that
will be installed on your disk is an empty file, since for this
problem set you will be writing new procedures, rather than modifying
procedures that we supply.

\section{Part 1}

Draw some pictures to test the procedures.  Use {\it split}
to make various combinations of the pre-defined elementary pictures.

\section{Part 2}

Use {\it split} to define an operation called {\it push} which is
analogous to {\it right-push} of the square-limit language.  Test your
procedure by trying it out on some of the simple figures provided.
Turn in a listing of the procedure.

\section{Part 3}

For this part, you are to define a {\it rotate} operator on pictures.  The
rotation of a picture draws the picture in the specified triangle, but
``rotated'' so that a different vertex of the triangle is taken as the
origin.  See figure \figref{6}.

\beginfigure
\vskip 3truein
\begincaption
Figure \figdef{6}. Rotating and superimposing pictures.
\endcaption
\endfigure


Here is one way to go about defining {\it rotate}: The origin of the new
triangle is at the point specified by {\it side2} of the original
triangle (assuming we are rotating clockwise).  So we compute this new
origin by shifting {\it side2} from the old origin to the zero vector.
(Compare the above explanation of {\it shift}.)  The {\it side1} of the
new triangle ends where the {\it side2} of the original triangle ended.
So we can compute the new {\it side1} by shifting the vector {\it side2}
from the old origin to the new origin.  The {\it side2} of the new
triangle ends at the origin of the old triangle.  With respect to the
old origin, this is the endpoint of the zero vector.  So we can find
the new {\it side2} by shifting the zero vector from the old origin to
the new origin.  Note that in the case of an equilateral triangle, this
operation simply reduces to rotating the picture about the center of the
enclosing triangle.  If
the triangle is not equilateral, then not only does the origin change,
but the picture will be compressed or stretched, depending on the
differnce in the lengths of the sides of the triangle.

Implement the {\it rotate} operation by competing the following
definition: 

\beginlisp
(define (rotate pict)
  (lambda (triangle)
    (let ((new-origin (shift <??> <??> <??>)))
      (pict (make-triangle <??>
                           <??>
                           <??>)))))
\endlisp

Test {\it rotate} on some simple pictures.  Note that
{\it outline-picture} and {\it midpoints} won't look any different when
rotated, so you should use {\it v-shape} or {\it band} to test your
procedure.

Observe that, using {\it rotate}, you can also rotate a picture in the
opposite direction by applying {\it rotate} twice, using {\it repeated}.
(Compare the rotation operators in the square-limit language.)  Turn
in listings of the {\it rotate} procedure.


\section{Part 4}

Define an operator {\it three-fold} which, given a picture, produces the
superposition of three pictures -- the original picture, the picture
rotated once, and the picture rotated twice.  (See figure
\figref{6}.) Test your procedure by defining {\it 3v} and
{\it 3band} to be the three-fold superpositions, respectively, of
{\it v-shape} and {\it band}.

\section{Part 5}

Figure \figref{7} illustrates a means of combination called
{\it 3split}, which takes as its arguments three pictures and two
numbers $r$ and $s$, such that $r+s \leq 1$.  It combines the
pictures as shown in the figure.  (The orientation of the small
triangles is unspecified -- in implementing {\it 3split} you can choose
whichever orientations you wish.)

For this part, you are to implement {\it 3split} and turn in a listing
of your procedure.

This procedure can be rather tricky, especially if you are not used to
expressing points in terms of vectors, so think about it carefully
before you start coding.  A good way to proceed is to take the central
point indicated in figure \figref{7} as $(r,s)$ to be the common
origin of the three new triangles.  Note that this point can be
computed by vector-adding together the {\it origin} of the (original)
triangle, the {\it side1} scaled by $r$, and the {\it side2} scaled by
$s$.  You must now determine the two sides of each
of the three small triangles relative to this origin.

In writing your procedure, you can make good use of the {\it shift}
procedure, as in the implementations of {\it split} and {\it rotate}
discussed above.  Also, a good way to test your procedure is to run it
with all pictures as the {\it outline-picture}, and to draw the
result.

\beginfigure
\vskip 3truein
\begincaption
Figure \figdef{7}. Using {\it 3split} to combine 3 pictures.
\endcaption
\endfigure

\section{Part 6}

The following {\it equal-split} procedure uses {\it 3split} to replicate a
single picture 3 times, splitting the original triangle at the point
where the medians intersect (i.e., the point who triangular
coordinates are (1/3, 1/3).

\beginlisp
(define (equal-split pict)
  (3split pict pict pict (/ 1 3) (/ 1 3)))
\endlisp

We could imagine a generalization of {\it equal-split}, which uses the
same picture three times, but with each of the small triangles rotated
by applying {\it rotate} 0, 1, or 2 times, as specified.  One way to do
this is to define a procedure similar to {\it equal-split}, but which
takes as arguments a picture, and also three numbers -- each of which
is 0, 1, or 2 -- that specify the number of times to repeat the
{\it rotate} operation in generating each picture in the small
triangles.  (You can use {\it repeated} to accomplish the repetitions.)

An alternative method is to use a higher-order procedure, which, given
the three rotation numbers, will generate a procedure that takes a
picture as argument.  In other words, if we call this higher-order
procedure  {\it make-splitter}, then writing
\beginlisp
(define equal-split (make-splitter 0 0 0))
\endlisp
should be an equivalent way to define {\it equal-split}, and
\beginlisp
(define alternate-equal-split (make-splitter 1 0 2))
\endlisp
should produce a procedure that is like {\it equal-split}, but which
rotates the first and third small picture before drawing them.

For this part, you are to implement and turn in a listing of the
{\it make-splitter} procedure.  As a hint, notice the {\it make-splitter}
will have the following form:
\beginlisp
(define (make-splitter r1 r2 r3)
  (lambda (pict)
    ...))
\endlisp

As a test, try drawing
\beginlisp
(define mesh ((make-splitter 0 1 2) band))
\endlisp

Turn in a listing of {\it make-splitter}.

\section{Part 7}

Suppose we use {\it 3split} recursively: split a picture which is itself
a split, and so on.  Here is an extended version of the
{\it equal-split} procedure given above, which performs this splitting
to a specified number of levels:
\beginlisp
(define (rec-equal-split pict levels)
  (if (= levels 0)
      pict
      (let ((p (rec-equal-split pict (-1+ levels))))
        (3split p p p (/ 1 3) (/ 1 3)))))
\endlisp

Now suppose we want to generalize this procedure as in part 6, that is
to have a higher-order procedure that will create things like
{\it rec-equal-split}, except where the splitting ratios of the sides
can be other than one-third.  We want a procedure
{\it make-rec-splitter}, such that {\it rec-equal-split} could be defined as
\beginlisp
(define rec-equal-split (make-rec-splitter (/ 1 3) (/ 1 3)))
\endlisp

Test your procedure by drawing some figures, and turn in a listing.

\section{Part 8}
The procedures of the previous parts on {\it splitting} subdivided a
triangle by choosing a central point as a common vertex for three
sub-triangles, each of which shared a common edge with the original
triangle.  Another way of subdividing a triangle is shown in Figure~\figref{8}.
Here, we can {\it imbed} one triangle inside a second by determining
vertices along each of the three sides of the outer triangle, and
adjusting the coordinates of the inner triangle to fit those vertices.
The boundaries of two triangles will thus share in common only the three
vertices of the inner triangle.
The resulting procedure should draw two pictures, one imbedded within
the other.  

\beginfigure
\vskip 3truein
\begincaption
Figure \figdef{8}. Using {\it imbed} to combine 2 pictures.
\endcaption
\endfigure 

Write a procedure called {\it imbed}, which takes five arguments, three
parameters $q, r, s$, each between 0 and 1, which describe the ratio
along the edge at which to place the vertex (see Figure~\figref{8}) and
two pictures $p1, p2$.  The function should have the following form

\beginlisp
(define (imbed q r s p1 p2)
   (lambda (tri)
    ...))
\endlisp

As was the case in Part 7, you should be able to recursively apply the
procedure {\it imbed} to a picture.

Turn in a listing of your procedure {\it imbed}.


\section{Part 9}

Suppose we apply procedures such as {\it 3split}, which were
written to be applied to triangular pictures, instead to pictures created for
the square limit language?  Will the procedures still work?  Why or why
not?

\section{Part 10}

Suppose we decide to change the representation of vectors so that
{\it make-vector} is now defined as:
\beginlisp
(define make-vector list)
\endlisp

What are the corresponding new definitions of {\it xcor} and {\it ycor}?
What other procedures in the triangle-drawing system must be changed
as a consequence of making this change in the representation for
vectors?

\section{Part 11}

The procedures you have implemented give you a wide choice of things
to experiment with. For example, even if you restrict yourself to a
single picture element, and perform only {\it 3split} to three levels
using a fixed splitting point $(r, s)$, there are still a
tremendous number of variations, since for each {\it 3split} you can
choose to rotate each of the component pictures.  Thus, each level
gives you 27 choices (three orientations for each of three pictures)
and all three levels thus produces $9^3$ possibilities, although many
of these will be the same, due to symmetry of the component figures.

There is nothing to turn in for this part of the assignment, but we
hope you will spend some time experimenting.  The patterns in figure
\figref{1} were produced in just this way, using picture
elements similar to the ones you have here.   Perhaps you can discover a
new kind of pattern?


\end