View subclass: #ScrollingFormView
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'ScrollingForm'!


!ScrollingFormView methodsFor: 'scheduling'!

open
	"create and schedule a StandardSystemView with a ScrollingFormView as 
	subview "

	| topView |
	topView _ StandardSystemView new.
	topView model: self model.
	topView label: 'Scrolling FormView'.
	topView minimumSize: (200 @ 200 min: model boundingBox extent).
	topView maximumSize: model boundingBox extent.
	topView borderWidth: 1.
	topView addSubView: self.
	topView controller open! !

!ScrollingFormView methodsFor: 'display'!

displayView
	"show a form on the screen"

	model
		displayOn: Display
		at: self insetDisplayBox origin
		clippingBox: self insetDisplayBox
		rule: Form over
		mask: Form black! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

ScrollingFormView class
	instanceVariableNames: ''!


!ScrollingFormView class methodsFor: 'examples'!

example
	"ScrollingFormView example"

	self openOn: Form fromUser! !

!ScrollingFormView class methodsFor: 'creation'!

openOn: aForm 
	"create and schedule an instance on aForm"

	| view |
	view _ self new.
	view model: aForm.
	view controller: ScrollingFormController new.
	view open! !

Controller subclass: #ScrollingFormController
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'ScrollingForm'!


!ScrollingFormController methodsFor: 'controller access'!

defaultControllerClass
	"return the default"

	^ScrollingFormController! !

!ScrollingFormController methodsFor: 'scrolling'!

scroll
	"change the offset of the model from the current cursor location by its relative 
	location as long as the red mouse button stays down. Redisplay the view at 
	each change. Also show the cursor as a hand icon while scrolling."

	| box maxOffset oldPoint point relPoint newOffset |
	Cursor hand
		showWhile: 
			[box _ view insetDisplayBox.
			maxOffset _ model boundingBox extent - box extent.
			oldPoint _ Sensor cursorPoint.
			[Sensor redButtonPressed]
				whileTrue: 
					[point _ Sensor cursorPoint.
					oldPoint = point
						ifFalse: 
							[relPoint _ point - oldPoint.
							newOffset _ (model offset + relPoint min: 0 @ 0)
										max: 0 - maxOffset.
							model offset: newOffset.
							view displayView.
							oldPoint _ point]]]! !

!ScrollingFormController methodsFor: 'control activity'!

controlActivity
	"when control is obtained we check if the red button is pressed. If that is the case, we perform the relevant activity"

	Sensor redButtonPressed ifTrue: [self redButtonActivity].
	super controlActivity!

redButtonActivity
	"while the red button is pressed the model in view must be scrolled"

	Sensor redButtonPressed ifTrue: [self scroll]! !

!ScrollingFormController methodsFor: 'control defaults'!

isControlActive
	"obtain control if the cursor is in view and as long as the blue button is not pressed "

	^self viewHasCursor & Sensor blueButtonPressed not! !