MouseMenuController subclass: #MoodViewController
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Monster-demo'!


!MoodViewController methodsFor: 'menu messages'!

makeHappy
self model state: #happy!

makeSad
self model state: #sad! !

!MoodViewController methodsFor: 'initialization'!

initialize
|menu messages|
super initialize.
menu _ PopUpMenu labels: ('happy \ sad') withCRs.
messages _ #(makeHappy makeSad).
self yellowButtonMenu: menu yellowButtonMessages: messages! !

View subclass: #TummyView
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Monster-demo'!


!TummyView methodsFor: 'display'!

displayView
|position|
position _ (self insetDisplayBox topLeft x + 10) @ (self insetDisplayBox center y).
('number of cookies is: ' ,self model tummy printString) asText allBold asParagraph displayAt: position!

update: aParameter
self display! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

TummyView class
	instanceVariableNames: ''!


!TummyView class methodsFor: 'creation'!

openOn: aMonster
|topView tummyView|
topView _ StandardSystemView new.
topView label: 'Monster''s tummy'; minimumSize: 150@50.
tummyView _ TummyView new.
tummyView model: aMonster; controller: TummyViewController new.
tummyView borderWidth: 2; insideColor: Form white.
topView addSubView: tummyView.
topView controller open! !

View subclass: #MoodView
	instanceVariableNames: ''
	classVariableNames: 'BackgroundForm HappyMonsterForm SadMonsterForm '
	poolDictionaries: ''
	category: 'Monster-demo'!


!MoodView methodsFor: 'display'!

displayView
|position form|
self model isHappy ifTrue: 
[form _ MoodView HappyMonsterForm].
self model isHappy ifFalse:
[form _ MoodView SadMonsterForm].
position _ (self insetDisplayBox topLeft x + 10) @ (self insetDisplayBox topLeft y + 10).
form displayAt: position!

update: aParameter
self display! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

MoodView class
	instanceVariableNames: ''!


!MoodView class methodsFor: 'creation'!

openOn: aMonster
|topView moodView |
topView _ StandardSystemView new.
topView label: 'Monster''s mood'; minimumSize: 100@100.
moodView _ MoodView new.
moodView model: aMonster; controller: MoodViewController new.
moodView borderWidth: 2; insideColor: Form white.
topView addSubView: moodView.
topView controller open! !

!MoodView class methodsFor: 'initialization'!

initializeForms
HappyMonsterForm _ Cursor thumbsUp magnifyBy: 4@4.
SadMonsterForm _ Cursor thumbsDown magnifyBy: 4@4.! !

!MoodView class methodsFor: 'access'!

HappyMonsterForm
^ HappyMonsterForm!

HappyMonsterForm: aForm
HappyMonsterForm _ aForm!

SadMonsterForm
^ SadMonsterForm!

SadMonsterForm: aForm
SadMonsterForm _ aForm! !

Object subclass: #Monster
	instanceVariableNames: 'tummy state hunger '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Monster-demo'!


!Monster methodsFor: 'queries'!

isEmpty
^ (self tummy <= 0)!

isFull
^ (self tummy >= self hunger)!

isHappy
^ (self state = #happy)!

isHungry
^ (self hunger > self tummy)!

isSad
^ (self state = #sad)! !

!Monster methodsFor: 'actions'!

eat
(self isFull) ifFalse: [
self tummy: (self tummy + 1). self changed]!

flushTummy
self tummy: 0.
self changed! !

!Monster methodsFor: 'access'!

hunger
^ hunger!

hunger: anInteger
hunger _ anInteger.
self changed!

state
^ state!

state: aSymbol
state _ aSymbol.
((state = #happy) | (state = #sad)) ifFalse: [self notify: 'illegal monster-state = ', aSymbol asString] ifTrue: [self changed]!

tummy
^ tummy!

tummy: anInteger
tummy _ anInteger.
self isFull ifTrue: [self state: #happy].
self isEmpty ifTrue: [self state: #sad].
self changed! !

!Monster methodsFor: 'initialization'!

initialize
self tummy: 0.
self state: #sad.
self hunger: (FillInTheBlank request: 'what is the greed of this\monster (in cookies) ?' withCRs) asNumber! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

Monster class
	instanceVariableNames: ''!


!Monster class methodsFor: 'creation'!

new
^ super new initialize! !

MouseMenuController subclass: #TummyViewController
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Monster-demo'!


!TummyViewController methodsFor: 'initialization'!

initialize
|menu messages|
super initialize.
menu _ PopUpMenu labels: ('eat \ flush') withCRs.
messages _ #(eat flush).
self yellowButtonMenu: menu yellowButtonMessages: messages! !

!TummyViewController methodsFor: 'menu messages'!

eat
self model eat!

flush
self model flushTummy! !