; Cookie Monster test of Knowledge Base toolbox
;
; Conversation in Sesame Street with cookie monster
; who requires a cookie

(define CM-Conversation
  (lambda ()
    
    ; the cookie monster KB and globals
    (let ((CM-KB #f)
          (CM-LastItem #f)
          (CM-AllDone #f))
      
      ; store all patterns for conversation as a pair of the pattern
      ; to match and a procedure to call upon successful match
      (define CM-MakeFact
        (lambda (aPattern aProcedure)
          (cons aPattern aProcedure)))
      
      (define CM-SelectPattern car)
      (define CM-SelectProc cdr)
      
      (define CM-Thank
        (lambda (aList)
          (set! CM-AllDone #t)
          (display "Thank you ... munch munch ... Burp.")
          (newline)))
      
      (define CM-NoWant
        (lambda (aList)
          (display "No want ")
          (set! CM-LastItem (GetAssociationValue 'item aList))
          (CM-DisplayAList CM-LastItem)))
      
      (define CM-Twice
        (lambda (aList)
          (display "Why say ")
          (display (GetAssociationValue 'word aList))
          (display " twice?")))
      
      (define CM-Expletive
        (lambda (aList)
          (display "Please don't get cross!")
          (newline)
          (if CM-LastItem
              (begin (display "Earlier you spoke of ")
                     (CM-DisplayAList CM-LastItem))
              #f)))
      
      (define CM-DisplayAList
        (lambda (aList)
          ; display list without outer brackets
          (if (null? aList)
              #f
              (begin (display (car aList))
                     (display " ")
                     (CM-DisplayAList (cdr aList))))))
      
      (define badWord?
        (lambda (anAL)
          ; is the value of expletive a bad word?
          (member (GetAssociationValue 'expletive anAL)
                  '(damn silly stupid))))
      
      (define CM-InitKB
        (lambda ()
          (set! CM-KB
                (MakeKB
                 (CM-MakeFact
                  (PATTERN ?+ 'cookie ?+) CM-Thank)
                 (CM-MakeFact
                  (PATTERN ?+ 'cookie)    CM-Thank)
                 (CM-MakeFact
                  (PATTERN 'cookie ?+)    CM-Thank)
                 (CM-MakeFact
                  (PATTERN 'cookie)       CM-Thank)
                 
                 (CM-MakeFact
                  (PATTERN ?+ 'cookies ?+) CM-Thank)
                 (CM-MakeFact
                  (PATTERN ?+ 'cookies)    CM-Thank)
                 (CM-MakeFact
                  (PATTERN 'cookies ?+)    CM-Thank)
                 (CM-MakeFact
                  (PATTERN 'cookies)       CM-Thank)
                 
                 (CM-MakeFact
                  (PATTERN ?+ 'some (?+ 'item)) CM-NoWant)
                 (CM-MakeFact
                  (PATTERN 'some (?+ 'item))    CM-NoWant)
                 
                 (CM-MakeFact
                  (PATTERN ?+ (? 'word) (<-? 'word) ?+)
                  CM-Twice)
                 (CM-MakeFact
                  (PATTERN (? 'word) (<-? 'word) ?+)
                  CM-Twice)
                 (CM-MakeFact
                  (PATTERN ?+ (? 'word) (<-? 'word))
                  CM-Twice)
                 (CM-MakeFact
                  (PATTERN (? 'word) (<-? 'word))
                  CM-Twice)
                 
                 (CM-MakeFact
                  (PATTERN ?+ (? 'expletive badWord?) ?+)
                  CM-Expletive)
                 (CM-MakeFact
                  (PATTERN (? 'expletive badWord?) ?+)
                  CM-Expletive)
                 (CM-MakeFact
                  (PATTERN ?+ (? 'expletive badWord?))
                  CM-Expletive)
                 (CM-MakeFact
                  (PATTERN (? 'expletive badWord?))
                  CM-Expletive)
                 
                 (CM-MakeFact
                  (PATTERN ?+)
                  (lambda (aList) (display "Give me cookie!")))))))
      
      (define CM-Read
        (lambda ()
          (let ((sentence #f))
            (newline)
            (display "...> ")
            (set! sentence (read))
            (newline)
            (if (not (pair? sentence))
                (begin (display "Please give your replies as a list")
                       (CM-Read))
                sentence))))
      
      ; continue to request cookie until get one
      ; respond to abuse and repetition
      
      (CM-InitKB)
      (set! CM-AllDone #f)
      (display "Give me cookie!")
      (do ((sentence #f)
           (element #f))
          (CM-AllDone "Goodbye")
          (set! sentence (CM-Read))
          (set! element
                (RetrieveByString CM-KB sentence CM-SelectPattern))
          ((CM-SelectProc (GetFact element)) (GetAList element))))))

(begin
 (display "Type (CM-Conversation) to talk to cookie monster")
 (newline))