(* Copyright 1989 by AT&T Bell Laboratories *)
(* types.sig *)

signature TYPES =
sig

    type tycpos
    type polysign (* = {weakness: int, eq: bool} list *)
    type label (* = symbol *)

    (* absfbpos (abstracted functor body position): where to find
       a type constructor or structure when instantiating a functor body.
       It's either in the parameter or in a sequence of types defined
       or generated by the functor body.

       The list for the PARAM variant is the path through the structure
       instantiation arrays.  For type constructors, the final element is
       the position in a type instantiation array.   A nil list for the PARAM
        variant is used to return the entire parameter structure; it is not
        a valid path for a type constructor.*)
        
    datatype absfbpos = PARAM of int list
                      | SEQind of int * int list
	              | SEQ of int

    datatype eqprop = YES | NO | IND | OBJ | DATA | UNDEF

    val infinity : int

    type tyvar  (* = tvinfo ref *)

    datatype tvinfo		(* type variable info *)
      = INSTANTIATED of ty
      | OPEN of {depth: int,
	         weakness: int,
	         eq: bool,
	         kind: tvkind}

    and tvkind
	(* metavariables:
		depth = infinity for metaargs
		depth < infinity for lambda bound
	*)
      = META
	(* user bound type variables *)
      | UBOUND of Symbol.symbol		(* user name of variable *)
	(* flex record variables *)
      | FLEX of (label * ty) list	(* field name, field type pairs *)

    and datacon  (* exceptions are a special case with rep=VARIABLE() *)
      = DATACON of
	  {name  : Symbol.symbol,
	   const : bool,
	   typ   : ty,
	   rep   : Access.conrep,
	   sign  : Access.conrep list}

    and tyckind
      = PRIMtyc  		     (* primitive type constructors like int *)
      | ABStyc of tycon	     (* abstract type constructors formed by abstype *)
      | DATAtyc of datacon list      (* datatype constructors *)
      | FORMtyck

    and tycon
      = GENtyc of {stamp : Stamps.stamp, 
		   arity : int, 
		   eq    : eqprop ref,
		   path  : Symbol.symbol list,
		   kind	 : tyckind ref}
      | DEFtyc of {path  : Symbol.symbol list,
		   strict: bool list,
		   tyfun : tyfun}
      | RECORDtyc of label list
      | FORMtyc of {pos : int, spec : tycon, name : Symbol.symbol}
      | OPENFORMtyc of {pos: tycpos, spec : tycon, name : Symbol.symbol list}
      | RELtyc of  {pos : tycpos, name : Symbol.symbol list}
      | ABSFBtyc of absfbpos
(*      | PARSEtyc of Symbol.symbol list *)
      | ERRORtyc
      | FULLtyc
 
    and ty 
      = VARty of tyvar
      | CONty of tycon * ty list
	(* inferred bound type variables -- indexed *)
      | IBOUND of int
      | WILDCARDty
      | POLYty of {sign: {weakness:int, eq:bool} list, tyfun: tyfun, abs: int}
      | UNDEFty

    and tyfun
      = TYFUN of
          {arity : int,
	   body : ty}

    val mkTyvar   : tvinfo -> tyvar
    val bogusCON : datacon
    val bogusEXN : datacon

end (* signature TYPES *)
